/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.asyncexecutor;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.api.JobInfo;
import org.flowable.job.service.impl.asyncexecutor.AbstractAsyncExecutor;
import org.flowable.job.service.impl.util.CommandContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAsyncJobExecutor
extends AbstractAsyncExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAsyncJobExecutor.class);
    protected boolean isAsyncJobAcquisitionEnabled = true;
    protected boolean isTimerJobAcquisitionEnabled = true;
    protected boolean isResetExpiredJobEnabled = true;
    protected Thread asyncJobAcquisitionThread;
    protected Thread timerJobAcquisitionThread;
    protected Thread resetExpiredJobThread;
    protected int corePoolSize = 2;
    protected int maxPoolSize = 10;
    protected long keepAliveTime = 5000L;
    protected int queueSize = 100;
    protected boolean unlockOwnedJobs;
    protected BlockingQueue<Runnable> threadPoolQueue;
    protected ExecutorService executorService;
    protected long secondsToWaitOnShutdown = 60L;
    protected String threadPoolNamingPattern = "flowable-async-job-executor-thread-%d";

    @Override
    protected boolean executeAsyncJob(JobInfo job, Runnable runnable) {
        try {
            this.executorService.execute(runnable);
            return true;
        }
        catch (RejectedExecutionException e) {
            this.unacquireJobAfterRejection(job);
            return false;
        }
    }

    protected void unacquireJobAfterRejection(final JobInfo job) {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null) {
            CommandContextUtil.getJobManager(commandContext).unacquire(job);
        } else {
            this.jobServiceConfiguration.getCommandExecutor().execute((Command)new Command<Void>(){

                public Void execute(CommandContext commandContext) {
                    CommandContextUtil.getJobManager(commandContext).unacquire(job);
                    return null;
                }
            });
        }
    }

    @Override
    protected void startAdditionalComponents() {
        if (!this.isMessageQueueMode) {
            this.initAsyncJobExecutionThreadPool();
            this.startJobAcquisitionThread();
        }
        if (this.unlockOwnedJobs) {
            this.unlockOwnedJobs();
        }
        if (this.timerRunnableNeeded) {
            this.startTimerAcquisitionThread();
        }
        this.startResetExpiredJobsThread();
    }

    @Override
    protected void shutdownAdditionalComponents() {
        this.stopResetExpiredJobsThread();
        this.stopTimerAcquisitionThread();
        this.stopJobAcquisitionThread();
        this.stopExecutingAsyncJobs();
        if (this.unlockOwnedJobs) {
            this.unlockOwnedJobs();
        }
    }

    protected void initAsyncJobExecutionThreadPool() {
        if (this.threadPoolQueue == null) {
            LOGGER.info("Creating thread pool queue of size {}", (Object)this.queueSize);
            this.threadPoolQueue = new ArrayBlockingQueue<Runnable>(this.queueSize);
        }
        if (this.executorService == null) {
            LOGGER.info("Creating executor service with corePoolSize {}, maxPoolSize {} and keepAliveTime {}", new Object[]{this.corePoolSize, this.maxPoolSize, this.keepAliveTime});
            BasicThreadFactory threadFactory = new BasicThreadFactory.Builder().namingPattern(this.threadPoolNamingPattern).build();
            this.executorService = new ThreadPoolExecutor(this.corePoolSize, this.maxPoolSize, this.keepAliveTime, TimeUnit.MILLISECONDS, this.threadPoolQueue, (ThreadFactory)threadFactory);
        }
    }

    protected void stopExecutingAsyncJobs() {
        if (this.executorService != null) {
            this.executorService.shutdown();
            try {
                if (!this.executorService.awaitTermination(this.secondsToWaitOnShutdown, TimeUnit.SECONDS)) {
                    LOGGER.warn("Timeout during shutdown of async job executor. The current running jobs could not end within {} seconds after shutdown operation.", (Object)this.secondsToWaitOnShutdown);
                }
            }
            catch (InterruptedException e) {
                LOGGER.warn("Interrupted while shutting down the async job executor. ", (Throwable)e);
            }
            this.executorService = null;
        }
    }

    protected void startJobAcquisitionThread() {
        if (this.isAsyncJobAcquisitionEnabled) {
            if (this.asyncJobAcquisitionThread == null) {
                this.asyncJobAcquisitionThread = new Thread(this.asyncJobsDueRunnable);
            }
            this.asyncJobAcquisitionThread.start();
        }
    }

    protected void startTimerAcquisitionThread() {
        if (this.isTimerJobAcquisitionEnabled) {
            if (this.timerJobAcquisitionThread == null) {
                this.timerJobAcquisitionThread = new Thread(this.timerJobRunnable);
            }
            this.timerJobAcquisitionThread.start();
        }
    }

    protected void stopJobAcquisitionThread() {
        if (this.asyncJobAcquisitionThread != null) {
            try {
                this.asyncJobAcquisitionThread.join();
            }
            catch (InterruptedException e) {
                LOGGER.warn("Interrupted while waiting for the async job acquisition thread to terminate", (Throwable)e);
            }
            this.asyncJobAcquisitionThread = null;
        }
    }

    protected void stopTimerAcquisitionThread() {
        if (this.timerJobAcquisitionThread != null) {
            try {
                this.timerJobAcquisitionThread.join();
            }
            catch (InterruptedException e) {
                LOGGER.warn("Interrupted while waiting for the timer job acquisition thread to terminate", (Throwable)e);
            }
            this.timerJobAcquisitionThread = null;
        }
    }

    protected void startResetExpiredJobsThread() {
        if (this.isResetExpiredJobEnabled) {
            if (this.resetExpiredJobThread == null) {
                this.resetExpiredJobThread = new Thread(this.resetExpiredJobsRunnable);
            }
            this.resetExpiredJobThread.start();
        }
    }

    protected void stopResetExpiredJobsThread() {
        if (this.resetExpiredJobThread != null) {
            try {
                this.resetExpiredJobThread.join();
            }
            catch (InterruptedException e) {
                LOGGER.warn("Interrupted while waiting for the reset expired jobs thread to terminate", (Throwable)e);
            }
            this.resetExpiredJobThread = null;
        }
    }

    public boolean isAsyncJobAcquisitionEnabled() {
        return this.isAsyncJobAcquisitionEnabled;
    }

    public void setAsyncJobAcquisitionEnabled(boolean isAsyncJobAcquisitionEnabled) {
        this.isAsyncJobAcquisitionEnabled = isAsyncJobAcquisitionEnabled;
    }

    public boolean isTimerJobAcquisitionEnabled() {
        return this.isTimerJobAcquisitionEnabled;
    }

    public void setTimerJobAcquisitionEnabled(boolean isTimerJobAcquisitionEnabled) {
        this.isTimerJobAcquisitionEnabled = isTimerJobAcquisitionEnabled;
    }

    public boolean isResetExpiredJobEnabled() {
        return this.isResetExpiredJobEnabled;
    }

    public void setResetExpiredJobEnabled(boolean isResetExpiredJobEnabled) {
        this.isResetExpiredJobEnabled = isResetExpiredJobEnabled;
    }

    public Thread getTimerJobAcquisitionThread() {
        return this.timerJobAcquisitionThread;
    }

    public void setTimerJobAcquisitionThread(Thread timerJobAcquisitionThread) {
        this.timerJobAcquisitionThread = timerJobAcquisitionThread;
    }

    public Thread getAsyncJobAcquisitionThread() {
        return this.asyncJobAcquisitionThread;
    }

    public void setAsyncJobAcquisitionThread(Thread asyncJobAcquisitionThread) {
        this.asyncJobAcquisitionThread = asyncJobAcquisitionThread;
    }

    public Thread getResetExpiredJobThread() {
        return this.resetExpiredJobThread;
    }

    public void setResetExpiredJobThread(Thread resetExpiredJobThread) {
        this.resetExpiredJobThread = resetExpiredJobThread;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    @Override
    public int getRemainingCapacity() {
        if (this.threadPoolQueue != null) {
            return this.threadPoolQueue.remainingCapacity();
        }
        return 99;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public long getSecondsToWaitOnShutdown() {
        return this.secondsToWaitOnShutdown;
    }

    public void setSecondsToWaitOnShutdown(long secondsToWaitOnShutdown) {
        this.secondsToWaitOnShutdown = secondsToWaitOnShutdown;
    }

    public boolean isUnlockOwnedJobs() {
        return this.unlockOwnedJobs;
    }

    public void setUnlockOwnedJobs(boolean unlockOwnedJobs) {
        this.unlockOwnedJobs = unlockOwnedJobs;
    }

    public BlockingQueue<Runnable> getThreadPoolQueue() {
        return this.threadPoolQueue;
    }

    public void setThreadPoolQueue(BlockingQueue<Runnable> threadPoolQueue) {
        this.threadPoolQueue = threadPoolQueue;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public String getThreadPoolNamingPattern() {
        return this.threadPoolNamingPattern;
    }

    public void setThreadPoolNamingPattern(String threadPoolNamingPattern) {
        this.threadPoolNamingPattern = threadPoolNamingPattern;
    }
}

