/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.persistence.entity;

import java.util.List;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.persistence.entity.data.DataManager;
import org.flowable.job.api.Job;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.event.impl.FlowableJobEventBuilder;
import org.flowable.job.service.impl.JobQueryImpl;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.job.service.impl.persistence.entity.JobEntityManager;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntityManagerImpl;
import org.flowable.job.service.impl.persistence.entity.data.JobDataManager;

public class JobEntityManagerImpl
extends JobInfoEntityManagerImpl<JobEntity>
implements JobEntityManager {
    protected JobDataManager jobDataManager;

    public JobEntityManagerImpl(JobServiceConfiguration jobServiceConfiguration, JobDataManager jobDataManager) {
        super(jobServiceConfiguration, jobDataManager);
        this.jobDataManager = jobDataManager;
    }

    @Override
    protected DataManager<JobEntity> getDataManager() {
        return this.jobDataManager;
    }

    @Override
    public boolean insertJobEntity(JobEntity timerJobEntity) {
        return this.doInsert(timerJobEntity, true);
    }

    @Override
    public void insert(JobEntity jobEntity, boolean fireCreateEvent) {
        this.doInsert(jobEntity, fireCreateEvent);
    }

    protected boolean doInsert(JobEntity jobEntity, boolean fireCreateEvent) {
        boolean handledJob;
        if (this.getJobServiceConfiguration().getInternalJobManager() != null && !(handledJob = this.getJobServiceConfiguration().getInternalJobManager().handleJobInsert(jobEntity))) {
            return false;
        }
        jobEntity.setCreateTime(this.getJobServiceConfiguration().getClock().getCurrentTime());
        super.insert(jobEntity, fireCreateEvent);
        return true;
    }

    @Override
    public List<Job> findJobsByQueryCriteria(JobQueryImpl jobQuery) {
        return this.jobDataManager.findJobsByQueryCriteria(jobQuery);
    }

    @Override
    public long findJobCountByQueryCriteria(JobQueryImpl jobQuery) {
        return this.jobDataManager.findJobCountByQueryCriteria(jobQuery);
    }

    @Override
    public void delete(JobEntity jobEntity) {
        super.delete(jobEntity);
        this.deleteByteArrayRef(jobEntity.getExceptionByteArrayRef());
        this.deleteByteArrayRef(jobEntity.getCustomValuesByteArrayRef());
        FlowableEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableJobEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_DELETED, this));
        }
    }

    @Override
    public void delete(JobEntity entity, boolean fireDeleteEvent) {
        if (this.getJobServiceConfiguration().getInternalJobManager() != null) {
            this.getJobServiceConfiguration().getInternalJobManager().handleJobDelete(entity);
        }
        super.delete(entity, fireDeleteEvent);
    }

    public JobDataManager getJobDataManager() {
        return this.jobDataManager;
    }

    public void setJobDataManager(JobDataManager jobDataManager) {
        this.jobDataManager = jobDataManager;
    }
}

