/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.history.async.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.job.api.HistoryJob;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.HistoryJobQueryImpl;
import org.flowable.job.service.impl.history.async.message.AsyncHistoryJobMessageHandler;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntityManager;

public class AsyncHistoryJobMessageReceiver {
    protected CommandExecutor commandExecutor;
    protected AsyncHistoryJobMessageHandler asyncHistoryJobMessageHandler;
    protected JobServiceConfiguration jobServiceConfiguration;

    public AsyncHistoryJobMessageReceiver(CommandExecutor commandExecutor, AsyncHistoryJobMessageHandler asyncHistoryJobMessageHandler, JobServiceConfiguration jobServiceConfiguration) {
        this.commandExecutor = commandExecutor;
        this.asyncHistoryJobMessageHandler = asyncHistoryJobMessageHandler;
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    public void messageForJobReceived(final String jobId) {
        if (this.commandExecutor == null) {
            throw new FlowableException("Programmatic error: this class needs a CommandExecutor instance");
        }
        if (this.asyncHistoryJobMessageHandler == null) {
            throw new FlowableException("Programmatic error: this class needs an AsyncHistoryJobMessageHandler instance.");
        }
        this.commandExecutor.execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                HistoryJobEntityManager historyJobEntityManager = AsyncHistoryJobMessageReceiver.this.jobServiceConfiguration.getHistoryJobEntityManager();
                HistoryJobQueryImpl query = new HistoryJobQueryImpl(commandContext, AsyncHistoryJobMessageReceiver.this.jobServiceConfiguration);
                query.jobId(jobId);
                List<HistoryJob> jobs = historyJobEntityManager.findHistoryJobsByQueryCriteria(query);
                if (jobs == null || jobs.isEmpty()) {
                    throw new FlowableException("No history job found for id " + jobId);
                }
                if (jobs.size() > 1) {
                    throw new FlowableException("Multiple results for history job id " + jobId);
                }
                if (!(jobs.get(0) instanceof HistoryJobEntity)) {
                    throw new FlowableException("Job with id " + jobId + " is not an instance of history job entity, cannot handle this job");
                }
                HistoryJobEntity historyJobEntity = (HistoryJobEntity)jobs.get(0);
                if (AsyncHistoryJobMessageReceiver.this.asyncHistoryJobMessageHandler.handleJob(historyJobEntity, AsyncHistoryJobMessageReceiver.this.getHistoryJobData(commandContext, historyJobEntity))) {
                    historyJobEntityManager.delete(historyJobEntity);
                }
                return null;
            }
        });
    }

    protected JsonNode getHistoryJobData(CommandContext commandContext, HistoryJobEntity job) {
        ObjectMapper objectMapper = this.jobServiceConfiguration.getObjectMapper();
        if (job.getAdvancedJobHandlerConfigurationByteArrayRef() != null) {
            try {
                return objectMapper.readTree(job.getAdvancedJobHandlerConfigurationByteArrayRef().getBytes(this.jobServiceConfiguration.getEngineName()));
            }
            catch (IOException e) {
                throw new FlowableException("Could not deserialize json for history job data", (Throwable)e);
            }
        }
        return null;
    }

    public CommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public void setCommandExecutor(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    public AsyncHistoryJobMessageHandler getAsyncHistoryJobMessageHandler() {
        return this.asyncHistoryJobMessageHandler;
    }

    public void setAsyncHistoryJobMessageHandler(AsyncHistoryJobMessageHandler asyncHistoryJobMessageHandler) {
        this.asyncHistoryJobMessageHandler = asyncHistoryJobMessageHandler;
    }
}

