/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.asyncexecutor;

import java.util.ArrayList;
import java.util.List;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableOptimisticLockingException;
import org.flowable.common.engine.api.tenant.TenantContext;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.tenant.CurrentTenant;
import org.flowable.job.api.HistoryJob;
import org.flowable.job.api.Job;
import org.flowable.job.api.JobInfo;
import org.flowable.job.service.InternalJobCompatibilityManager;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.asyncexecutor.AsyncRunnableExecutionExceptionHandler;
import org.flowable.job.service.impl.cmd.ExecuteAsyncRunnableJobCmd;
import org.flowable.job.service.impl.cmd.LockExclusiveJobCmd;
import org.flowable.job.service.impl.cmd.UnlockExclusiveJobCmd;
import org.flowable.job.service.impl.persistence.entity.AbstractRuntimeJobEntity;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntity;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteAsyncRunnable
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecuteAsyncRunnable.class);
    protected final JobInfo job;
    protected JobServiceConfiguration jobServiceConfiguration;
    protected JobInfoEntityManager<? extends JobInfoEntity> jobEntityManager;
    protected List<AsyncRunnableExecutionExceptionHandler> asyncRunnableExecutionExceptionHandlers;

    public ExecuteAsyncRunnable(JobInfo job, JobServiceConfiguration jobServiceConfiguration, JobInfoEntityManager<? extends JobInfoEntity> jobEntityManager, AsyncRunnableExecutionExceptionHandler asyncRunnableExecutionExceptionHandler) {
        this.job = job;
        this.jobServiceConfiguration = jobServiceConfiguration;
        this.jobEntityManager = jobEntityManager;
        this.asyncRunnableExecutionExceptionHandlers = this.initializeExceptionHandlers(jobServiceConfiguration, asyncRunnableExecutionExceptionHandler);
    }

    private List<AsyncRunnableExecutionExceptionHandler> initializeExceptionHandlers(JobServiceConfiguration jobServiceConfiguration, AsyncRunnableExecutionExceptionHandler asyncRunnableExecutionExceptionHandler) {
        ArrayList<AsyncRunnableExecutionExceptionHandler> asyncRunnableExecutionExceptionHandlers = new ArrayList<AsyncRunnableExecutionExceptionHandler>();
        if (asyncRunnableExecutionExceptionHandler != null) {
            asyncRunnableExecutionExceptionHandlers.add(asyncRunnableExecutionExceptionHandler);
        }
        if (jobServiceConfiguration.getAsyncRunnableExecutionExceptionHandlers() != null) {
            asyncRunnableExecutionExceptionHandlers.addAll(jobServiceConfiguration.getAsyncRunnableExecutionExceptionHandlers());
        }
        return asyncRunnableExecutionExceptionHandlers;
    }

    @Override
    public void run() {
        TenantContext tenantContext = CurrentTenant.getTenantContext();
        try {
            tenantContext.setTenantId(this.job.getTenantId());
            this.runInternally();
        }
        finally {
            tenantContext.clearTenantId();
        }
    }

    protected void runInternally() {
        if (this.job instanceof Job) {
            Job jobObject = (Job)this.job;
            InternalJobCompatibilityManager internalJobCompatibilityManager = this.jobServiceConfiguration.getInternalJobCompatibilityManager();
            if (internalJobCompatibilityManager != null && internalJobCompatibilityManager.isFlowable5Job(jobObject)) {
                internalJobCompatibilityManager.executeV5JobWithLockAndRetry(jobObject);
                return;
            }
        }
        if (this.job instanceof AbstractRuntimeJobEntity) {
            boolean lockingNeeded = ((AbstractRuntimeJobEntity)this.job).isExclusive();
            boolean executeJob = true;
            if (lockingNeeded) {
                executeJob = this.lockJob();
            }
            if (executeJob) {
                this.executeJob(lockingNeeded);
            }
        } else {
            this.executeJob(false);
        }
    }

    protected void executeJob(boolean unlock) {
        try {
            this.jobServiceConfiguration.getCommandExecutor().execute((Command)new ExecuteAsyncRunnableJobCmd(this.job.getId(), this.jobEntityManager, this.jobServiceConfiguration, unlock));
        }
        catch (FlowableOptimisticLockingException e) {
            try {
                this.handleFailedJob(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Optimistic locking exception during job execution. If you have multiple async executors running against the same database, this exception means that this thread tried to acquire an exclusive job, which already was changed by another async executor thread.This is expected behavior in a clustered environment. You can ignore this message if you indeed have multiple job executor threads running against the same database. Exception message: {}", (Object)e.getMessage());
            }
        }
        catch (Throwable exception) {
            this.handleFailedJob(exception);
        }
    }

    protected void unlockJobIfNeeded() {
        if (this.job instanceof HistoryJob) {
            return;
        }
        Job job = (Job)this.job;
        try {
            if (job.isExclusive()) {
                this.jobServiceConfiguration.getCommandExecutor().execute((Command)new UnlockExclusiveJobCmd(job, this.jobServiceConfiguration));
            }
        }
        catch (FlowableOptimisticLockingException optimisticLockingException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Optimistic locking exception while unlocking the job. If you have multiple async executors running against the same database, this exception means that this thread tried to acquire an exclusive job, which already was changed by another async executor thread.This is expected behavior in a clustered environment. You can ignore this message if you indeed have multiple job executor acquisition threads running against the same database. Exception message: {}", (Object)optimisticLockingException.getMessage());
            }
        }
        catch (Throwable t) {
            LOGGER.error("Error while unlocking exclusive job {}", (Object)job.getId(), (Object)t);
        }
    }

    protected boolean lockJob() {
        Job job = (Job)this.job;
        try {
            this.jobServiceConfiguration.getCommandExecutor().execute((Command)new LockExclusiveJobCmd(job, this.jobServiceConfiguration));
        }
        catch (Throwable lockException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Could not lock exclusive job. Unlocking job so it can be acquired again. Caught exception: {}", (Object)lockException.getMessage());
            }
            this.unacquireJob();
            return false;
        }
        return true;
    }

    protected void unacquireJob() {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null) {
            this.jobServiceConfiguration.getJobManager().unacquire(this.job);
        } else {
            this.jobServiceConfiguration.getCommandExecutor().execute((Command)new Command<Void>(){

                public Void execute(CommandContext commandContext) {
                    ExecuteAsyncRunnable.this.jobServiceConfiguration.getJobManager().unacquire(ExecuteAsyncRunnable.this.job);
                    return null;
                }
            });
        }
    }

    protected void handleFailedJob(Throwable exception) {
        for (AsyncRunnableExecutionExceptionHandler asyncRunnableExecutionExceptionHandler : this.asyncRunnableExecutionExceptionHandlers) {
            if (!asyncRunnableExecutionExceptionHandler.handleException(this.jobServiceConfiguration, this.job, exception)) continue;
            this.unlockJobIfNeeded();
            return;
        }
        LOGGER.error("Unable to handle exception {} for job {}.", (Object)exception, (Object)this.job);
        throw new FlowableException("Unable to handle exception " + exception.getMessage() + " for " + this.job + ".", exception);
    }
}

