/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.validation.validator.impl;

import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.Signal;
import org.flowable.validation.ValidationError;
import org.flowable.validation.validator.ValidatorImpl;

public class SignalValidator
extends ValidatorImpl {
    @Override
    public void validate(BpmnModel bpmnModel, List<ValidationError> errors) {
        Collection signals = bpmnModel.getSignals();
        if (signals != null && !signals.isEmpty()) {
            for (Signal signal : signals) {
                if (StringUtils.isEmpty((CharSequence)signal.getId())) {
                    this.addError(errors, "flowable-signal-missing-id", (BaseElement)signal, "Signal must have an id");
                }
                if (StringUtils.isEmpty((CharSequence)signal.getName())) {
                    this.addError(errors, "flowable-signal-missing-name", (BaseElement)signal, "Signal must have a name");
                }
                if (!StringUtils.isEmpty((CharSequence)signal.getName()) && this.duplicateName(signals, signal.getId(), signal.getName())) {
                    this.addError(errors, "flowable-signal-duplicate-name", (BaseElement)signal, "Duplicate signal name found");
                }
                if (signal.getScope() == null || signal.getScope().equals("global") || signal.getScope().equals("processInstance")) continue;
                this.addError(errors, "flowable-signal-invalid-scope", (BaseElement)signal, "Invalid value for 'scope'. Only values 'global' and 'processInstance' are supported");
            }
        }
    }

    protected boolean duplicateName(Collection<Signal> signals, String id, String name) {
        for (Signal signal : signals) {
            if (id == null || signal.getId() == null || !name.equals(signal.getName()) || id.equals(signal.getId())) continue;
            return true;
        }
        return false;
    }
}

