/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.flowable.common.spring.CommonAutoDeploymentProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="flowable.auto-deployment")
public class FlowableAutoDeploymentProperties {
    private boolean useLock = false;
    private Duration lockWaitTime = Duration.ofMinutes(5L);
    private boolean throwExceptionOnDeploymentFailure = true;
    private String lockName;
    private Map<String, EngineDeploymentProperties> engine = new HashMap<String, EngineDeploymentProperties>();

    public boolean isUseLock() {
        return this.useLock;
    }

    public void setUseLock(boolean useLock) {
        this.useLock = useLock;
    }

    public Duration getLockWaitTime() {
        return this.lockWaitTime;
    }

    public void setLockWaitTime(Duration lockWaitTime) {
        this.lockWaitTime = lockWaitTime;
    }

    public boolean isThrowExceptionOnDeploymentFailure() {
        return this.throwExceptionOnDeploymentFailure;
    }

    public void setThrowExceptionOnDeploymentFailure(boolean throwExceptionOnDeploymentFailure) {
        this.throwExceptionOnDeploymentFailure = throwExceptionOnDeploymentFailure;
    }

    public String getLockName() {
        return this.lockName;
    }

    public void setLockName(String lockName) {
        this.lockName = lockName;
    }

    public Map<String, EngineDeploymentProperties> getEngine() {
        return this.engine;
    }

    public void setEngine(Map<String, EngineDeploymentProperties> engine) {
        this.engine = engine;
    }

    public CommonAutoDeploymentProperties deploymentPropertiesForEngine(String engineType) {
        CommonAutoDeploymentProperties properties = new CommonAutoDeploymentProperties();
        EngineDeploymentProperties engineSpecificProperties = this.engine.get(engineType);
        if (engineSpecificProperties == null) {
            properties.setUseLock(this.useLock);
            properties.setLockWaitTime(this.lockWaitTime);
            properties.setThrowExceptionOnDeploymentFailure(this.throwExceptionOnDeploymentFailure);
            properties.setLockName(this.lockName);
        } else {
            properties.setUseLock(this.defaultIfNotNull(engineSpecificProperties.getUseLock(), this.useLock).booleanValue());
            properties.setLockWaitTime(this.defaultIfNotNull(engineSpecificProperties.getLockWaitTime(), this.lockWaitTime));
            properties.setThrowExceptionOnDeploymentFailure(this.defaultIfNotNull(engineSpecificProperties.getThrowExceptionOnDeploymentFailure(), this.throwExceptionOnDeploymentFailure).booleanValue());
            properties.setLockName(this.defaultIfNotNull(engineSpecificProperties.getLockName(), this.lockName));
        }
        return properties;
    }

    protected <T> T defaultIfNotNull(T value, T defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static class EngineDeploymentProperties {
        private Boolean useLock;
        private Duration lockWaitTime;
        private Boolean throwExceptionOnDeploymentFailure;
        private String lockName;

        public Boolean getUseLock() {
            return this.useLock;
        }

        public void setUseLock(Boolean useLock) {
            this.useLock = useLock;
        }

        public Duration getLockWaitTime() {
            return this.lockWaitTime;
        }

        public void setLockWaitTime(Duration lockWaitTime) {
            this.lockWaitTime = lockWaitTime;
        }

        public Boolean getThrowExceptionOnDeploymentFailure() {
            return this.throwExceptionOnDeploymentFailure;
        }

        public void setThrowExceptionOnDeploymentFailure(Boolean throwExceptionOnDeploymentFailure) {
            this.throwExceptionOnDeploymentFailure = throwExceptionOnDeploymentFailure;
        }

        public String getLockName() {
            return this.lockName;
        }

        public void setLockName(String lockName) {
            this.lockName = lockName;
        }
    }
}

