/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot.eventregistry;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import org.flowable.spring.boot.FlowableServlet;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(prefix="flowable.eventregistry")
public class FlowableEventRegistryProperties {
    private String deploymentName = "SpringBootAutoDeployment";
    private String resourceLocation = "classpath*:/eventregistry/";
    private List<String> resourceSuffixes = Arrays.asList("**.event", "**.channel");
    private boolean deployResources = true;
    private boolean enableChangeDetection = false;
    private Duration changeDetectionInitialDelay = Duration.ofSeconds(10L);
    private Duration changeDetectionDelay = Duration.ofSeconds(60L);
    private boolean enabled = true;
    @NestedConfigurationProperty
    private final FlowableServlet servlet = new FlowableServlet("/event-registry-api", "Flowable Event Registry Rest API");

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public void setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
    }

    public String getResourceLocation() {
        return this.resourceLocation;
    }

    public void setResourceLocation(String resourceLocation) {
        this.resourceLocation = resourceLocation;
    }

    public List<String> getResourceSuffixes() {
        return this.resourceSuffixes;
    }

    public void setResourceSuffixes(List<String> resourceSuffixes) {
        this.resourceSuffixes = resourceSuffixes;
    }

    public boolean isDeployResources() {
        return this.deployResources;
    }

    public void setDeployResources(boolean deployResources) {
        this.deployResources = deployResources;
    }

    public boolean isEnableChangeDetection() {
        return this.enableChangeDetection;
    }

    public void setEnableChangeDetection(boolean enableChangeDetection) {
        this.enableChangeDetection = enableChangeDetection;
    }

    public Duration getChangeDetectionInitialDelay() {
        return this.changeDetectionInitialDelay;
    }

    public void setChangeDetectionInitialDelay(Duration changeDetectionInitialDelay) {
        this.changeDetectionInitialDelay = changeDetectionInitialDelay;
    }

    public Duration getChangeDetectionDelay() {
        return this.changeDetectionDelay;
    }

    public void setChangeDetectionDelay(Duration changeDetectionDelay) {
        this.changeDetectionDelay = changeDetectionDelay;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public FlowableServlet getServlet() {
        return this.servlet;
    }
}

