/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.conditions;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.fluentlenium.core.conditions.Conditions;
import org.fluentlenium.core.conditions.ConditionsObject;
import org.fluentlenium.core.conditions.ListConditionsElements;
import org.fluentlenium.core.domain.FluentWebElement;

public class BaseObjectListConditions<T, C extends Conditions<T>>
implements ConditionsObject<List<T>> {
    protected Conditions<FluentWebElement> conditions;
    protected final Function<FluentWebElement, T> objectGetter;
    protected final Function<FluentWebElement, C> conditionsGetter;

    public BaseObjectListConditions(Conditions<FluentWebElement> conditions, Function<FluentWebElement, T> objectGetter, Function<FluentWebElement, C> conditionsGetter) {
        this.conditions = conditions;
        this.objectGetter = objectGetter;
        this.conditionsGetter = conditionsGetter;
    }

    @Override
    public List<T> getActualObject() {
        if (this.conditions instanceof ListConditionsElements) {
            List<? extends FluentWebElement> elements = ((ListConditionsElements)((Object)this.conditions)).getActualElements();
            return elements.stream().map(this.objectGetter).collect(Collectors.toList());
        }
        return new ArrayList();
    }

    public boolean verify(Predicate<T> predicate) {
        return this.conditions.verify(input -> predicate.test(this.objectGetter.apply((FluentWebElement)input)));
    }
}

