/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.dbsupport.redshift;

import java.sql.SQLException;
import java.util.List;
import org.flywaydb.core.internal.dbsupport.JdbcTemplate;
import org.flywaydb.core.internal.dbsupport.Table;
import org.flywaydb.core.internal.dbsupport.postgresql.PostgreSQLDbSupport;
import org.flywaydb.core.internal.dbsupport.postgresql.PostgreSQLSchema;
import org.flywaydb.core.internal.dbsupport.redshift.RedshiftTable;

public class RedshiftSchema
extends PostgreSQLSchema {
    public RedshiftSchema(JdbcTemplate jdbcTemplate, PostgreSQLDbSupport dbSupport, String name) {
        super(jdbcTemplate, dbSupport, name);
    }

    @Override
    protected void doClean() throws SQLException {
        for (Table table : this.allTables()) {
            table.drop();
        }
    }

    @Override
    protected Table[] doAllTables() throws SQLException {
        List<String> tableNames = this.jdbcTemplate.queryForStringList("SELECT t.table_name FROM information_schema.tables t WHERE table_schema=? AND table_type='BASE TABLE'", this.name);
        Table[] tables = new Table[tableNames.size()];
        for (int i = 0; i < tableNames.size(); ++i) {
            tables[i] = new RedshiftTable(this.jdbcTemplate, this.dbSupport, this, tableNames.get(i));
        }
        return tables;
    }

    @Override
    public Table getTable(String tableName) {
        return new RedshiftTable(this.jdbcTemplate, this.dbSupport, this, tableName);
    }
}

