/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.resource;

import java.io.IOException;
import java.util.zip.CRC32;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.line.Line;
import org.flywaydb.core.internal.line.LineReader;
import org.flywaydb.core.internal.resource.LoadableResource;
import org.flywaydb.core.internal.util.IOUtils;
import org.flywaydb.core.internal.util.StringUtils;

public abstract class AbstractLoadableResource
implements LoadableResource {
    private Integer checksum;

    @Override
    public final int checksum() {
        if (this.checksum == null) {
            CRC32 crc32 = new CRC32();
            LineReader lineReader = null;
            try {
                Line line;
                lineReader = this.loadAsString();
                while ((line = lineReader.readLine()) != null) {
                    crc32.update(StringUtils.trimLineBreak(line.getLine()).getBytes("UTF-8"));
                }
            }
            catch (IOException e) {
                throw new FlywayException("Unable to calculate checksum for " + this.getAbsolutePath() + " (" + this.getAbsolutePathOnDisk() + "): " + e.getMessage(), e);
            }
            finally {
                IOUtils.close(lineReader);
            }
            this.checksum = (int)crc32.getValue();
        }
        return this.checksum;
    }
}

