/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.mysql.MySQLConnection;
import org.flywaydb.core.internal.database.mysql.MySQLSqlStatementBuilderFactory;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.placeholder.PlaceholderReplacer;
import org.flywaydb.core.internal.sqlscript.SqlStatementBuilderFactory;

public class MySQLDatabase
extends Database<MySQLConnection> {
    private static final Log LOG = LogFactory.getLog(MySQLDatabase.class);
    private boolean mariaDB;
    private final boolean pxcStrict;

    public MySQLDatabase(Configuration configuration, Connection connection, boolean originalAutoCommit) {
        super(configuration, connection, originalAutoCommit);
        this.pxcStrict = MySQLDatabase.isRunningInPerconaXtraDBClusterWithStrictMode(connection);
    }

    static boolean isRunningInPerconaXtraDBClusterWithStrictMode(Connection connection) {
        try {
            if ("ENFORCING".equals(new JdbcTemplate(connection).queryForString("select VARIABLE_VALUE from performance_schema.global_variables where variable_name = 'pxc_strict_mode'", new String[0]))) {
                LOG.debug("Detected Percona XtraDB Cluster in strict mode");
                return true;
            }
        }
        catch (SQLException e) {
            LOG.debug("Unable to detect whether we are running in a Percona XtraDB Cluster. Assuming not to be.");
        }
        return false;
    }

    boolean isMariaDB() {
        return this.mariaDB;
    }

    boolean isPxcStrict() {
        return this.pxcStrict;
    }

    @Override
    protected MySQLConnection getConnection(Connection connection) {
        return new MySQLConnection(this.configuration, this, connection, this.originalAutoCommit);
    }

    @Override
    public final void ensureSupported() {
        boolean isMariaDBDriver;
        try {
            this.mariaDB = this.jdbcMetaData.getDatabaseProductVersion().contains("MariaDB");
            isMariaDBDriver = this.jdbcMetaData.getDriverName().contains("MariaDB");
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to determine database product version and driver", e);
        }
        String productName = this.mariaDB ? "MariaDB" : "MySQL";
        this.ensureDatabaseIsRecentEnough(productName, "5.1");
        this.ensureDatabaseIsCompatibleWithFlywayEdition(this.mariaDB ? "MariaDB" : "Oracle", productName, "5.5");
        if (this.mariaDB) {
            this.recommendFlywayUpgradeIfNecessary(productName, "10.3");
        } else {
            if (isMariaDBDriver) {
                LOG.warn("You are connected to a MySQL " + this.getVersion() + " database using the MariaDB driver. This is known to cause issues. An upgrade to Oracle's MySQL JDBC driver is highly recommended.");
            }
            this.recommendFlywayUpgradeIfNecessary(productName, "8.0");
        }
    }

    @Override
    protected SqlStatementBuilderFactory createSqlStatementBuilderFactory(PlaceholderReplacer placeholderReplacer) {
        return new MySQLSqlStatementBuilderFactory(placeholderReplacer);
    }

    @Override
    public String getDbName() {
        return "mysql";
    }

    @Override
    protected String doGetCurrentUser() throws SQLException {
        return ((MySQLConnection)this.getMainConnection()).getJdbcTemplate().queryForString("SELECT SUBSTRING_INDEX(USER(),'@',1)", new String[0]);
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public boolean supportsChangingCurrentSchema() {
        return true;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public String doQuote(String identifier) {
        return "`" + identifier + "`";
    }

    @Override
    public boolean catalogIsSchema() {
        return true;
    }

    @Override
    public boolean useSingleConnection() {
        return !this.pxcStrict;
    }
}

