/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.postgresql;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.List;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.Result;
import org.flywaydb.core.internal.jdbc.Results;
import org.flywaydb.core.internal.line.Line;
import org.flywaydb.core.internal.sqlscript.AbstractSqlStatement;
import org.flywaydb.core.internal.sqlscript.Delimiter;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutor;
import org.postgresql.copy.CopyManager;
import org.postgresql.core.BaseConnection;

public class PostgreSQLCopyStatement
extends AbstractSqlStatement {
    static final Delimiter COPY_DELIMITER = new Delimiter("\\.", true);

    PostgreSQLCopyStatement(List<Line> lines) {
        super(lines, COPY_DELIMITER);
    }

    @Override
    public Results execute(JdbcTemplate jdbcTemplate, SqlScriptExecutor sqlScriptExecutor) {
        String sql = this.getSql();
        int split = sql.indexOf(";");
        String statement = sql.substring(0, split);
        String data = sql.substring(split + 1);
        StringBuilder buf = new StringBuilder(data);
        while (buf.length() > 0 && (buf.charAt(0) == '\r' || buf.charAt(0) == '\n')) {
            buf.deleteCharAt(0);
        }
        data = buf.toString();
        Results results = new Results();
        try {
            CopyManager copyManager = new CopyManager(jdbcTemplate.getConnection().unwrap(BaseConnection.class));
            try {
                long updateCount = copyManager.copyIn(statement, (Reader)new StringReader(data));
                results.addResult(new Result(updateCount));
            }
            catch (IOException e) {
                throw new SQLException("Unable to execute COPY operation", e);
            }
        }
        catch (SQLException e) {
            jdbcTemplate.extractErrors(results, e);
        }
        return results;
    }
}

