/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.util.StringUtils;

public class ClassUtils {
    private static final Log LOG = LogFactory.getLog(ClassUtils.class);

    private ClassUtils() {
    }

    public static synchronized <T> T instantiate(String className, ClassLoader classLoader) {
        try {
            return (T)Class.forName(className, true, classLoader).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new FlywayException("Unable to instantiate class " + className + " : " + e.getMessage(), e);
        }
    }

    public static synchronized <T> T instantiate(Class<T> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new FlywayException("Unable to instantiate class " + clazz.getName() + " : " + e.getMessage(), e);
        }
    }

    public static <T> List<T> instantiateAll(String[] classes, ClassLoader classLoader) {
        ArrayList<T> clazzes = new ArrayList<T>();
        for (String clazz : classes) {
            if (!StringUtils.hasLength(clazz)) continue;
            clazzes.add(ClassUtils.instantiate(clazz, classLoader));
        }
        return clazzes;
    }

    public static boolean isPresent(String className, ClassLoader classLoader) {
        try {
            classLoader.loadClass(className);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static Class<?> loadClass(String className, ClassLoader classLoader) {
        try {
            Class<?> clazz = classLoader.loadClass(className);
            if (Modifier.isAbstract(clazz.getModifiers()) || clazz.isEnum() || clazz.isAnonymousClass()) {
                LOG.debug("Skipping non-instantiable class: " + className);
                return null;
            }
            clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            LOG.debug("Found class: " + className);
            return clazz;
        }
        catch (InternalError e) {
            LOG.debug("Skipping invalid class: " + className);
            return null;
        }
        catch (IncompatibleClassChangeError e) {
            LOG.warn("Skipping incompatibly changed class: " + className);
            return null;
        }
        catch (NoClassDefFoundError e) {
            LOG.debug("Skipping non-loadable class definition: " + className);
            return null;
        }
        catch (ClassNotFoundException e) {
            LOG.debug("Skipping non-loadable class: " + className);
            return null;
        }
        catch (IllegalAccessException e) {
            LOG.debug("Skipping non-instantiable class (illegal access): " + className);
            return null;
        }
        catch (InstantiationException e) {
            LOG.debug("Skipping non-instantiable class (instantiation error): " + className);
            return null;
        }
        catch (NoSuchMethodException e) {
            LOG.debug("Skipping non-instantiable class (no default constructor): " + className);
            return null;
        }
        catch (InvocationTargetException e) {
            LOG.debug("Skipping non-instantiable class (invocation error): " + className);
            return null;
        }
    }

    public static String getShortName(Class<?> aClass) {
        String name = aClass.getName();
        return name.substring(name.lastIndexOf(".") + 1);
    }

    public static String getLocationOnDisk(Class<?> aClass) {
        try {
            ProtectionDomain protectionDomain = aClass.getProtectionDomain();
            if (protectionDomain == null) {
                return null;
            }
            CodeSource codeSource = protectionDomain.getCodeSource();
            if (codeSource == null) {
                return null;
            }
            String url = codeSource.getLocation().getPath();
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static ClassLoader addJarOrDirectoryToClasspath(ClassLoader classLoader, String name) throws IOException {
        LOG.debug("Adding location to classpath: " + name);
        try {
            URL url = new File(name).toURI().toURL();
            return new URLClassLoader(new URL[]{url}, classLoader);
        }
        catch (Exception e) {
            throw new FlywayException("Unable to load " + name, e);
        }
    }
}

