/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.snowflake;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.database.snowflake.SnowflakeDatabase;
import org.flywaydb.core.internal.database.snowflake.SnowflakeTable;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.RowMapper;

public class SnowflakeSchema
extends Schema<SnowflakeDatabase, SnowflakeTable> {
    SnowflakeSchema(JdbcTemplate jdbcTemplate, SnowflakeDatabase database, String name) {
        super(jdbcTemplate, database, name);
    }

    @Override
    protected boolean doExists() throws SQLException {
        String sql = "SHOW SCHEMAS LIKE '" + this.name + "'";
        List<Boolean> results = this.jdbcTemplate.query(sql, new RowMapper<Boolean>(){

            @Override
            public Boolean mapRow(ResultSet rs) throws SQLException {
                return true;
            }
        }, new Object[0]);
        return !results.isEmpty();
    }

    @Override
    protected boolean doEmpty() throws SQLException {
        int objectCount = this.getObjectCount("TABLE") + this.getObjectCount("VIEW") + this.getObjectCount("SEQUENCE");
        return objectCount == 0;
    }

    private int getObjectCount(String objectType) throws SQLException {
        return this.jdbcTemplate.query("SHOW " + objectType + "S IN SCHEMA " + ((SnowflakeDatabase)this.database).quote(this.name), new RowMapper<Integer>(){

            @Override
            public Integer mapRow(ResultSet rs) throws SQLException {
                return 1;
            }
        }, new Object[0]).size();
    }

    @Override
    protected void doCreate() throws SQLException {
        this.jdbcTemplate.execute("CREATE SCHEMA " + ((SnowflakeDatabase)this.database).quote(this.name), new Object[0]);
    }

    @Override
    protected void doDrop() throws SQLException {
        this.jdbcTemplate.execute("DROP SCHEMA " + ((SnowflakeDatabase)this.database).quote(this.name), new Object[0]);
    }

    @Override
    protected void doClean() throws SQLException {
        for (String dropStatement : this.generateDropStatements("VIEW")) {
            this.jdbcTemplate.execute(dropStatement, new Object[0]);
        }
        for (String dropStatement : this.generateDropStatements("TABLE")) {
            this.jdbcTemplate.execute(dropStatement, new Object[0]);
        }
        for (String dropStatement : this.generateDropStatements("SEQUENCE")) {
            this.jdbcTemplate.execute(dropStatement, new Object[0]);
        }
        for (String dropStatement : this.generateDropStatementsWithArgs("FUNCTION")) {
            this.jdbcTemplate.execute(dropStatement, new Object[0]);
        }
    }

    protected SnowflakeTable[] doAllTables() throws SQLException {
        List<SnowflakeTable> tables = this.jdbcTemplate.query("SHOW TABLES IN SCHEMA " + ((SnowflakeDatabase)this.database).quote(this.name), new RowMapper<SnowflakeTable>(){

            @Override
            public SnowflakeTable mapRow(ResultSet rs) throws SQLException {
                String tableName = rs.getString("name");
                return (SnowflakeTable)SnowflakeSchema.this.getTable(tableName);
            }
        }, new Object[0]);
        return tables.toArray(new SnowflakeTable[0]);
    }

    @Override
    public Table getTable(String tableName) {
        return new SnowflakeTable(this.jdbcTemplate, (SnowflakeDatabase)this.database, this, tableName);
    }

    private List<String> generateDropStatements(final String objectType) throws SQLException {
        return this.jdbcTemplate.query("SHOW " + objectType + "S IN SCHEMA " + ((SnowflakeDatabase)this.database).quote(this.name), new RowMapper<String>(){

            @Override
            public String mapRow(ResultSet rs) throws SQLException {
                String tableName = rs.getString("name");
                return "DROP " + objectType + " " + ((SnowflakeDatabase)SnowflakeSchema.this.database).quote(SnowflakeSchema.this.name) + "." + ((SnowflakeDatabase)SnowflakeSchema.this.database).quote(tableName);
            }
        }, new Object[0]);
    }

    private List<String> generateDropStatementsWithArgs(String objectType) throws SQLException {
        return this.jdbcTemplate.query("SHOW USER FUNCTIONS IN SCHEMA " + ((SnowflakeDatabase)this.database).quote(this.name), new RowMapper<String>(){

            @Override
            public String mapRow(ResultSet rs) throws SQLException {
                String nameAndArgsList = rs.getString("arguments");
                int indexOfEndOfArgs = nameAndArgsList.indexOf(") RETURN ");
                String functionName = nameAndArgsList.substring(0, indexOfEndOfArgs + 1);
                return "DROP FUNCTION " + SnowflakeSchema.this.name + "." + functionName;
            }
        }, new Object[0]);
    }
}

