/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.flywaydb.core.api.ClassProvider;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfoService;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.configuration.ClassicConfiguration;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.api.exception.FlywayValidateException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.migration.JavaMigration;
import org.flywaydb.core.api.output.BaselineResult;
import org.flywaydb.core.api.output.CleanResult;
import org.flywaydb.core.api.output.MigrateResult;
import org.flywaydb.core.api.output.RepairResult;
import org.flywaydb.core.api.output.UndoResult;
import org.flywaydb.core.api.output.ValidateResult;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.internal.callback.CallbackExecutor;
import org.flywaydb.core.internal.callback.DefaultCallbackExecutor;
import org.flywaydb.core.internal.callback.NoopCallbackExecutor;
import org.flywaydb.core.internal.callback.SqlScriptCallbackFactory;
import org.flywaydb.core.internal.clazz.NoopClassProvider;
import org.flywaydb.core.internal.command.DbBaseline;
import org.flywaydb.core.internal.command.DbClean;
import org.flywaydb.core.internal.command.DbInfo;
import org.flywaydb.core.internal.command.DbMigrate;
import org.flywaydb.core.internal.command.DbRepair;
import org.flywaydb.core.internal.command.DbSchemas;
import org.flywaydb.core.internal.command.DbValidate;
import org.flywaydb.core.internal.configuration.ConfigurationValidator;
import org.flywaydb.core.internal.database.DatabaseType;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.license.FlywayTeamsUpgradeRequiredException;
import org.flywaydb.core.internal.license.VersionPrinter;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.resolver.CompositeMigrationResolver;
import org.flywaydb.core.internal.resource.NoopResourceProvider;
import org.flywaydb.core.internal.resource.ResourceNameValidator;
import org.flywaydb.core.internal.resource.StringResource;
import org.flywaydb.core.internal.scanner.LocationScannerCache;
import org.flywaydb.core.internal.scanner.ResourceNameCache;
import org.flywaydb.core.internal.scanner.Scanner;
import org.flywaydb.core.internal.schemahistory.SchemaHistory;
import org.flywaydb.core.internal.schemahistory.SchemaHistoryFactory;
import org.flywaydb.core.internal.sqlscript.SqlScript;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutorFactory;
import org.flywaydb.core.internal.sqlscript.SqlScriptFactory;
import org.flywaydb.core.internal.strategy.RetryStrategy;
import org.flywaydb.core.internal.util.IOUtils;
import org.flywaydb.core.internal.util.Pair;
import org.flywaydb.core.internal.util.StringUtils;

public class Flyway {
    private static final Log LOG = LogFactory.getLog(Flyway.class);
    private final ClassicConfiguration configuration;
    private boolean dbConnectionInfoPrinted;
    private ConfigurationValidator configurationValidator = new ConfigurationValidator();
    private ResourceNameValidator resourceNameValidator = new ResourceNameValidator();
    private ResourceNameCache resourceNameCache = new ResourceNameCache();
    private final LocationScannerCache locationScannerCache = new LocationScannerCache();

    public static FluentConfiguration configure() {
        return new FluentConfiguration();
    }

    public static FluentConfiguration configure(ClassLoader classLoader) {
        return new FluentConfiguration(classLoader);
    }

    public Flyway(Configuration configuration) {
        this.configuration = new ClassicConfiguration(configuration);
        this.configuration.loadCallbackLocation("db/callback", false);
        LogFactory.setConfiguration(this.configuration);
    }

    public Configuration getConfiguration() {
        return new ClassicConfiguration(this.configuration);
    }

    public MigrateResult migrate() throws FlywayException {
        return this.execute(new Command<MigrateResult>(){

            @Override
            public MigrateResult execute(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Schema[] schemas, CallbackExecutor callbackExecutor, StatementInterceptor statementInterceptor) {
                if (Flyway.this.configuration.isValidateOnMigrate()) {
                    ValidateResult validateResult = Flyway.this.doValidate(database, migrationResolver, schemaHistory, schemas, callbackExecutor, true);
                    if (!validateResult.validationSuccessful && !Flyway.this.configuration.isCleanOnValidationError()) {
                        throw new FlywayValidateException(validateResult.errorDetails, validateResult.getAllErrorMessages());
                    }
                }
                if (!schemaHistory.exists()) {
                    ArrayList<Schema> nonEmptySchemas = new ArrayList<Schema>();
                    for (Schema schema : schemas) {
                        if (!schema.exists() || schema.empty()) continue;
                        nonEmptySchemas.add(schema);
                    }
                    if (!nonEmptySchemas.isEmpty()) {
                        if (Flyway.this.configuration.isBaselineOnMigrate()) {
                            Flyway.this.doBaseline(schemaHistory, callbackExecutor, database);
                        } else if (!schemaHistory.exists()) {
                            throw new FlywayException("Found non-empty schema(s) " + StringUtils.collectionToCommaDelimitedString(nonEmptySchemas) + " but no schema history table. Use baseline() or set baselineOnMigrate to true to initialize the schema history table.");
                        }
                    } else {
                        if (Flyway.this.configuration.getCreateSchemas()) {
                            new DbSchemas(database, schemas, schemaHistory, callbackExecutor).create(false);
                        } else if (!schemas[0].exists()) {
                            LOG.warn("The configuration option 'createSchemas' is false.\nHowever, the schema history table still needs a schema to reside in.\nYou must manually create a schema for the schema history table to reside in.\nSee https://flywaydb.org/documentation/concepts/migrations.html#the-createschemas-option-and-the-schema-history-table");
                        }
                        schemaHistory.create(false);
                    }
                }
                MigrateResult result = new DbMigrate(database, schemaHistory, schemas[0], migrationResolver, Flyway.this.configuration, callbackExecutor).migrate();
                callbackExecutor.onOperationFinishEvent(Event.AFTER_MIGRATE_OPERATION_FINISH, result);
                return result;
            }
        }, true);
    }

    private BaselineResult doBaseline(SchemaHistory schemaHistory, CallbackExecutor callbackExecutor, Database database) {
        return new DbBaseline(schemaHistory, this.configuration.getBaselineVersion(), this.configuration.getBaselineDescription(), callbackExecutor, database).baseline();
    }

    public UndoResult undo() throws FlywayException {
        throw new FlywayTeamsUpgradeRequiredException("undo");
    }

    public void validate() throws FlywayException {
        this.execute(new Command<Void>(){

            @Override
            public Void execute(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Schema[] schemas, CallbackExecutor callbackExecutor, StatementInterceptor statementInterceptor) {
                ValidateResult validateResult = Flyway.this.doValidate(database, migrationResolver, schemaHistory, schemas, callbackExecutor, Flyway.this.configuration.isIgnorePendingMigrations());
                callbackExecutor.onOperationFinishEvent(Event.AFTER_VALIDATE_OPERATION_FINISH, validateResult);
                if (!validateResult.validationSuccessful && !Flyway.this.configuration.isCleanOnValidationError()) {
                    throw new FlywayValidateException(validateResult.errorDetails, validateResult.getAllErrorMessages());
                }
                return null;
            }
        }, true);
    }

    public ValidateResult validateWithResult() throws FlywayException {
        return this.execute(new Command<ValidateResult>(){

            @Override
            public ValidateResult execute(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Schema[] schemas, CallbackExecutor callbackExecutor, StatementInterceptor statementInterceptor) {
                ValidateResult validateResult = Flyway.this.doValidate(database, migrationResolver, schemaHistory, schemas, callbackExecutor, Flyway.this.configuration.isIgnorePendingMigrations());
                callbackExecutor.onOperationFinishEvent(Event.AFTER_VALIDATE_OPERATION_FINISH, validateResult);
                return validateResult;
            }
        }, true);
    }

    private ValidateResult doValidate(Database database, MigrationResolver migrationResolver, SchemaHistory schemaHistory, Schema[] schemas, CallbackExecutor callbackExecutor, boolean ignorePending) {
        ValidateResult validateResult = new DbValidate(database, schemaHistory, schemas[0], migrationResolver, this.configuration, ignorePending, callbackExecutor).validate();
        if (!validateResult.validationSuccessful && this.configuration.isCleanOnValidationError()) {
            this.doClean(database, schemaHistory, schemas, callbackExecutor);
        }
        return validateResult;
    }

    private CleanResult doClean(Database database, SchemaHistory schemaHistory, Schema[] schemas, CallbackExecutor callbackExecutor) {
        return new DbClean(database, schemaHistory, schemas, callbackExecutor, this.configuration.isCleanDisabled()).clean();
    }

    public CleanResult clean() {
        return this.execute(new Command<CleanResult>(){

            @Override
            public CleanResult execute(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Schema[] schemas, CallbackExecutor callbackExecutor, StatementInterceptor statementInterceptor) {
                CleanResult cleanResult = Flyway.this.doClean(database, schemaHistory, schemas, callbackExecutor);
                callbackExecutor.onOperationFinishEvent(Event.AFTER_CLEAN_OPERATION_FINISH, cleanResult);
                return cleanResult;
            }
        }, false);
    }

    public MigrationInfoService info() {
        return this.execute(new Command<MigrationInfoService>(){

            @Override
            public MigrationInfoService execute(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Schema[] schemas, CallbackExecutor callbackExecutor, StatementInterceptor statementInterceptor) {
                MigrationInfoService migrationInfoService = new DbInfo(migrationResolver, schemaHistory, Flyway.this.configuration, database, callbackExecutor, schemas).info();
                callbackExecutor.onOperationFinishEvent(Event.AFTER_INFO_OPERATION_FINISH, migrationInfoService.getInfoResult());
                return migrationInfoService;
            }
        }, true);
    }

    public BaselineResult baseline() throws FlywayException {
        return this.execute(new Command<BaselineResult>(){

            @Override
            public BaselineResult execute(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Schema[] schemas, CallbackExecutor callbackExecutor, StatementInterceptor statementInterceptor) {
                if (Flyway.this.configuration.getCreateSchemas()) {
                    new DbSchemas(database, schemas, schemaHistory, callbackExecutor).create(true);
                } else {
                    LOG.warn("The configuration option 'createSchemas' is false.\nEven though Flyway is configured not to create any schemas, the schema history table still needs a schema to reside in.\nYou must manually create a schema for the schema history table to reside in.\nSee http://flywaydb.org/documentation/migrations#the-createschemas-option-and-the-schema-history-table");
                }
                BaselineResult baselineResult = Flyway.this.doBaseline(schemaHistory, callbackExecutor, database);
                callbackExecutor.onOperationFinishEvent(Event.AFTER_BASELINE_OPERATION_FINISH, baselineResult);
                return baselineResult;
            }
        }, false);
    }

    public RepairResult repair() throws FlywayException {
        return this.execute(new Command<RepairResult>(){

            @Override
            public RepairResult execute(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Schema[] schemas, CallbackExecutor callbackExecutor, StatementInterceptor statementInterceptor) {
                RepairResult repairResult = new DbRepair(database, migrationResolver, schemaHistory, callbackExecutor, Flyway.this.configuration).repair();
                callbackExecutor.onOperationFinishEvent(Event.AFTER_REPAIR_OPERATION_FINISH, repairResult);
                return repairResult;
            }
        }, true);
    }

    private MigrationResolver createMigrationResolver(ResourceProvider resourceProvider, ClassProvider<JavaMigration> classProvider, SqlScriptExecutorFactory sqlScriptExecutorFactory, SqlScriptFactory sqlScriptFactory, ParsingContext parsingContext) {
        return new CompositeMigrationResolver(resourceProvider, classProvider, this.configuration, sqlScriptExecutorFactory, sqlScriptFactory, parsingContext, this.configuration.getResolvers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T execute(Command<T> command, boolean scannerRequired) {
        T result;
        this.configurationValidator.validate(this.configuration);
        StatementInterceptor statementInterceptor = null;
        Pair<ResourceProvider, ClassProvider<JavaMigration>> resourceProviderClassProviderPair = this.createResourceAndClassProviders(scannerRequired);
        final ResourceProvider resourceProvider = resourceProviderClassProviderPair.getLeft();
        ClassProvider<JavaMigration> classProvider = resourceProviderClassProviderPair.getRight();
        if (this.configuration.isValidateMigrationNaming()) {
            this.resourceNameValidator.validateSQLMigrationNaming(resourceProvider, this.configuration);
        }
        JdbcConnectionFactory jdbcConnectionFactory = new JdbcConnectionFactory(this.configuration.getDataSource(), this.configuration, statementInterceptor);
        DatabaseType databaseType = jdbcConnectionFactory.getDatabaseType();
        ParsingContext parsingContext = new ParsingContext();
        final SqlScriptFactory sqlScriptFactory = databaseType.createSqlScriptFactory(this.configuration, parsingContext);
        RetryStrategy.setNumberOfRetries(this.configuration.getLockRetryCount());
        final SqlScriptExecutorFactory noCallbackSqlScriptExecutorFactory = databaseType.createSqlScriptExecutorFactory(jdbcConnectionFactory, NoopCallbackExecutor.INSTANCE, null);
        jdbcConnectionFactory.setConnectionInitializer(new JdbcConnectionFactory.ConnectionInitializer(){

            @Override
            public void initialize(JdbcConnectionFactory jdbcConnectionFactory, Connection connection) {
                if (Flyway.this.configuration.getInitSql() == null) {
                    return;
                }
                StringResource resource = new StringResource(Flyway.this.configuration.getInitSql());
                SqlScript sqlScript = sqlScriptFactory.createSqlScript(resource, true, resourceProvider);
                boolean outputQueryResults = false;
                noCallbackSqlScriptExecutorFactory.createSqlScriptExecutor(connection, false, false, outputQueryResults).execute(sqlScript);
            }
        });
        Database database = null;
        try {
            VersionPrinter.printVersion();
            database = databaseType.createDatabase(this.configuration, !this.dbConnectionInfoPrinted, jdbcConnectionFactory, statementInterceptor);
            databaseType.printMessages();
            this.dbConnectionInfoPrinted = true;
            LOG.debug("DDL Transactions Supported: " + database.supportsDdlTransactions());
            Pair<Schema, List<Schema>> schemas = SchemaHistoryFactory.prepareSchemas(this.configuration, database);
            Schema defaultSchema = schemas.getLeft();
            parsingContext.populate(database, this.configuration);
            database.ensureSupported();
            DefaultCallbackExecutor callbackExecutor = new DefaultCallbackExecutor(this.configuration, database, defaultSchema, this.prepareCallbacks(database, resourceProvider, jdbcConnectionFactory, sqlScriptFactory, statementInterceptor, defaultSchema, parsingContext));
            SqlScriptExecutorFactory sqlScriptExecutorFactory = databaseType.createSqlScriptExecutorFactory(jdbcConnectionFactory, callbackExecutor, statementInterceptor);
            SchemaHistory schemaHistory = SchemaHistoryFactory.getSchemaHistory(this.configuration, noCallbackSqlScriptExecutorFactory, sqlScriptFactory, database, defaultSchema, statementInterceptor);
            result = command.execute(this.createMigrationResolver(resourceProvider, classProvider, sqlScriptExecutorFactory, sqlScriptFactory, parsingContext), schemaHistory, database, schemas.getRight().toArray(new Schema[0]), callbackExecutor, statementInterceptor);
        }
        catch (Throwable throwable) {
            IOUtils.close(database);
            this.showMemoryUsage();
            throw throwable;
        }
        IOUtils.close(database);
        this.showMemoryUsage();
        return result;
    }

    private Pair<ResourceProvider, ClassProvider<JavaMigration>> createResourceAndClassProviders(boolean scannerRequired) {
        ClassProvider classProvider;
        ResourceProvider resourceProvider;
        if (!scannerRequired && this.configuration.isSkipDefaultResolvers() && this.configuration.isSkipDefaultCallbacks()) {
            resourceProvider = NoopResourceProvider.INSTANCE;
            classProvider = NoopClassProvider.INSTANCE;
        } else if (this.configuration.getResourceProvider() != null && this.configuration.getJavaMigrationClassProvider() != null) {
            resourceProvider = this.configuration.getResourceProvider();
            classProvider = this.configuration.getJavaMigrationClassProvider();
        } else {
            boolean stream = false;
            Scanner<JavaMigration> scanner = new Scanner<JavaMigration>(JavaMigration.class, Arrays.asList(this.configuration.getLocations()), this.configuration.getClassLoader(), this.configuration.getEncoding(), this.configuration.getDetectEncoding(), stream, this.resourceNameCache, this.locationScannerCache, this.configuration.getFailOnMissingLocations());
            resourceProvider = scanner;
            classProvider = scanner;
            if (this.configuration.getResourceProvider() != null) {
                resourceProvider = this.configuration.getResourceProvider();
            }
            if (this.configuration.getJavaMigrationClassProvider() != null) {
                classProvider = this.configuration.getJavaMigrationClassProvider();
            }
        }
        return Pair.of(resourceProvider, classProvider);
    }

    private void showMemoryUsage() {
        Runtime runtime = Runtime.getRuntime();
        long free = runtime.freeMemory();
        long total = runtime.totalMemory();
        long used = total - free;
        long totalMB = total / 0x100000L;
        long usedMB = used / 0x100000L;
        LOG.debug("Memory usage: " + usedMB + " of " + totalMB + "M");
    }

    private List<Callback> prepareCallbacks(Database database, ResourceProvider resourceProvider, JdbcConnectionFactory jdbcConnectionFactory, SqlScriptFactory sqlScriptFactory, StatementInterceptor statementInterceptor, Schema schema, ParsingContext parsingContext) {
        ArrayList<Callback> effectiveCallbacks = new ArrayList<Callback>();
        NoopCallbackExecutor callbackExecutor = NoopCallbackExecutor.INSTANCE;
        effectiveCallbacks.addAll(Arrays.asList(this.configuration.getCallbacks()));
        if (!this.configuration.isSkipDefaultCallbacks()) {
            SqlScriptExecutorFactory sqlScriptExecutorFactory = jdbcConnectionFactory.getDatabaseType().createSqlScriptExecutorFactory(jdbcConnectionFactory, callbackExecutor, statementInterceptor);
            effectiveCallbacks.addAll(new SqlScriptCallbackFactory(resourceProvider, sqlScriptExecutorFactory, sqlScriptFactory, this.configuration).getCallbacks());
        }
        return effectiveCallbacks;
    }

    static interface Command<T> {
        public T execute(MigrationResolver var1, SchemaHistory var2, Database var3, Schema[] var4, CallbackExecutor var5, StatementInterceptor var6);
    }
}

