/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.base.DatabaseType;
import org.flywaydb.core.internal.database.base.TestContainersDatabaseType;
import org.flywaydb.core.internal.database.cockroachdb.CockroachDBDatabaseType;
import org.flywaydb.core.internal.database.db2.DB2DatabaseType;
import org.flywaydb.core.internal.database.derby.DerbyDatabaseType;
import org.flywaydb.core.internal.database.firebird.FirebirdDatabaseType;
import org.flywaydb.core.internal.database.h2.H2DatabaseType;
import org.flywaydb.core.internal.database.hsqldb.HSQLDBDatabaseType;
import org.flywaydb.core.internal.database.informix.InformixDatabaseType;
import org.flywaydb.core.internal.database.mysql.MySQLDatabaseType;
import org.flywaydb.core.internal.database.mysql.mariadb.MariaDBDatabaseType;
import org.flywaydb.core.internal.database.oracle.OracleDatabaseType;
import org.flywaydb.core.internal.database.postgresql.PostgreSQLDatabaseType;
import org.flywaydb.core.internal.database.redshift.RedshiftDatabaseType;
import org.flywaydb.core.internal.database.saphana.SAPHANADatabaseType;
import org.flywaydb.core.internal.database.snowflake.SnowflakeDatabaseType;
import org.flywaydb.core.internal.database.sqlite.SQLiteDatabaseType;
import org.flywaydb.core.internal.database.sqlserver.SQLServerDatabaseType;
import org.flywaydb.core.internal.database.sqlserver.synapse.SynapseDatabaseType;
import org.flywaydb.core.internal.database.sybasease.SybaseASEJConnectDatabaseType;
import org.flywaydb.core.internal.database.sybasease.SybaseASEJTDSDatabaseType;
import org.flywaydb.core.internal.jdbc.JdbcUtils;
import org.flywaydb.core.internal.util.StringUtils;

public class DatabaseTypeRegister {
    private static final Log LOG = LogFactory.getLog(DatabaseTypeRegister.class);
    private static final List<DatabaseType> registeredDatabaseTypes = new ArrayList<DatabaseType>();
    private static boolean hasRegisteredDatabaseTypes = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerDatabaseTypes() {
        List<DatabaseType> list = registeredDatabaseTypes;
        synchronized (list) {
            if (hasRegisteredDatabaseTypes) {
                return;
            }
            registeredDatabaseTypes.clear();
            registeredDatabaseTypes.add(new SynapseDatabaseType());
            registeredDatabaseTypes.add(new CockroachDBDatabaseType());
            registeredDatabaseTypes.add(new RedshiftDatabaseType());
            registeredDatabaseTypes.add(new MariaDBDatabaseType());
            registeredDatabaseTypes.add(new DB2DatabaseType());
            registeredDatabaseTypes.add(new DerbyDatabaseType());
            registeredDatabaseTypes.add(new FirebirdDatabaseType());
            registeredDatabaseTypes.add(new H2DatabaseType());
            registeredDatabaseTypes.add(new HSQLDBDatabaseType());
            registeredDatabaseTypes.add(new InformixDatabaseType());
            registeredDatabaseTypes.add(new MySQLDatabaseType());
            registeredDatabaseTypes.add(new OracleDatabaseType());
            registeredDatabaseTypes.add(new PostgreSQLDatabaseType());
            registeredDatabaseTypes.add(new SAPHANADatabaseType());
            registeredDatabaseTypes.add(new SnowflakeDatabaseType());
            registeredDatabaseTypes.add(new SQLiteDatabaseType());
            registeredDatabaseTypes.add(new SQLServerDatabaseType());
            registeredDatabaseTypes.add(new SybaseASEJTDSDatabaseType());
            registeredDatabaseTypes.add(new SybaseASEJConnectDatabaseType());
            registeredDatabaseTypes.add(new TestContainersDatabaseType());
            hasRegisteredDatabaseTypes = true;
        }
    }

    public static DatabaseType getDatabaseTypeForUrl(String url) {
        List<DatabaseType> typesAcceptingUrl = DatabaseTypeRegister.getDatabaseTypesForUrl(url);
        if (typesAcceptingUrl.size() > 0) {
            if (typesAcceptingUrl.size() > 1) {
                StringBuilder builder = new StringBuilder();
                for (DatabaseType type : typesAcceptingUrl) {
                    if (builder.length() > 0) {
                        builder.append(", ");
                    }
                    builder.append(type.getName());
                }
                LOG.debug("Multiple databases found that handle url '" + DatabaseTypeRegister.redactJdbcUrl(url) + "': " + builder);
            }
            return typesAcceptingUrl.get(0);
        }
        throw new FlywayException("No database found to handle " + DatabaseTypeRegister.redactJdbcUrl(url));
    }

    private static List<DatabaseType> getDatabaseTypesForUrl(String url) {
        if (!hasRegisteredDatabaseTypes) {
            DatabaseTypeRegister.registerDatabaseTypes();
        }
        ArrayList<DatabaseType> typesAcceptingUrl = new ArrayList<DatabaseType>();
        for (DatabaseType type : registeredDatabaseTypes) {
            if (!type.handlesJDBCUrl(url)) continue;
            typesAcceptingUrl.add(type);
        }
        return typesAcceptingUrl;
    }

    public static String redactJdbcUrl(String url) {
        List<DatabaseType> types = DatabaseTypeRegister.getDatabaseTypesForUrl(url);
        if (types.isEmpty()) {
            url = DatabaseTypeRegister.redactJdbcUrl(url, DatabaseType.getDefaultJDBCCredentialsPattern());
        } else {
            for (DatabaseType type : types) {
                Pattern dbPattern = type.getJDBCCredentialsPattern();
                if (dbPattern == null) continue;
                url = DatabaseTypeRegister.redactJdbcUrl(url, dbPattern);
            }
        }
        return url;
    }

    private static String redactJdbcUrl(String url, Pattern pattern) {
        Matcher matcher = pattern.matcher(url);
        if (matcher.find()) {
            String password = matcher.group(1);
            return url.replace(password, StringUtils.trimOrPad("", password.length(), '*'));
        }
        return url;
    }

    public static DatabaseType getDatabaseTypeForConnection(Connection connection) {
        if (!hasRegisteredDatabaseTypes) {
            DatabaseTypeRegister.registerDatabaseTypes();
        }
        DatabaseMetaData databaseMetaData = JdbcUtils.getDatabaseMetaData(connection);
        String databaseProductName = JdbcUtils.getDatabaseProductName(databaseMetaData);
        String databaseProductVersion = JdbcUtils.getDatabaseProductVersion(databaseMetaData);
        for (DatabaseType type : registeredDatabaseTypes) {
            if (!type.handlesDatabaseProductNameAndVersion(databaseProductName, databaseProductVersion, connection)) continue;
            return type;
        }
        throw new FlywayException("Unsupported Database: " + databaseProductName);
    }
}

