/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.resource.filesystem;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.StandardOpenOption;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.internal.util.BomStrippingReader;

public class FileSystemResource
extends LoadableResource {
    private static final Log LOG = LogFactory.getLog(FileSystemResource.class);
    private final File file;
    private final String relativePath;
    private final Charset encoding;

    public FileSystemResource(Location location, String fileNameWithPath, Charset encoding) {
        this.file = new File(new File(fileNameWithPath).getPath());
        this.relativePath = location == null ? this.file.getPath() : location.getPathRelativeToThis(this.file.getPath()).replace("\\", "/");
        this.encoding = encoding;
    }

    @Override
    public String getAbsolutePath() {
        return this.file.getPath();
    }

    @Override
    public String getAbsolutePathOnDisk() {
        return this.file.getAbsolutePath();
    }

    @Override
    public Reader read() {
        try {
            return Channels.newReader(FileChannel.open(this.file.toPath(), StandardOpenOption.READ), this.encoding.newDecoder(), 4096);
        }
        catch (IOException e) {
            LOG.debug("Unable to load filesystem resource" + this.file.getPath() + " using FileChannel.open. Falling back to FileInputStream implementation. Exception message: " + e.getMessage());
            try {
                return new BufferedReader(new BomStrippingReader(new InputStreamReader((InputStream)new FileInputStream(this.file), this.encoding)));
            }
            catch (IOException e2) {
                throw new FlywayException("Unable to load filesystem resource: " + this.file.getPath() + " (encoding: " + this.encoding + ")", e2);
            }
        }
    }

    @Override
    public String getFilename() {
        return this.file.getName();
    }

    @Override
    public String getRelativePath() {
        return this.relativePath;
    }
}

