/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.EnumerableOwnPropertyNamesNode;
import com.oracle.truffle.js.nodes.temporal.TemporalDifferenceDateNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.temporal.CalendarMethodsRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.ISODateRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import com.oracle.truffle.js.runtime.builtins.temporal.NormalizedDurationRecord;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalUtil;

@ImportStatic(value={TemporalConstants.class})
public abstract class DifferenceISODateTimeNode
extends JavaScriptBaseNode {
    protected DifferenceISODateTimeNode() {
    }

    public abstract NormalizedDurationRecord execute(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16, int var17, int var18, CalendarMethodsRecord var19, TemporalUtil.Unit var20, JSObject var21);

    @Specialization
    final NormalizedDurationRecord differencePlainDateTimeWithRounding(int y1, int mon1, int d1, int h1, int min1, int s1, int ms1, int mus1, int ns1, int y2, int mon2, int d2, int h2, int min2, int s2, int ms2, int mus2, int ns2, CalendarMethodsRecord calendarRec, TemporalUtil.Unit largestUnit, JSObject options, @Cached TemporalDifferenceDateNode differenceDate, @Cached(value="createKeys(getJSContext())") EnumerableOwnPropertyNamesNode namesNode) {
        JSContext ctx = this.getJSContext();
        JSRealm realm = this.getRealm();
        BigInt timeDuration = TemporalUtil.differenceTime(h1, min1, s1, ms1, mus1, ns1, h2, min2, s2, ms2, mus2, ns2);
        int timeSign = TemporalUtil.normalizedTimeDurationSign(timeDuration);
        int dateSign = TemporalUtil.compareISODate(y2, mon2, d2, y1, mon1, d1);
        ISODateRecord adjustedDate = TemporalUtil.createISODateRecord(y1, mon1, d1);
        if (timeSign == -dateSign) {
            adjustedDate = TemporalUtil.balanceISODate(adjustedDate.year(), adjustedDate.month(), adjustedDate.day() - timeSign);
            timeDuration = TemporalUtil.add24HourDaysToNormalizedTimeDuration(timeDuration, -timeSign);
        }
        JSTemporalPlainDateObject date1 = JSTemporalPlainDate.create(ctx, realm, adjustedDate.year(), adjustedDate.month(), adjustedDate.day(), calendarRec.receiver(), null, InlinedBranchProfile.getUncached());
        JSTemporalPlainDateObject date2 = JSTemporalPlainDate.create(ctx, realm, y2, mon2, d2, calendarRec.receiver(), null, InlinedBranchProfile.getUncached());
        TemporalUtil.Unit dateLargestUnit = TemporalUtil.largerOfTwoTemporalUnits(TemporalUtil.Unit.DAY, largestUnit);
        JSObject untilOptions = TemporalUtil.mergeLargestUnitOption(ctx, namesNode, options, dateLargestUnit);
        JSTemporalDurationObject dateDifference = differenceDate.execute(calendarRec, date1, date2, dateLargestUnit, untilOptions);
        double days = dateDifference.getDays();
        if (largestUnit != dateLargestUnit) {
            timeDuration = TemporalUtil.add24HourDaysToNormalizedTimeDuration(timeDuration, days);
            days = 0.0;
        }
        return TemporalUtil.createNormalizedDurationRecord(dateDifference.getYears(), dateDifference.getMonths(), dateDifference.getWeeks(), days, timeDuration);
    }
}

