/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.temporal.CreateTimeZoneMethodsRecordNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDateTimeRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstant;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstantObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.TimeZoneMethodsRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class ToTemporalTimeNode
extends JavaScriptBaseNode {
    protected ToTemporalTimeNode() {
    }

    public abstract JSTemporalPlainTimeObject execute(Object var1, TemporalUtil.Overflow var2);

    @Specialization
    protected JSTemporalPlainTimeObject toTemporalTime(Object item, TemporalUtil.Overflow overflowParam, @Cached IsObjectNode isObjectNode, @Cached JSToStringNode toStringNode, @Cached InlinedConditionProfile isObjectProfile, @Cached InlinedConditionProfile isPlainDateTimeProfile, @Cached InlinedConditionProfile isZonedDateTimeProfile, @Cached InlinedConditionProfile isPlainTimeProfile, @Cached InlinedBranchProfile errorBranch, @Cached CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
        TemporalUtil.Overflow overflow;
        TemporalUtil.Overflow overflow2 = overflow = overflowParam == null ? TemporalUtil.Overflow.CONSTRAIN : overflowParam;
        assert (overflow == TemporalUtil.Overflow.CONSTRAIN || overflow == TemporalUtil.Overflow.REJECT);
        JSContext ctx = this.getLanguage().getJSContext();
        JSRealm realm = this.getRealm();
        JSTemporalDurationRecord result2 = null;
        if (isObjectProfile.profile((Node)this, isObjectNode.executeBoolean(item))) {
            JSDynamicObject itemObj = (JSDynamicObject)((Object)item);
            if (isPlainTimeProfile.profile((Node)this, JSTemporalPlainTime.isJSTemporalPlainTime((Object)itemObj))) {
                return (JSTemporalPlainTimeObject)itemObj;
            }
            if (isZonedDateTimeProfile.profile((Node)this, TemporalUtil.isTemporalZonedDateTime((Object)itemObj))) {
                JSTemporalZonedDateTimeObject zdt = (JSTemporalZonedDateTimeObject)itemObj;
                JSTemporalInstantObject instant = JSTemporalInstant.create(ctx, realm, zdt.getNanoseconds());
                TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeOnlyGetOffsetNanosecondsFor(zdt.getTimeZone());
                JSTemporalPlainDateTimeObject plainDateTime = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(ctx, realm, timeZoneRec, instant, zdt.getCalendar());
                return JSTemporalPlainTime.create(ctx, realm, plainDateTime.getHour(), plainDateTime.getMinute(), plainDateTime.getSecond(), plainDateTime.getMillisecond(), plainDateTime.getMicrosecond(), plainDateTime.getNanosecond(), this, errorBranch);
            }
            if (isPlainDateTimeProfile.profile((Node)this, JSTemporalPlainDateTime.isJSTemporalPlainDateTime((Object)itemObj))) {
                JSTemporalPlainDateTimeObject dt = (JSTemporalPlainDateTimeObject)itemObj;
                return JSTemporalPlainTime.create(ctx, realm, dt.getHour(), dt.getMinute(), dt.getSecond(), dt.getMillisecond(), dt.getMicrosecond(), dt.getNanosecond(), this, errorBranch);
            }
            JSTemporalDateTimeRecord result = TemporalUtil.toTemporalTimeRecord(itemObj);
            result2 = TemporalUtil.regulateTime(result.getHour(), result.getMinute(), result.getSecond(), result.getMillisecond(), result.getMicrosecond(), result.getNanosecond(), overflow);
        } else if (item instanceof TruffleString) {
            TruffleString string = (TruffleString)item;
            JSTemporalDateTimeRecord result = TemporalUtil.parseTemporalTimeString(string);
            assert (TemporalUtil.isValidTime(result.getHour(), result.getMinute(), result.getSecond(), result.getMillisecond(), result.getMicrosecond(), result.getNanosecond()));
            if (result.hasCalendar() && !toStringNode.executeString(result.getCalendar()).equals((Object)TemporalConstants.ISO8601)) {
                throw TemporalErrors.createRangeErrorTemporalISO8601Expected();
            }
            result2 = JSTemporalDurationRecord.create(result);
        } else {
            errorBranch.enter((Node)this);
            throw Errors.createTypeErrorNotAString(item);
        }
        return JSTemporalPlainTime.create(ctx, realm, TemporalUtil.dtoi(result2.getHours()), TemporalUtil.dtoi(result2.getMinutes()), TemporalUtil.dtoi(result2.getSeconds()), TemporalUtil.dtoi(result2.getMilliseconds()), TemporalUtil.dtoi(result2.getMicroseconds()), TemporalUtil.dtoi(result2.getNanoseconds()), this, errorBranch);
    }
}

