/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import com.oracle.truffle.js.nodes.interop.JSInteropExecuteNode;
import com.oracle.truffle.js.nodes.interop.JSInteropInstantiateNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.ToDisplayStringFormat;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.interop.JSMetaType;
import com.oracle.truffle.js.runtime.objects.JSClassObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;

@ExportLibrary(value=InteropLibrary.class)
public final class JSProxyObject
extends JSClassObject {
    private Object proxyTarget;
    private JSDynamicObject proxyHandler;

    protected JSProxyObject(Shape shape, JSDynamicObject proto, Object proxyTarget, JSDynamicObject proxyHandler) {
        super(shape, proto);
        this.proxyTarget = proxyTarget;
        this.proxyHandler = proxyHandler;
    }

    public JSDynamicObject getProxyHandler() {
        return this.proxyHandler;
    }

    public Object getProxyTarget() {
        return this.proxyTarget;
    }

    public void revoke(boolean isCallable, boolean isConstructor) {
        this.proxyHandler = Null.instance;
        this.proxyTarget = RevokedTarget.lookup(isCallable, isConstructor);
    }

    @Override
    public TruffleString getClassName() {
        return JSProxy.CLASS_NAME;
    }

    @Override
    public TruffleString getBuiltinToStringTag() {
        Object targetNonProxy = JSProxy.getTargetNonProxy(this);
        if (JSDynamicObject.isJSDynamicObject(targetNonProxy)) {
            if (JSArray.isJSArray(targetNonProxy)) {
                return JSArray.CLASS_NAME;
            }
            if (JSFunction.isJSFunction(targetNonProxy)) {
                return JSFunction.CLASS_NAME;
            }
            return Strings.UC_OBJECT;
        }
        InteropLibrary interop = InteropLibrary.getUncached((Object)targetNonProxy);
        if (interop.hasArrayElements(targetNonProxy)) {
            return JSArray.CLASS_NAME;
        }
        if (interop.isExecutable(targetNonProxy) || interop.isInstantiable(targetNonProxy)) {
            return JSFunction.CLASS_NAME;
        }
        return Strings.UC_OBJECT;
    }

    @ExportMessage
    public boolean isExecutable(@Cached IsCallableNode isCallable) {
        return isCallable.executeBoolean((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public Object execute(Object[] args, @CachedLibrary(value="this") InteropLibrary self, @Cached JSInteropExecuteNode callNode, @Cached.Shared @Cached ExportValueNode exportNode) throws UnsupportedMessageException {
        JavaScriptLanguage language = JavaScriptLanguage.get((Node)self);
        JSRealm realm = JSRealm.get((Node)self);
        language.interopBoundaryEnter(realm);
        try {
            Object result = callNode.execute(this, (Object)Undefined.instance, args);
            Object object = exportNode.execute(result);
            return object;
        }
        finally {
            language.interopBoundaryExit(realm);
        }
    }

    @ExportMessage
    public boolean isInstantiable() {
        return JSRuntime.isConstructor((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public Object instantiate(Object[] args, @CachedLibrary(value="this") InteropLibrary self, @Cached JSInteropInstantiateNode callNode, @Cached.Shared @Cached ExportValueNode exportNode) throws UnsupportedMessageException {
        JavaScriptLanguage language = JavaScriptLanguage.get((Node)self);
        JSRealm realm = JSRealm.get((Node)self);
        language.interopBoundaryEnter(realm);
        try {
            Object result = callNode.execute(this, args);
            Object object = exportNode.execute(result);
            return object;
        }
        finally {
            language.interopBoundaryExit(realm);
        }
    }

    @ExportMessage
    public boolean hasMetaObject() {
        return true;
    }

    @ExportMessage
    public Object getMetaObject() {
        return JSMetaType.JS_PROXY;
    }

    @Override
    public boolean isExtensible() {
        return JSProxy.INSTANCE.isExtensible(this);
    }

    @Override
    public boolean preventExtensions(boolean doThrow) {
        return JSProxy.INSTANCE.preventExtensions(this, doThrow);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public TruffleString toDisplayStringImpl(boolean allowSideEffects, ToDisplayStringFormat format, int depth) {
        if (JavaScriptLanguage.get(null).getJSContext().isOptionNashornCompatibilityMode()) {
            return this.defaultToString();
        }
        Object target = JSProxy.getTarget(this);
        JSDynamicObject handler = JSProxy.getHandler(this);
        return Strings.concatAll(Strings.PROXY_PAREN, JSRuntime.toDisplayStringInner(target, allowSideEffects, format, depth, (Object)this), Strings.COMMA_SPC, JSRuntime.toDisplayStringInner((Object)handler, allowSideEffects, format, depth, (Object)this), Strings.PAREN_CLOSE);
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class RevokedTarget
    implements TruffleObject {
        private final boolean isCallable;
        private final boolean isConstructor;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        static final Object[] REVOKED_TARGET = new Object[]{Null.instance, new RevokedTarget(true, false), new RevokedTarget(false, true), new RevokedTarget(true, true)};

        RevokedTarget(boolean isCallable, boolean isConstructor) {
            this.isCallable = isCallable;
            this.isConstructor = isConstructor;
        }

        @ExportMessage
        public boolean isExecutable() {
            return this.isCallable;
        }

        @ExportMessage
        public Object execute(Object[] args) throws UnsupportedMessageException {
            if (this.isExecutable()) {
                throw Errors.createTypeErrorProxyRevoked(JSProxy.APPLY, null);
            }
            throw UnsupportedMessageException.create();
        }

        @ExportMessage
        public boolean isInstantiable() {
            return this.isConstructor;
        }

        @ExportMessage
        public Object instantiate(Object[] args) throws UnsupportedMessageException {
            if (this.isInstantiable()) {
                throw Errors.createTypeErrorProxyRevoked(JSProxy.CONSTRUCT, null);
            }
            throw UnsupportedMessageException.create();
        }

        @ExportMessage
        public TruffleString toDisplayString(boolean allowSideEffects) {
            return Null.NAME;
        }

        @ExportMessage
        public boolean hasLanguage() {
            return true;
        }

        @ExportMessage
        public Class<? extends TruffleLanguage<?>> getLanguage() {
            return JavaScriptLanguage.class;
        }

        static Object lookup(boolean callable, boolean constructor) {
            return REVOKED_TARGET[(callable ? 1 : 0) + (constructor ? 2 : 0)];
        }
    }
}

