/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.elf.dwarf;

import com.oracle.objectfile.BasicProgbitsSectionImpl;
import com.oracle.objectfile.BuildDependency;
import com.oracle.objectfile.LayoutDecision;
import com.oracle.objectfile.LayoutDecisionMap;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.debugentry.ClassEntry;
import com.oracle.objectfile.debugentry.StructureTypeEntry;
import com.oracle.objectfile.debugentry.TypeEntry;
import com.oracle.objectfile.elf.ELFMachine;
import com.oracle.objectfile.elf.ELFObjectFile;
import com.oracle.objectfile.elf.dwarf.DwarfDebugInfo;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.graalvm.compiler.debug.DebugContext;

public abstract class DwarfSectionImpl
extends BasicProgbitsSectionImpl {
    protected DwarfDebugInfo dwarfSections;
    protected boolean debug = false;
    protected long debugTextBase = 0L;
    protected long debugAddress = 0L;
    protected int debugBase = 0;
    protected static final byte[] scratch = new byte[10];

    public DwarfSectionImpl(DwarfDebugInfo dwarfSections) {
        this.dwarfSections = dwarfSections;
    }

    public boolean isAArch64() {
        return this.dwarfSections.elfMachine == ELFMachine.AArch64;
    }

    public abstract void createContent();

    public abstract void writeContent(DebugContext var1);

    public boolean contentByteArrayCreated() {
        return this.getContent() != null;
    }

    @Override
    public boolean isLoadable() {
        return false;
    }

    private String debugSectionLogName() {
        assert (this.getSectionName().startsWith(".debug"));
        return "dwarf" + this.getSectionName();
    }

    protected void enableLog(DebugContext context, int pos) {
        assert (this.contentByteArrayCreated());
        if (context.areScopesEnabled()) {
            this.debug = true;
            this.debugBase = pos;
            this.debugAddress = this.debugTextBase;
        }
    }

    protected void log(DebugContext context, String format, Object ... args) {
        if (this.debug) {
            context.logv(2, format, args);
        }
    }

    protected void verboseLog(DebugContext context, String format, Object ... args) {
        if (this.debug) {
            context.logv(3, format, args);
        }
    }

    protected boolean littleEndian() {
        return this.dwarfSections.getByteOrder() == ByteOrder.LITTLE_ENDIAN;
    }

    protected int putByte(byte b, byte[] buffer, int p) {
        int pos = p;
        buffer[pos++] = b;
        return pos;
    }

    protected int putShort(short s, byte[] buffer, int p) {
        int pos = p;
        if (this.littleEndian()) {
            buffer[pos++] = (byte)(s & 0xFF);
            buffer[pos++] = (byte)(s >> 8 & 0xFF);
        } else {
            buffer[pos++] = (byte)(s >> 8 & 0xFF);
            buffer[pos++] = (byte)(s & 0xFF);
        }
        return pos;
    }

    protected int putInt(int i, byte[] buffer, int p) {
        int pos = p;
        if (this.littleEndian()) {
            buffer[pos++] = (byte)(i & 0xFF);
            buffer[pos++] = (byte)(i >> 8 & 0xFF);
            buffer[pos++] = (byte)(i >> 16 & 0xFF);
            buffer[pos++] = (byte)(i >> 24 & 0xFF);
        } else {
            buffer[pos++] = (byte)(i >> 24 & 0xFF);
            buffer[pos++] = (byte)(i >> 16 & 0xFF);
            buffer[pos++] = (byte)(i >> 8 & 0xFF);
            buffer[pos++] = (byte)(i & 0xFF);
        }
        return pos;
    }

    protected int putLong(long l, byte[] buffer, int p) {
        int pos = p;
        if (this.littleEndian()) {
            buffer[pos++] = (byte)(l & 0xFFL);
            buffer[pos++] = (byte)(l >> 8 & 0xFFL);
            buffer[pos++] = (byte)(l >> 16 & 0xFFL);
            buffer[pos++] = (byte)(l >> 24 & 0xFFL);
            buffer[pos++] = (byte)(l >> 32 & 0xFFL);
            buffer[pos++] = (byte)(l >> 40 & 0xFFL);
            buffer[pos++] = (byte)(l >> 48 & 0xFFL);
            buffer[pos++] = (byte)(l >> 56 & 0xFFL);
        } else {
            buffer[pos++] = (byte)(l >> 56 & 0xFFL);
            buffer[pos++] = (byte)(l >> 48 & 0xFFL);
            buffer[pos++] = (byte)(l >> 40 & 0xFFL);
            buffer[pos++] = (byte)(l >> 32 & 0xFFL);
            buffer[pos++] = (byte)(l >> 16 & 0xFFL);
            buffer[pos++] = (byte)(l >> 24 & 0xFFL);
            buffer[pos++] = (byte)(l >> 8 & 0xFFL);
            buffer[pos++] = (byte)(l & 0xFFL);
        }
        return pos;
    }

    protected int putRelocatableCodeOffset(long l, byte[] buffer, int p) {
        int pos = p;
        this.markRelocationSite(pos, ObjectFile.RelocationKind.DIRECT_8, ".text", false, l);
        pos = this.putLong(0L, buffer, pos);
        return pos;
    }

    protected int putRelocatableHeapOffset(long l, byte[] buffer, int p) {
        int pos = p;
        this.markRelocationSite(pos, ObjectFile.RelocationKind.DIRECT_8, "__svm_heap_begin", false, l);
        pos = this.putLong(0L, buffer, pos);
        return pos;
    }

    protected int putULEB(long val, byte[] buffer, int p) {
        long l = val;
        int pos = p;
        for (int i = 0; i < 9; ++i) {
            boolean done;
            byte b = (byte)(l & 0x7FL);
            boolean bl = done = (l >>>= 7) == 0L;
            if (!done) {
                b = (byte)(b | 0x80);
            }
            pos = this.putByte(b, buffer, pos);
            if (done) break;
        }
        return pos;
    }

    protected int putSLEB(long val, byte[] buffer, int p) {
        long l = val;
        int pos = p;
        for (int i = 0; i < 9; ++i) {
            boolean done;
            byte b = (byte)(l & 0x7FL);
            boolean bIsSigned = (b & 0x40) != 0;
            boolean bl = done = bIsSigned && (l >>= 7) == -1L || !bIsSigned && l == 0L;
            if (!done) {
                b = (byte)(b | 0x80);
            }
            pos = this.putByte(b, buffer, pos);
            if (done) break;
        }
        return pos;
    }

    protected static int countUTF8Bytes(String s) {
        return DwarfSectionImpl.countUTF8Bytes(s, 0);
    }

    protected static int countUTF8Bytes(String s, int startChar) {
        byte[] bytes = s.substring(startChar).getBytes(StandardCharsets.UTF_8);
        return bytes.length;
    }

    protected int putUTF8StringBytes(String s, byte[] buffer, int pos) {
        return this.putUTF8StringBytes(s, 0, buffer, pos);
    }

    protected int putUTF8StringBytes(String s, int startChar, byte[] buffer, int p) {
        int pos = p;
        byte[] bytes = s.substring(startChar).getBytes(StandardCharsets.UTF_8);
        System.arraycopy(bytes, 0, buffer, pos, bytes.length);
        pos += bytes.length;
        buffer[pos++] = 0;
        return pos;
    }

    protected void patchLength(int lengthPos, byte[] buffer, int pos) {
        if (buffer != null) {
            int length = pos - (lengthPos + 4);
            this.putInt(length, buffer, lengthPos);
        }
    }

    protected int writeAbbrevCode(long code, byte[] buffer, int pos) {
        if (buffer == null) {
            return pos + this.putSLEB(code, scratch, 0);
        }
        return this.putSLEB(code, buffer, pos);
    }

    protected int writeTag(long code, byte[] buffer, int pos) {
        if (buffer == null) {
            return pos + this.putSLEB(code, scratch, 0);
        }
        return this.putSLEB(code, buffer, pos);
    }

    protected int writeFlag(byte flag, byte[] buffer, int pos) {
        if (buffer == null) {
            return pos + this.putByte(flag, scratch, 0);
        }
        return this.putByte(flag, buffer, pos);
    }

    protected int writeAttrAddress(long address, byte[] buffer, int pos) {
        if (buffer == null) {
            return pos + 8;
        }
        return this.putRelocatableCodeOffset(address, buffer, pos);
    }

    protected int writeAttrData8(long value, byte[] buffer, int pos) {
        if (buffer == null) {
            return pos + this.putLong(value, scratch, 0);
        }
        return this.putLong(value, buffer, pos);
    }

    protected int writeAttrData4(int value, byte[] buffer, int pos) {
        if (buffer == null) {
            return pos + this.putInt(value, scratch, 0);
        }
        return this.putInt(value, buffer, pos);
    }

    protected int writeAttrData2(short value, byte[] buffer, int pos) {
        if (buffer == null) {
            return pos + this.putShort(value, scratch, 0);
        }
        return this.putShort(value, buffer, pos);
    }

    protected int writeAttrData1(byte value, byte[] buffer, int pos) {
        if (buffer == null) {
            return pos + this.putByte(value, scratch, 0);
        }
        return this.putByte(value, buffer, pos);
    }

    public int writeAttrRefAddr(int value, byte[] buffer, int p) {
        int pos = p;
        if (buffer == null) {
            return pos + this.putInt(0, scratch, 0);
        }
        return this.putInt(value, buffer, pos);
    }

    protected int writeAttrNull(byte[] buffer, int pos) {
        if (buffer == null) {
            return pos + this.putSLEB(0L, scratch, 0);
        }
        return this.putSLEB(0L, buffer, pos);
    }

    public abstract String targetSectionName();

    public abstract LayoutDecision.Kind[] targetSectionKinds();

    public abstract String getSectionName();

    @Override
    public int getOrDecideSize(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int sizeHint) {
        if (this.targetSectionName().startsWith(".debug")) {
            ObjectFile.Element previousElement = this.getElement().getOwner().elementForName(this.targetSectionName());
            DwarfSectionImpl previousSection = (DwarfSectionImpl)previousElement.getImpl();
            assert (previousSection.contentByteArrayCreated());
        }
        this.createContent();
        return this.getContent().length;
    }

    @Override
    public byte[] getOrDecideContent(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, byte[] contentHint) {
        assert (this.contentByteArrayCreated());
        this.getOwner().debugContext(this.debugSectionLogName(), this::writeContent);
        return super.getOrDecideContent(alreadyDecided, contentHint);
    }

    @Override
    public Set<BuildDependency> getDependencies(Map<ObjectFile.Element, LayoutDecisionMap> decisions) {
        LayoutDecision.Kind[] targetKinds;
        Iterable deps = super.getDependencies((Map)decisions);
        String targetName = this.targetSectionName();
        ELFObjectFile.ELFSection targetSection = (ELFObjectFile.ELFSection)this.getElement().getOwner().elementForName(targetName);
        LayoutDecision ourContent = decisions.get(this.getElement()).getDecision(LayoutDecision.Kind.CONTENT);
        LayoutDecision ourSize = decisions.get(this.getElement()).getDecision(LayoutDecision.Kind.SIZE);
        for (LayoutDecision.Kind targetKind : targetKinds = this.targetSectionKinds()) {
            LayoutDecision targetDecision;
            if (targetKind == LayoutDecision.Kind.SIZE) {
                targetDecision = decisions.get(targetSection).getDecision(targetKind);
                deps.add(BuildDependency.createOrGet(ourSize, targetDecision));
                continue;
            }
            if (targetKind == LayoutDecision.Kind.CONTENT) {
                targetDecision = decisions.get(targetSection).getDecision(targetKind);
                deps.add(BuildDependency.createOrGet(ourContent, targetDecision));
                continue;
            }
            targetDecision = decisions.get(targetSection).getDecision(targetKind);
            deps.add(BuildDependency.createOrGet(ourSize, targetDecision));
        }
        return deps;
    }

    protected Stream<? extends TypeEntry> getTypes() {
        return this.dwarfSections.getTypes().stream();
    }

    protected Iterable<? extends ClassEntry> getPrimaryClasses() {
        return this.dwarfSections.getPrimaryClasses();
    }

    protected int debugStringIndex(String str) {
        if (!this.contentByteArrayCreated()) {
            return 0;
        }
        return this.dwarfSections.debugStringIndex(str);
    }

    protected String uniqueDebugString(String str) {
        return this.dwarfSections.uniqueDebugString(str);
    }

    protected TypeEntry lookupType(String typeName) {
        return this.dwarfSections.lookupTypeEntry(typeName);
    }

    protected int getTypeIndex(String typeName) {
        if (!this.contentByteArrayCreated()) {
            return 0;
        }
        return this.dwarfSections.getTypeIndex(typeName);
    }

    protected void setTypeIndex(TypeEntry typeEntry, int pos) {
        this.dwarfSections.setTypeIndex(typeEntry, pos);
    }

    protected int getIndirectTypeIndex(String typeName) {
        if (!this.contentByteArrayCreated()) {
            return 0;
        }
        return this.dwarfSections.getIndirectTypeIndex(typeName);
    }

    protected void setIndirectTypeIndex(TypeEntry typeEntry, int pos) {
        this.dwarfSections.setIndirectTypeIndex(typeEntry, pos);
    }

    protected int getCUIndex(ClassEntry classEntry) {
        if (!this.contentByteArrayCreated()) {
            return 0;
        }
        return this.dwarfSections.getCUIndex(classEntry);
    }

    protected void setCUIndex(ClassEntry classEntry, int pos) {
        this.dwarfSections.setCUIndex(classEntry, pos);
    }

    protected int getDeoptCUIndex(ClassEntry classEntry) {
        if (!this.contentByteArrayCreated()) {
            return 0;
        }
        return this.dwarfSections.getDeoptCUIndex(classEntry);
    }

    protected void setDeoptCUIndex(ClassEntry classEntry, int pos) {
        this.dwarfSections.setDeoptCUIndex(classEntry, pos);
    }

    protected int getLineIndex(ClassEntry classEntry) {
        if (!this.contentByteArrayCreated()) {
            return 0;
        }
        return this.dwarfSections.getLineIndex(classEntry);
    }

    protected void setLineIndex(ClassEntry classEntry, int pos) {
        this.dwarfSections.setLineIndex(classEntry, pos);
    }

    protected int getLineSectionSize(ClassEntry classEntry) {
        if (!this.contentByteArrayCreated()) {
            return 0;
        }
        return this.dwarfSections.getLineSectionSize(classEntry);
    }

    protected void setLineSectionSize(ClassEntry classEntry, int pos) {
        this.dwarfSections.setLineSectionSize(classEntry, pos);
    }

    protected int getLinePrologueSize(ClassEntry classEntry) {
        if (!this.contentByteArrayCreated()) {
            return 0;
        }
        return this.dwarfSections.getLinePrologueSize(classEntry);
    }

    protected void setLinePrologueSize(ClassEntry classEntry, int pos) {
        this.dwarfSections.setLinePrologueSize(classEntry, pos);
    }

    protected int getLayoutIndex(ClassEntry classEntry) {
        if (!this.contentByteArrayCreated()) {
            return 0;
        }
        return this.dwarfSections.getLayoutIndex(classEntry);
    }

    protected void setIndirectLayoutIndex(ClassEntry classEntry, int pos) {
        this.dwarfSections.setIndirectLayoutIndex(classEntry, pos);
    }

    protected int getIndirectLayoutIndex(ClassEntry classEntry) {
        if (!this.contentByteArrayCreated()) {
            return 0;
        }
        return this.dwarfSections.getIndirectLayoutIndex(classEntry);
    }

    protected void setLayoutIndex(ClassEntry classEntry, int pos) {
        this.dwarfSections.setLayoutIndex(classEntry, pos);
    }

    protected void setFieldDeclarationIndex(StructureTypeEntry entry, String fieldName, int pos) {
        this.dwarfSections.setFieldDeclarationIndex(entry, fieldName, pos);
    }

    protected int getFieldDeclarationIndex(StructureTypeEntry entry, String fieldName) {
        if (!this.contentByteArrayCreated()) {
            return 0;
        }
        return this.dwarfSections.getFieldDeclarationIndex(entry, fieldName);
    }

    protected void setMethodDeclarationIndex(ClassEntry classEntry, String methodName, int pos) {
        this.dwarfSections.setMethodDeclarationIndex(classEntry, methodName, pos);
    }

    protected int getMethodDeclarationIndex(ClassEntry classEntry, String methodName) {
        if (!this.contentByteArrayCreated()) {
            return 0;
        }
        return this.dwarfSections.getMethodDeclarationIndex(classEntry, methodName);
    }

    protected void setAbstractInlineMethodIndex(ClassEntry classEntry, String methodName, int pos) {
        this.dwarfSections.setAbstractInlineMethodIndex(classEntry, methodName, pos);
    }

    protected int getAbstractInlineMethodIndex(ClassEntry classEntry, String methodName) {
        if (!this.contentByteArrayCreated()) {
            return 0;
        }
        return this.dwarfSections.getAbstractInlineMethodIndex(classEntry, methodName);
    }
}

