/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.pecoff;

import com.oracle.objectfile.BuildDependency;
import com.oracle.objectfile.ElementImpl;
import com.oracle.objectfile.LayoutDecision;
import com.oracle.objectfile.LayoutDecisionMap;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.SymbolTable;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import com.oracle.objectfile.io.AssemblyBuffer;
import com.oracle.objectfile.io.OutputAssembler;
import com.oracle.objectfile.pecoff.PECoff;
import com.oracle.objectfile.pecoff.PECoffHeaderStruct;
import com.oracle.objectfile.pecoff.PECoffMachine;
import com.oracle.objectfile.pecoff.PECoffNobitsSection;
import com.oracle.objectfile.pecoff.PECoffProgbitsSection;
import com.oracle.objectfile.pecoff.PECoffRelocationTable;
import com.oracle.objectfile.pecoff.PECoffSectionStruct;
import com.oracle.objectfile.pecoff.PECoffSymtab;
import com.oracle.objectfile.pecoff.PECoffUserDefinedSection;
import com.oracle.objectfile.pecoff.cv.CVDebugInfo;
import com.oracle.objectfile.pecoff.cv.CVSymbolSectionImpl;
import com.oracle.objectfile.pecoff.cv.CVTypeSectionImpl;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PECoffObjectFile
extends ObjectFile {
    private static ByteOrder byteOrder;
    private PECoffMachine machine = PECoffMachine.getSystemNativeValue();
    private PECoffHeader header;
    private SectionHeaderTable sht;
    private PECoffSymtab symtab;
    private PECoffDirectiveSection directives;
    private boolean runtimeDebugInfoGeneration;

    private PECoffObjectFile(int pageSize, boolean runtimeDebugInfoGeneration) {
        super(pageSize);
        this.runtimeDebugInfoGeneration = runtimeDebugInfoGeneration;
        this.header = new PECoffHeader("PECoffHeader");
        this.sht = new SectionHeaderTable();
        this.symtab = this.createSymbolTable();
        this.directives = new PECoffDirectiveSection(".drectve", 1);
    }

    public PECoffObjectFile(int pageSize) {
        this(pageSize, false);
    }

    @Override
    public ObjectFile.Format getFormat() {
        return ObjectFile.Format.PECOFF;
    }

    @Override
    protected PECoffSymtab createSymbolTable() {
        String name = ".symtab";
        PECoffSymtab st = (PECoffSymtab)this.elementForName(".symtab");
        if (st == null) {
            st = new PECoffSymtab(this, name);
        }
        return st;
    }

    @Override
    public ObjectFile.Symbol createDefinedSymbol(String name, ObjectFile.Element baseSection, long position, int size, boolean isCode, boolean isGlobal) {
        PECoffSymtab st = this.createSymbolTable();
        return st.newDefinedEntry(name, (ObjectFile.Section)baseSection, position, size, isGlobal, isCode);
    }

    @Override
    public ObjectFile.Symbol createUndefinedSymbol(String name, int size, boolean isCode) {
        PECoffSymtab st = this.createSymbolTable();
        return st.newUndefinedEntry(name, isCode);
    }

    @Override
    protected ObjectFile.Segment getOrCreateSegment(String maybeSegmentName, String sectionName, boolean writable, boolean executable) {
        return null;
    }

    @Override
    public PECoffUserDefinedSection newUserDefinedSection(ObjectFile.Segment segment, String name, int alignment, ElementImpl impl) {
        PECoffUserDefinedSection userDefined = new PECoffUserDefinedSection(this, name, alignment, impl);
        assert (userDefined.getImpl() == impl);
        if (segment != null) {
            this.getOrCreateSegment(segment.getName(), name, true, false).add(userDefined);
        }
        if (impl != null) {
            impl.setElement(userDefined);
        }
        return userDefined;
    }

    @Override
    public PECoffProgbitsSection newProgbitsSection(ObjectFile.Segment segment, String name, int alignment, boolean writable, boolean executable, ObjectFile.ProgbitsSectionImpl impl) {
        EnumSet<PECoffSectionFlag> flags = EnumSet.noneOf(PECoffSectionFlag.class);
        flags.add(PECoffSectionFlag.READ);
        if (executable) {
            flags.add(PECoffSectionFlag.EXECUTE);
            flags.add(PECoffSectionFlag.CODE);
        } else {
            flags.add(PECoffSectionFlag.INITIALIZED_DATA);
        }
        if (writable) {
            flags.add(PECoffSectionFlag.WRITE);
        }
        PECoffProgbitsSection progbits = new PECoffProgbitsSection(this, name, alignment, impl, flags);
        impl.setElement(progbits);
        return progbits;
    }

    @Override
    public PECoffNobitsSection newNobitsSection(ObjectFile.Segment segment, String name, ObjectFile.NobitsSectionImpl impl) {
        PECoffNobitsSection nobits = new PECoffNobitsSection(this, name, impl);
        impl.setElement(nobits);
        return nobits;
    }

    public PECoffSection getSectionByIndex(int i) {
        return (PECoffSection)this.elements.get(this.elements.sectionIndexToElementIndex(i - 1));
    }

    public int getIndexForSection(PECoffSection s) {
        return this.elements.elementIndexToSectionIndex(this.elements.indexOf(s)) + 1;
    }

    @Override
    protected boolean elementsCanSharePage(ObjectFile.Element s1, ObjectFile.Element s2, int off1, int off2) {
        if (s1 instanceof PECoffSection && s2 instanceof PECoffSection) {
            PECoffSection es1 = (PECoffSection)s1;
            PECoffSection es2 = (PECoffSection)s2;
            boolean flagsCompatible = PECoffSectionFlag.getMemSegmentFlags(es1.getFlags()) == PECoffSectionFlag.getMemSegmentFlags(es2.getFlags());
            return flagsCompatible && super.elementsCanSharePage(es1, es2, off1, off2);
        }
        if (s1 instanceof PECoffSection || s2 instanceof PECoffSection) {
            return false;
        }
        assert (!(s1 instanceof PECoffSection));
        assert (!(s2 instanceof PECoffSection));
        return true;
    }

    public List<PECoffSection> getPECoffSections() {
        ArrayList<PECoffSection> sections = new ArrayList<PECoffSection>(this.elements.sectionsCount());
        Iterator<ObjectFile.Section> it = this.elements.sectionsIterator();
        while (it.hasNext()) {
            PECoffSection pe = (PECoffSection)it.next();
            sections.add(pe);
        }
        return sections;
    }

    @Override
    public Set<ObjectFile.Segment> getSegments() {
        return new HashSet<ObjectFile.Segment>();
    }

    @Override
    public ByteOrder getByteOrder() {
        return byteOrder;
    }

    @Override
    public void setByteOrder(ByteOrder byteorder) {
        byteOrder = byteorder;
    }

    public static ByteOrder getTargetByteOrder() {
        return byteOrder;
    }

    @Override
    public int getWordSizeInBytes() {
        return 8;
    }

    @Override
    public boolean shouldRecordDebugRelocations() {
        return true;
    }

    public PECoffMachine getMachine() {
        return this.machine;
    }

    public PECoffRelocationTable getOrCreateRelocSection(PECoffSymtab syms, boolean withExplicitAddends) {
        PECoffRelocationTable rs;
        ObjectFile.Element el = this.elementForName(".reloctab");
        if (el == null) {
            rs = new PECoffRelocationTable(this, ".reloctab", syms, withExplicitAddends);
        } else if (el instanceof PECoffRelocationTable) {
            rs = (PECoffRelocationTable)el;
        } else {
            throw new IllegalStateException("section exists but is not an PECoffRelocationTable");
        }
        return rs;
    }

    @Override
    public SymbolTable getSymbolTable() {
        return (SymbolTable)((Object)this.elementForName(".symtab"));
    }

    public PECoffRelocationTable getRelocationTable() {
        return (PECoffRelocationTable)this.elementForName(".reloctab");
    }

    @Override
    protected int getMinimumFileSize() {
        return 0;
    }

    @Override
    public ObjectFile.Section newDebugSection(String name, ElementImpl impl) {
        PECoffSection coffSection = (PECoffSection)super.newDebugSection(name, impl);
        coffSection.getFlags().add(PECoffSectionFlag.DISCARDABLE);
        coffSection.getFlags().add(PECoffSectionFlag.READ);
        coffSection.getFlags().add(PECoffSectionFlag.INITIALIZED_DATA);
        return coffSection;
    }

    @Override
    public void installDebugInfo(DebugInfoProvider debugInfoProvider) {
        CVDebugInfo cvDebugInfo = new CVDebugInfo(this.getByteOrder());
        CVSymbolSectionImpl cvSymbolSectionImpl = cvDebugInfo.getCVSymbolSection();
        CVTypeSectionImpl cvTypeSectionImpl = cvDebugInfo.getCVTypeSection();
        this.newDebugSection(cvSymbolSectionImpl.getSectionName(), cvSymbolSectionImpl);
        this.newDebugSection(cvTypeSectionImpl.getSectionName(), cvTypeSectionImpl);
        cvSymbolSectionImpl.getOrCreateRelocationElement(false);
        cvTypeSectionImpl.getOrCreateRelocationElement(false);
        cvDebugInfo.installDebugInfo(debugInfoProvider);
    }

    public class PECoffDirectiveSection
    extends PECoffSection {
        public PECoffDirectiveSection(String name, int alignment) {
            super(name, alignment, EnumSet.of(PECoffSectionFlag.LINKER), -1);
        }

        @Override
        public ElementImpl getImpl() {
            return PECoffObjectFile.this.directives;
        }

        @Override
        public int getOrDecideOffset(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int offsetHint) {
            return PECoff.IMAGE_FILE_HEADER.totalsize + PECoffObjectFile.this.elements.sectionsCount() * PECoff.IMAGE_SECTION_HEADER.totalsize;
        }

        @Override
        public int getOrDecideVaddr(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int vaddrHint) {
            return ObjectFile.defaultGetOrDecideVaddr(alreadyDecided, this, vaddrHint);
        }

        @Override
        public LayoutDecisionMap getDecisions(LayoutDecisionMap copyingIn) {
            return ObjectFile.defaultDecisions(this, copyingIn);
        }

        @Override
        public Iterable<BuildDependency> getDependencies(Map<ObjectFile.Element, LayoutDecisionMap> decisions) {
            return ObjectFile.defaultDependencies(decisions, this);
        }

        @Override
        public byte[] getOrDecideContent(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, byte[] contentHint) {
            return PECoffObjectFile.this.symtab.getDirectiveArray();
        }

        @Override
        public int getOrDecideSize(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int sizeHint) {
            return PECoffObjectFile.this.symtab.getDirectiveSize();
        }
    }

    public class SectionHeaderTable
    extends ObjectFile.Element {
        @Override
        public ElementImpl getImpl() {
            return this;
        }

        @Override
        public boolean isLoadable() {
            return false;
        }

        public SectionHeaderTable() {
            super(".secthdrtab");
        }

        @Override
        public Iterable<BuildDependency> getDependencies(Map<ObjectFile.Element, LayoutDecisionMap> decisions) {
            HashSet<BuildDependency> deps = ObjectFile.defaultDependencies(decisions, this);
            LayoutDecision ourOffset = decisions.get(this).getDecision(LayoutDecision.Kind.OFFSET);
            LayoutDecision ourContent = decisions.get(this).getDecision(LayoutDecision.Kind.CONTENT);
            LayoutDecision hdrOffset = decisions.get(PECoffObjectFile.this.header).getDecision(LayoutDecision.Kind.OFFSET);
            LayoutDecision hdrSize = decisions.get(PECoffObjectFile.this.header).getDecision(LayoutDecision.Kind.SIZE);
            deps.add(BuildDependency.createOrGet(ourOffset, hdrOffset));
            deps.add(BuildDependency.createOrGet(ourOffset, hdrSize));
            LayoutDecision prevOffset = null;
            LayoutDecision prevSize = null;
            int sectionID = 0;
            for (ObjectFile.Section s : PECoffObjectFile.this.getSections()) {
                assert (s instanceof PECoffSection);
                PECoffSection pecoffS = (PECoffSection)s;
                pecoffS.setSectionID(sectionID++);
                LayoutDecision nextOffset = decisions.get(s).getDecision(LayoutDecision.Kind.OFFSET);
                if (prevOffset != null) {
                    deps.add(BuildDependency.createOrGet(nextOffset, prevOffset));
                }
                LayoutDecision nextSize = decisions.get(s).getDecision(LayoutDecision.Kind.SIZE);
                if (prevSize != null) {
                    deps.add(BuildDependency.createOrGet(nextOffset, prevSize));
                }
                deps.add(BuildDependency.createOrGet(ourContent, nextOffset));
                deps.add(BuildDependency.createOrGet(ourContent, nextSize));
                prevOffset = nextOffset;
                prevSize = nextSize;
            }
            PECoffRelocationTable reloctable = PECoffObjectFile.this.getRelocationTable();
            LayoutDecision relocOffset = decisions.get(reloctable).getDecision(LayoutDecision.Kind.OFFSET);
            LayoutDecision relocSize = decisions.get(reloctable).getDecision(LayoutDecision.Kind.SIZE);
            deps.add(BuildDependency.createOrGet(relocOffset, prevOffset));
            deps.add(BuildDependency.createOrGet(relocOffset, prevSize));
            deps.add(BuildDependency.createOrGet(ourContent, relocOffset));
            deps.add(BuildDependency.createOrGet(ourContent, relocSize));
            LayoutDecision symtabOffset = decisions.get(PECoffObjectFile.this.symtab).getDecision(LayoutDecision.Kind.OFFSET);
            deps.add(BuildDependency.createOrGet(symtabOffset, relocOffset));
            deps.add(BuildDependency.createOrGet(symtabOffset, relocSize));
            return deps;
        }

        @Override
        public int getOrDecideSize(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int sizeHint) {
            return PECoffObjectFile.this.elements.sectionsCount() * PECoff.IMAGE_SECTION_HEADER.totalsize;
        }

        @Override
        public byte[] getOrDecideContent(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, byte[] contentHint) {
            PECoffRelocationTable rt = (PECoffRelocationTable)PECoffObjectFile.this.elementForName(".reloctab");
            OutputAssembler out = AssemblyBuffer.createOutputAssembler(PECoffObjectFile.this.getByteOrder());
            int sectionIndex = 0;
            for (ObjectFile.Section s : PECoffObjectFile.this.getSections()) {
                PECoffSection es = (PECoffSection)s;
                int align = es.getAlignment() >= 1024 ? 16 : es.getAlignment();
                PECoffSectionStruct ent = new PECoffSectionStruct(PECoffObjectFile.this.nameForElement(s), (int)ObjectFile.flagSetAsLong(es.getFlags()), align, sectionIndex + 1);
                ent.setOffset((Integer)alreadyDecided.get(es).getDecidedValue(LayoutDecision.Kind.OFFSET));
                int sectionSize = (Integer)alreadyDecided.get(es).getDecidedValue(LayoutDecision.Kind.SIZE);
                if (sectionSize == 0) {
                    sectionSize = es.getMemSize(alreadyDecided);
                }
                ent.setSize(sectionSize);
                if (es.getFlags().contains(PECoffSectionFlag.READ) && PECoffObjectFile.this.runtimeDebugInfoGeneration) {
                    ent.setVirtualAddress((Integer)alreadyDecided.get(es).getDecidedValue(LayoutDecision.Kind.VADDR));
                } else {
                    ent.setVirtualAddress(0);
                }
                int relocBaseOffset = (Integer)alreadyDecided.get(rt).getDecidedValue(LayoutDecision.Kind.OFFSET);
                int relocCount = rt.getRelocCount(sectionIndex);
                if (relocCount > 0) {
                    ent.setRelcount(relocCount);
                    ent.setReloff(relocBaseOffset + rt.getRelocOffset(sectionIndex));
                }
                out.align(PECoffSectionStruct.getShdrAlign());
                out.writeBlob(ent.getArray());
                ++sectionIndex;
            }
            return out.getBlob();
        }

        @Override
        public LayoutDecisionMap getDecisions(LayoutDecisionMap copyingIn) {
            return ObjectFile.defaultDecisions(this, copyingIn);
        }

        @Override
        public int getOrDecideOffset(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int offsetHint) {
            return PECoff.IMAGE_FILE_HEADER.totalsize;
        }

        @Override
        public int getOrDecideVaddr(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int vaddrHint) {
            return ObjectFile.defaultGetOrDecideVaddr(alreadyDecided, this, vaddrHint);
        }
    }

    public static enum PECoffSectionFlag implements ObjectFile.ValueEnum
    {
        CODE(32),
        INITIALIZED_DATA(64),
        UNINITIALIZED_DATA(128),
        READ(0x40000000),
        WRITE(Integer.MIN_VALUE),
        EXECUTE(0x20000000),
        DISCARDABLE(0x2000000),
        LINKER(2560);

        private final int value;

        private PECoffSectionFlag(int value) {
            this.value = value;
        }

        @Override
        public long value() {
            return this.value;
        }

        public static long getMemSegmentFlags(EnumSet<PECoffSectionFlag> flags) {
            long out = READ.value();
            if (flags.contains(WRITE)) {
                out |= WRITE.value();
            }
            if (flags.contains(EXECUTE)) {
                out |= EXECUTE.value();
            }
            return out;
        }
    }

    public class PECoffHeader
    extends ObjectFile.Header {
        PECoffHeaderStruct hdr;

        public PECoffHeader(String name) {
            super(name);
            this.hdr = new PECoffHeaderStruct();
        }

        @Override
        public Iterable<BuildDependency> getDependencies(Map<ObjectFile.Element, LayoutDecisionMap> decisions) {
            HashSet<BuildDependency> dependencies = new HashSet<BuildDependency>();
            LayoutDecision ourContent = decisions.get(this).getDecision(LayoutDecision.Kind.CONTENT);
            LayoutDecision ourOffset = decisions.get(this).getDecision(LayoutDecision.Kind.OFFSET);
            LayoutDecision ourSize = decisions.get(this).getDecision(LayoutDecision.Kind.SIZE);
            LayoutDecision shtSize = decisions.get(PECoffObjectFile.this.sht).getDecision(LayoutDecision.Kind.SIZE);
            LayoutDecision symtOffset = decisions.get(PECoffObjectFile.this.symtab).getDecision(LayoutDecision.Kind.OFFSET);
            LayoutDecision symtSize = decisions.get(PECoffObjectFile.this.symtab).getDecision(LayoutDecision.Kind.SIZE);
            dependencies.add(BuildDependency.createOrGet(ourOffset, ourSize));
            dependencies.add(BuildDependency.createOrGet(ourContent, shtSize));
            dependencies.add(BuildDependency.createOrGet(ourContent, symtOffset));
            dependencies.add(BuildDependency.createOrGet(ourContent, symtSize));
            return dependencies;
        }

        @Override
        public byte[] getOrDecideContent(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, byte[] contentHint) {
            int sectSize = (Integer)alreadyDecided.get(PECoffObjectFile.this.sht).getDecidedValue(LayoutDecision.Kind.SIZE);
            this.hdr.setSectionCount(sectSize / PECoff.IMAGE_SECTION_HEADER.totalsize);
            this.hdr.setSymbolOff((Integer)alreadyDecided.get(PECoffObjectFile.this.symtab).getDecidedValue(LayoutDecision.Kind.OFFSET));
            this.hdr.setSymbolCount(PECoffObjectFile.this.symtab.getSymbolCount());
            return this.hdr.getArray();
        }

        @Override
        public int getOrDecideOffset(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int offsetHint) {
            return 0;
        }

        @Override
        public int getOrDecideSize(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int sizeHint) {
            return PECoff.IMAGE_FILE_HEADER.totalsize;
        }
    }

    public abstract class PECoffSection
    extends ObjectFile.Section {
        EnumSet<PECoffSectionFlag> flags;
        int sectionID;
        Object relocEntries;

        public PECoffSection(String name) {
            this(name, EnumSet.noneOf(PECoffSectionFlag.class));
        }

        public PECoffSection(String name, EnumSet<PECoffSectionFlag> flags) {
            this(name, this$0.getWordSizeInBytes(), flags, -1);
        }

        public PECoffSection(String name, int alignment, EnumSet<PECoffSectionFlag> flags, int sectionIndex) {
            super(name, alignment, sectionIndex == -1 ? -1 : PECoffObjectFile.this.elements.sectionIndexToElementIndex(sectionIndex - 1));
            this.flags = flags;
        }

        @Override
        public PECoffObjectFile getOwner() {
            return PECoffObjectFile.this;
        }

        @Override
        public boolean isLoadable() {
            if (this.getImpl() == this) {
                return this.flags.contains(PECoffSectionFlag.READ);
            }
            boolean implIsLoadable = this.getImpl().isLoadable();
            assert (implIsLoadable == this.flags.contains(PECoffSectionFlag.READ));
            return implIsLoadable;
        }

        @Override
        public boolean isReferenceable() {
            if (this.getImpl() == this) {
                return this.isLoadable();
            }
            return this.getImpl().isReferenceable();
        }

        public PECoffSection getLinkedSection() {
            return null;
        }

        public long getLinkedInfo() {
            return 0L;
        }

        public int getEntrySize() {
            return 0;
        }

        public EnumSet<PECoffSectionFlag> getFlags() {
            return this.flags;
        }

        public void setFlags(EnumSet<PECoffSectionFlag> flags) {
            this.flags = flags;
        }

        public void setSectionID(int id) {
            this.sectionID = id;
        }

        public int getSectionID() {
            return this.sectionID;
        }

        public void setRelocEntries(Object entries) {
            this.relocEntries = entries;
        }

        public Object getRelocEntries() {
            return this.relocEntries;
        }
    }
}

