/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.flow.AbstractVirtualInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.ActualParameterTypeFlow;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.AllInstantiatedTypeFlow;
import com.oracle.graal.pointsto.flow.FormalParamTypeFlow;
import com.oracle.graal.pointsto.flow.FormalReceiverTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.BytecodeLocation;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import java.util.Collection;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.nodes.ParameterNode;

public abstract class InvokeTypeFlow
extends TypeFlow<BytecodePosition> {
    protected final BytecodeLocation location;
    protected final TypeFlow<?>[] actualParameters;
    protected ActualReturnTypeFlow actualReturn;
    protected final InvokeTypeFlow originalInvoke;
    protected final AnalysisType receiverType;
    protected final AnalysisMethod targetMethod;

    protected InvokeTypeFlow(BytecodePosition invokeLocation, AnalysisType receiverType, AnalysisMethod targetMethod, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn, BytecodeLocation location) {
        super(invokeLocation, null);
        this.originalInvoke = null;
        this.location = location;
        this.receiverType = receiverType;
        this.targetMethod = targetMethod;
        this.actualParameters = actualParameters;
        this.actualReturn = actualReturn;
        this.getTargetMethod().registerAsInvoked(this);
    }

    protected InvokeTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, InvokeTypeFlow original) {
        super(original, methodFlows);
        this.originalInvoke = original;
        this.location = original.location;
        this.receiverType = original.receiverType;
        this.targetMethod = original.targetMethod;
        this.actualReturn = original.getActualReturn() != null ? (ActualReturnTypeFlow)methodFlows.lookupCloneOf(bb, original.getActualReturn()) : null;
        this.actualParameters = new TypeFlow[original.actualParameters.length];
        for (int i = 0; i < original.actualParameters.length; ++i) {
            if (original.getActualParameter(i) == null) continue;
            this.actualParameters[i] = methodFlows.lookupCloneOf(bb, original.getActualParameter(i));
        }
    }

    public abstract boolean isDirectInvoke();

    public AnalysisType getReceiverType() {
        return this.receiverType;
    }

    public AnalysisMethod getTargetMethod() {
        return this.targetMethod;
    }

    public int actualParametersCount() {
        return this.actualParameters.length;
    }

    public TypeFlow<?>[] getActualParameters() {
        return this.actualParameters;
    }

    public TypeFlow<?> getReceiver() {
        return this.actualParameters[0];
    }

    @Override
    public void setObserved(TypeFlow<?> newReceiver) {
        this.actualParameters[0] = newReceiver;
    }

    public TypeFlow<?> getActualParameter(int index) {
        return this.actualParameters[index];
    }

    public TypeFlow<?> getActualReturn() {
        return this.actualReturn;
    }

    public void setActualReturn(ActualReturnTypeFlow actualReturn) {
        this.actualReturn = actualReturn;
    }

    public TypeFlow<?> getResult() {
        return this.actualReturn;
    }

    @Override
    public boolean addState(PointsToAnalysis bb, TypeState add) {
        assert (this.isClone());
        return super.addState(bb, add);
    }

    protected TypeState filterReceiverState(PointsToAnalysis bb, TypeState invokeState) {
        if (bb.analysisPolicy().relaxTypeFlowConstraints()) {
            return TypeState.forIntersection(bb, invokeState, this.receiverType.getAssignableTypes(true));
        }
        return invokeState;
    }

    protected void updateReceiver(PointsToAnalysis bb, MethodFlowsGraph calleeFlows, AnalysisObject receiverObject) {
        TypeState receiverTypeState = TypeState.forExactType(bb, receiverObject, false);
        this.updateReceiver(bb, calleeFlows, receiverTypeState);
    }

    protected void updateReceiver(PointsToAnalysis bb, MethodFlowsGraph calleeFlows, TypeState receiverTypeState) {
        FormalReceiverTypeFlow formalReceiverFlow = calleeFlows.getFormalReceiver();
        if (formalReceiverFlow != null) {
            formalReceiverFlow.addReceiverState(bb, receiverTypeState);
        }
        if (((Boolean)PointstoOptions.DivertParameterReturningMethod.getValue(bb.getOptions())).booleanValue()) {
            ParameterNode paramNode = calleeFlows.getMethod().getTypeFlow().getReturnedParameter();
            if (this.actualReturn != null && paramNode != null && paramNode.index() == 0) {
                this.actualReturn.addState(bb, receiverTypeState);
            }
        }
    }

    protected void linkCallee(PointsToAnalysis bb, boolean isStatic, MethodFlowsGraph calleeFlows) {
        TypeFlow<BytecodePosition> actualParam;
        for (int i = 0; i < this.actualParameters.length; ++i) {
            actualParam = this.actualParameters[i];
            FormalParamTypeFlow formalParam = calleeFlows.getParameter(i);
            if (actualParam == null || formalParam == null) continue;
            actualParam.addUse(bb, formalParam);
        }
        if (this.actualReturn != null) {
            if (((Boolean)PointstoOptions.DivertParameterReturningMethod.getValue(bb.getOptions())).booleanValue()) {
                ParameterNode paramNode = calleeFlows.getMethod().getTypeFlow().getReturnedParameter();
                if (paramNode != null) {
                    if (isStatic || paramNode.index() != 0) {
                        actualParam = this.actualParameters[paramNode.index()];
                        actualParam.addUse(bb, this.actualReturn);
                    }
                } else if (calleeFlows.getResult() != null) {
                    calleeFlows.getResult().addUse(bb, this.actualReturn);
                }
            } else if (calleeFlows.getResult() != null) {
                calleeFlows.getResult().addUse(bb, this.actualReturn);
            }
        }
        assert (this.isClone() || InvokeTypeFlow.isContextInsensitiveVirtualInvoke(this));
        if (InvokeTypeFlow.isContextInsensitiveVirtualInvoke(this)) {
            calleeFlows.getMethod().registerAsImplementationInvoked(this);
        } else {
            calleeFlows.getMethod().registerAsImplementationInvoked(this.originalInvoke);
        }
    }

    public static boolean isContextInsensitiveVirtualInvoke(InvokeTypeFlow invoke) {
        return invoke instanceof AbstractVirtualInvokeTypeFlow && ((AbstractVirtualInvokeTypeFlow)invoke).isContextInsensitive();
    }

    public abstract Collection<AnalysisMethod> getCallees();

    public boolean canBeStaticallyBound() {
        boolean triviallyStaticallyBound = this.targetMethod.canBeStaticallyBound();
        if (triviallyStaticallyBound) {
            assert (this.getCallees().size() <= 1) : "Statically bound result mismatch between analysis and host VM.";
            return true;
        }
        return this.getCallees().size() == 1;
    }

    public abstract Collection<MethodFlowsGraph> getCalleesFlows(PointsToAnalysis var1);

    public static AbstractVirtualInvokeTypeFlow createContextInsensitiveInvoke(PointsToAnalysis bb, AnalysisMethod method, BytecodePosition originalLocation) {
        TypeFlow[] actualParameters = new TypeFlow[method.getSignature().getParameterCount(true)];
        AnalysisType receiverType = method.getDeclaringClass();
        AllInstantiatedTypeFlow receiverFlow = receiverType.getTypeFlow(bb, false);
        actualParameters[0] = receiverFlow;
        for (int i = 1; i < actualParameters.length; ++i) {
            actualParameters[i] = new ActualParameterTypeFlow((AnalysisType)method.getSignature().getParameterType(i - 1, null));
        }
        ActualReturnTypeFlow actualReturn = null;
        AnalysisType returnType = (AnalysisType)method.getSignature().getReturnType(null);
        if (returnType.getStorageKind() == JavaKind.Object) {
            actualReturn = new ActualReturnTypeFlow(returnType);
        }
        AbstractVirtualInvokeTypeFlow invoke = bb.analysisPolicy().createVirtualInvokeTypeFlow(originalLocation, receiverType, method, actualParameters, actualReturn, BytecodeLocation.UNKNOWN_BYTECODE_LOCATION);
        invoke.markAsContextInsensitive();
        return invoke;
    }

    public static void initContextInsensitiveInvoke(PointsToAnalysis bb, AnalysisMethod method, InvokeTypeFlow invoke) {
        AnalysisType receiverType = method.getDeclaringClass();
        AllInstantiatedTypeFlow receiverFlow = receiverType.getTypeFlow(bb, false);
        receiverFlow.addObserver(bb, invoke);
    }
}

