/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow.context.free;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContextPolicy;
import com.oracle.graal.pointsto.flow.context.BytecodeLocation;
import com.oracle.graal.pointsto.flow.context.free.DefaultAnalysisContext;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;

public class DefaultAnalysisContextPolicy
extends AnalysisContextPolicy<DefaultAnalysisContext> {
    public DefaultAnalysisContextPolicy() {
        super(DefaultAnalysisContextPolicy.getEmptyContext());
    }

    private static DefaultAnalysisContext getEmptyContext() {
        return new DefaultAnalysisContext();
    }

    @Override
    public DefaultAnalysisContext peel(DefaultAnalysisContext context, int maxDepth) {
        assert (context.equals(this.emptyContext()));
        return context;
    }

    @Override
    public DefaultAnalysisContext calleeContext(PointsToAnalysis bb, AnalysisObject receiverObject, DefaultAnalysisContext callerContext, MethodTypeFlow callee) {
        assert (callerContext.equals(this.emptyContext()));
        assert (receiverObject.isContextInsensitiveObject());
        return callerContext;
    }

    @Override
    public DefaultAnalysisContext staticCalleeContext(PointsToAnalysis bb, BytecodeLocation invokeLocation, DefaultAnalysisContext callerContext, MethodTypeFlow callee) {
        assert (callerContext.equals(this.emptyContext()));
        return callerContext;
    }

    @Override
    public DefaultAnalysisContext allocationContext(DefaultAnalysisContext context, int maxHeapContextDepth) {
        return this.peel(context, maxHeapContextDepth);
    }

    public DefaultAnalysisContext getContext(BytecodeLocation bcl) {
        return this.getContext(new BytecodeLocation[]{bcl});
    }

    public DefaultAnalysisContext getContext(BytecodeLocation[] bytecodeLocations) {
        return this.lookupContext(bytecodeLocations);
    }

    private DefaultAnalysisContext lookupContext(BytecodeLocation[] bytecodeLocations) {
        assert (bytecodeLocations.length == 0);
        return (DefaultAnalysisContext)this.emptyContext();
    }
}

