/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.reports;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.AllInstantiatedTypeFlow;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.HashSet;
import java.util.function.Consumer;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class ReportUtils {
    static final String CONNECTING_INDENT = "\u2502   ";
    static final String EMPTY_INDENT = "    ";
    static final String CHILD = "\u251c\u2500\u2500 ";
    static final String LAST_CHILD = "\u2514\u2500\u2500 ";
    public static final Comparator<ResolvedJavaMethod> methodComparator = Comparator.comparing(m -> m.format("%H.%n(%p)"));
    static final Comparator<AnalysisField> fieldComparator = Comparator.comparing(f -> f.format("%H.%n"));
    static final Comparator<InvokeTypeFlow> invokeComparator = Comparator.comparing(i -> i.getTargetMethod().format("%H.%n(%p)"));
    static final Comparator<BytecodePosition> positionMethodComparator = Comparator.comparing(pos -> pos.getMethod().format("%H.%n(%p)"));
    static final Comparator<BytecodePosition> positionComparator = positionMethodComparator.thenComparing(pos -> pos.getBCI());

    public static void report(String description, String path, String name, String extension, Consumer<PrintWriter> reporter) {
        String fileName = ReportUtils.timeStampedFileName(name, extension);
        Path reportDir = Paths.get(path, new String[0]);
        ReportUtils.reportImpl(description, reportDir, fileName, reporter);
    }

    public static String timeStampedFileName(String name, String extension) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");
        String timeStamp = LocalDateTime.now().format(formatter);
        String fileName = name + "_" + timeStamp;
        return extension.isEmpty() ? fileName : fileName + "." + extension;
    }

    public static File reportFile(String path, String name, String extension) {
        try {
            String fileName = ReportUtils.timeStampedFileName(name, extension);
            Path reportDir = Files.createDirectories(Paths.get(path, new String[0]), new FileAttribute[0]);
            Path filePath = reportDir.resolve(fileName);
            Files.deleteIfExists(filePath);
            return Files.createFile(filePath, new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void report(String description, Path file, Consumer<PrintWriter> reporter) {
        Path folder = file.getParent();
        Path fileName = file.getFileName();
        if (folder == null || fileName == null) {
            throw new IllegalArgumentException("File parameter must be a file, got: " + file);
        }
        ReportUtils.reportImpl(description, folder, fileName.toString(), reporter);
    }

    private static void reportImpl(String description, Path folder, String fileName, Consumer<PrintWriter> reporter) {
        try {
            Path reportDir = Files.createDirectories(folder, new FileAttribute[0]);
            Path file = reportDir.resolve(fileName);
            Files.deleteIfExists(file);
            try (FileWriter fw = new FileWriter(Files.createFile(file, new FileAttribute[0]).toFile());
                 PrintWriter writer = new PrintWriter(fw);){
                System.out.println("# Printing " + description + " to: " + file);
                reporter.accept(writer);
            }
        }
        catch (IOException e) {
            throw JVMCIError.shouldNotReachHere((Throwable)e);
        }
    }

    public static Path getCWDRelativePath(Path path) {
        Path cwd = Paths.get("", new String[0]).toAbsolutePath();
        try {
            return cwd.relativize(path);
        }
        catch (IllegalArgumentException e) {
            return path;
        }
    }

    public static String extractImageName(String imageName) {
        return imageName.substring(imageName.lastIndexOf(File.separatorChar) + 1);
    }

    public static void report(String description, Path file, boolean append, Consumer<OutputStream> reporter) {
        Path folder = file.getParent();
        Path fileName = file.getFileName();
        if (folder == null || fileName == null) {
            throw new IllegalArgumentException("File parameter must be a file, got: " + file);
        }
        ReportUtils.reportImpl(description, folder, fileName.toString(), reporter, append);
    }

    private static void reportImpl(String description, Path folder, String fileName, Consumer<OutputStream> reporter, boolean append) {
        try {
            Path reportDir = Files.createDirectories(folder, new FileAttribute[0]);
            Path file = reportDir.resolve(fileName);
            try (OutputStream fos = Files.newOutputStream(file, StandardOpenOption.CREATE, StandardOpenOption.WRITE, append ? StandardOpenOption.APPEND : StandardOpenOption.TRUNCATE_EXISTING);){
                System.out.println("# Printing " + description + " to: " + file);
                reporter.accept(fos);
                fos.flush();
            }
        }
        catch (IOException e) {
            throw JVMCIError.shouldNotReachHere((Throwable)e);
        }
    }

    public static String parsingContext(AnalysisMethod method) {
        return ReportUtils.parsingContext(method, 0, "   ");
    }

    public static String parsingContext(AnalysisMethod method, String indent) {
        return ReportUtils.parsingContext(method, 0, indent);
    }

    public static String parsingContext(BytecodePosition context) {
        return ReportUtils.parsingContext((AnalysisMethod)context.getMethod(), context.getBCI(), "   ");
    }

    public static String parsingContext(AnalysisMethod method, int bci, String indent) {
        StringBuilder msg = new StringBuilder();
        if (method.getTypeFlow().getParsingContext().length > 0) {
            msg.append(String.format("%n%sat %s", indent, method.asStackTraceElement(bci)));
            for (StackTraceElement e : method.getTypeFlow().getParsingContext()) {
                msg.append(String.format("%n%sat %s", indent, e));
            }
            msg.append(String.format("%n", new Object[0]));
        } else {
            msg.append(String.format(" <no parsing context available> %n", new Object[0]));
        }
        return msg.toString();
    }

    public static String typePropagationTrace(PointsToAnalysis bb, TypeFlow<?> flow, AnalysisType type) {
        return ReportUtils.typePropagationTrace(bb, flow, type, "   ");
    }

    public static String typePropagationTrace(PointsToAnalysis bb, TypeFlow<?> flow, AnalysisType type, String indent) {
        if (bb.trackTypeFlowInputs()) {
            StringBuilder msg = new StringBuilder(String.format("Propagation trace through type flows for type %s: %n", type.toJavaName()));
            ReportUtils.followInput(flow, type, indent, new HashSet(), msg);
            return msg.toString();
        }
        return String.format("To print the propagation trace through type flows for type %s set the -H:+TrackInputFlows option. %n", type.toJavaName());
    }

    private static void followInput(TypeFlow<?> flow, AnalysisType type, String indent, HashSet<TypeFlow<?>> seen, StringBuilder msg) {
        seen.add(flow);
        if (flow instanceof AllInstantiatedTypeFlow) {
            msg.append(String.format("AllInstantiated(%s)%n", flow.getDeclaredType().toJavaName(true)));
        } else {
            msg.append(String.format("%sat %s: %s%n", indent, flow.formatSource(), flow.format(false, false)));
            for (TypeFlow<?> input : flow.getInputs()) {
                if (seen.contains(input) || !input.getState().containsType(type)) continue;
                ReportUtils.followInput(input, type, indent, seen, msg);
                break;
            }
        }
    }
}

