/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.util;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.reports.ReportUtils;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public class AnalysisError
extends Error {
    private static final long serialVersionUID = -4489048906003856416L;

    AnalysisError() {
    }

    AnalysisError(String msg) {
        super(msg);
    }

    AnalysisError(Throwable ex) {
        super(ex);
    }

    AnalysisError(String msg, Throwable cause) {
        super(msg, cause);
    }

    public static TypeNotFoundError typeNotFound(ResolvedJavaType type) {
        throw new TypeNotFoundError(type);
    }

    public static ParsingError parsingError(AnalysisMethod method, Throwable original) {
        throw new ParsingError(method, original);
    }

    public static FieldNotPresentError fieldNotPresentError(PointsToAnalysis bb, TypeFlow<?> objectFlow, BytecodePosition context, AnalysisField field, AnalysisType type) {
        throw new FieldNotPresentError(bb, objectFlow, context, field, type);
    }

    public static RuntimeException shouldNotReachHere() {
        throw new AnalysisError("should not reach here");
    }

    public static RuntimeException shouldNotReachHere(String msg) {
        throw new AnalysisError("should not reach here: " + msg);
    }

    public static RuntimeException shouldNotReachHere(Throwable cause) {
        throw new AnalysisError(cause);
    }

    public static RuntimeException shouldNotReachHere(String msg, Throwable cause) {
        throw new AnalysisError(msg, cause);
    }

    public static void guarantee(boolean condition) {
        if (!condition) {
            throw new AnalysisError("guarantee failed");
        }
    }

    public static void guarantee(boolean condition, String format, Object ... args) {
        if (!condition) {
            throw new AnalysisError(String.format(format, args));
        }
    }

    public static class FieldNotPresentError
    extends AnalysisError {
        private static final long serialVersionUID = -7167507945764369928L;

        FieldNotPresentError(PointsToAnalysis bb, TypeFlow<?> objectFlow, BytecodePosition context, AnalysisField field, AnalysisType type) {
            super(FieldNotPresentError.message(bb, objectFlow, context, field, type));
        }

        private static String message(PointsToAnalysis bb, TypeFlow<?> objectFlow, BytecodePosition context, AnalysisField field, AnalysisType type) {
            String msg = String.format("Analysis is trying to access field %s on an object of type %s. ", field.format("%H.%n"), type.toJavaName());
            msg = msg + String.format("This usually means that a type constraint is missing in the points-to graph. %n", new Object[0]);
            if (objectFlow != null) {
                msg = msg + ReportUtils.typePropagationTrace(bb, objectFlow, type);
            }
            if (context != null) {
                msg = msg + String.format("The error was encountered while analyzing %s.%n", context.getMethod().format("%H.%n(%P)"));
                msg = msg + "Parsing context:" + ReportUtils.parsingContext(context);
            }
            return msg;
        }
    }

    public static class ParsingError
    extends AnalysisError {
        private static final long serialVersionUID = -7167507945764369928L;
        private final AnalysisMethod method;

        ParsingError(AnalysisMethod method, Throwable cause) {
            super(ParsingError.message(method), cause);
            this.method = method;
        }

        public AnalysisMethod getMethod() {
            return this.method;
        }

        private static String message(AnalysisMethod method) {
            String msg = String.format("Error encountered while parsing %s %n", method.format("%H.%n(%P)"));
            msg = msg + "Parsing context:" + ReportUtils.parsingContext(method);
            return msg;
        }
    }

    public static class TypeNotFoundError
    extends AnalysisError {
        private static final long serialVersionUID = -7167507945764369928L;
        private final ResolvedJavaType type;

        TypeNotFoundError(ResolvedJavaType type) {
            super("Type not found during analysis: " + type);
            this.type = type;
        }

        public ResolvedJavaType getType() {
            return this.type;
        }
    }
}

