/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.code.CodeInfoDecoder;
import com.oracle.svm.core.code.CodeInfoEncoder;
import com.oracle.svm.core.code.MethodMetadataEncoding;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.meta.SharedType;
import com.oracle.svm.core.util.ByteArrayReader;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.core.common.util.UnsafeArrayTypeWriter;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.util.GuardedAnnotationAccess;
import sun.invoke.util.Wrapper;
import sun.reflect.annotation.AnnotationType;
import sun.reflect.annotation.TypeAnnotation;
import sun.reflect.annotation.TypeAnnotationParser;

@Platforms(value={Platform.HOSTED_ONLY.class})
public class MethodMetadataEncoder {
    public static final int NO_METHOD_METADATA = -1;
    private CodeInfoEncoder.Encoders encoders;
    private TreeSet<SharedType> sortedTypes;
    private Map<SharedType, Set<Pair<SharedMethod, Executable>>> queriedMethodData;
    private Map<SharedType, Set<SharedMethod>> reachableMethodData;
    private Map<SharedType, Set<CodeInfoDecoder.MethodDescriptor>> hiddenMethodData;
    private byte[] methodDataEncoding;
    private byte[] methodDataIndexEncoding;
    private static final Method parseAllTypeAnnotations = ReflectionUtil.lookupMethod(TypeAnnotationParser.class, (String)"parseAllTypeAnnotations", (Class[])new Class[]{AnnotatedElement.class});
    private static final Method hasRealParameterData = ReflectionUtil.lookupMethod(Executable.class, (String)"hasRealParameterData", (Class[])new Class[0]);
    private static final Method getMethodSignature = ReflectionUtil.lookupMethod(Method.class, (String)"getGenericSignature", (Class[])new Class[0]);
    private static final Method getConstructorSignature = ReflectionUtil.lookupMethod(Constructor.class, (String)"getSignature", (Class[])new Class[0]);
    private static final byte CLASS_TYPE_PARAMETER = 0;
    private static final byte METHOD_TYPE_PARAMETER = 1;
    private static final byte CLASS_EXTENDS = 16;
    private static final byte CLASS_TYPE_PARAMETER_BOUND = 17;
    private static final byte METHOD_TYPE_PARAMETER_BOUND = 18;
    private static final byte FIELD = 19;
    private static final byte METHOD_RETURN = 20;
    private static final byte METHOD_RECEIVER = 21;
    private static final byte METHOD_FORMAL_PARAMETER = 22;
    private static final byte THROWS = 23;
    private static final Field locationInfoDepth = ReflectionUtil.lookupField(TypeAnnotation.LocationInfo.class, (String)"depth");
    private static final Field locationInfoLocations = ReflectionUtil.lookupField(TypeAnnotation.LocationInfo.class, (String)"locations");

    MethodMetadataEncoder(CodeInfoEncoder.Encoders encoders) {
        this.encoders = encoders;
        this.sortedTypes = new TreeSet<SharedType>(Comparator.comparingLong(t -> t.getHub().getTypeID()));
        if (SubstrateOptions.ConfigureReflectionMetadata.getValue().booleanValue()) {
            this.queriedMethodData = new HashMap<SharedType, Set<Pair<SharedMethod, Executable>>>();
            this.hiddenMethodData = new HashMap<SharedType, Set<CodeInfoDecoder.MethodDescriptor>>();
        }
        if (SubstrateOptions.IncludeMethodData.getValue().booleanValue()) {
            this.reachableMethodData = new HashMap<SharedType, Set<SharedMethod>>();
        }
    }

    void encodeAllAndInstall() {
        this.encodeMethodMetadata();
        ((MethodMetadataEncoding)ImageSingletons.lookup(MethodMetadataEncoding.class)).setMethodsEncoding(this.methodDataEncoding);
        ((MethodMetadataEncoding)ImageSingletons.lookup(MethodMetadataEncoding.class)).setIndexEncoding(this.methodDataIndexEncoding);
    }

    public void prepareMetadataForClass(Class<?> clazz) {
        this.encoders.sourceClasses.addObject(clazz);
        if (clazz.isAnnotation()) {
            try {
                for (String valueName : AnnotationType.getInstance(clazz).members().keySet()) {
                    this.encoders.sourceMethodNames.addObject((Object)valueName);
                }
            }
            catch (LinkageError | RuntimeException throwable) {
                // empty catch block
            }
        }
    }

    public void prepareMetadataForMethod(SharedMethod method, Executable reflectMethod, boolean complete) {
        if (reflectMethod instanceof Constructor) {
            this.encoders.sourceMethodNames.addObject((Object)"<init>");
        } else {
            this.encoders.sourceMethodNames.addObject((Object)reflectMethod.getName());
        }
        if (complete) {
            this.encoders.sourceMethodNames.addObject((Object)MethodMetadataEncoder.getSignature(reflectMethod));
            for (Parameter parameter : reflectMethod.getParameters()) {
                this.encoders.sourceMethodNames.addObject((Object)parameter.getName());
            }
            this.registerStrings(GuardedAnnotationAccess.getDeclaredAnnotations((AnnotatedElement)((Object)method)));
            for (Parameter parameter : reflectMethod.getParameterAnnotations()) {
                this.registerStrings((Annotation[])parameter);
            }
            try {
                for (TypeAnnotation typeAnnotation : (TypeAnnotation[])parseAllTypeAnnotations.invoke(null, reflectMethod)) {
                    this.registerStrings(typeAnnotation.getAnnotation());
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw VMError.shouldNotReachHere();
            }
        }
        SharedType declaringType = (SharedType)method.getDeclaringClass();
        this.sortedTypes.add(declaringType);
        if (complete) {
            this.queriedMethodData.computeIfAbsent(declaringType, t -> new HashSet()).add(Pair.create((Object)method, (Object)reflectMethod));
        } else {
            this.reachableMethodData.computeIfAbsent(declaringType, t -> new HashSet()).add(method);
        }
    }

    public void prepareHiddenMethodMetadata(SharedType type, String name, Class<?>[] parameterTypes) {
        this.encoders.sourceMethodNames.addObject((Object)name);
        this.sortedTypes.add(type);
        this.hiddenMethodData.computeIfAbsent(type, t -> new HashSet()).add(new CodeInfoDecoder.MethodDescriptor(name, parameterTypes));
    }

    /*
     * Exception decompiling
     */
    private void encodeMethodMetadata() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "Object.getClass()" because "unbound" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.doBind(GenericTypeBinder.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBindings(GenericTypeBinder.java:135)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.getIterableIterType(LoopLivenessClash.java:36)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.detect(LoopLivenessClash.java:66)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.detect(LoopLivenessClash.java:25)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:827)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Class<?> getJavaClass(SharedType sharedType) {
        return sharedType.getHub().getHostedJavaClass();
    }

    private Class<?>[] filterTypes(Class<?>[] types) {
        ArrayList filteredTypes = new ArrayList();
        for (Class<?> type : types) {
            if (!this.encoders.sourceClasses.contains(type)) continue;
            filteredTypes.add(type);
        }
        return filteredTypes.toArray(new Class[0]);
    }

    private static String getSignature(Executable method) {
        try {
            return (String)(method instanceof Method ? getMethodSignature.invoke((Object)method, new Object[0]) : getConstructorSignature.invoke((Object)method, new Object[0]));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw VMError.shouldNotReachHere();
        }
    }

    byte[] encodeAnnotations(Annotation[] annotations) throws InvocationTargetException, IllegalAccessException {
        UnsafeArrayTypeWriter buf = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        Annotation[] filteredAnnotations = this.filterAnnotations(annotations);
        buf.putU2((long)filteredAnnotations.length);
        for (Annotation annotation : filteredAnnotations) {
            this.encodeAnnotation(buf, annotation);
        }
        return buf.toArray();
    }

    byte[] encodeParameterAnnotations(Annotation[][] annotations) throws InvocationTargetException, IllegalAccessException {
        UnsafeArrayTypeWriter buf = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        buf.putU1((long)annotations.length);
        for (Annotation[] parameterAnnotations : annotations) {
            Annotation[] filteredParameterAnnotations = this.filterAnnotations(parameterAnnotations);
            buf.putU2((long)filteredParameterAnnotations.length);
            for (Annotation parameterAnnotation : filteredParameterAnnotations) {
                this.encodeAnnotation(buf, parameterAnnotation);
            }
        }
        return buf.toArray();
    }

    void encodeAnnotation(UnsafeArrayTypeWriter buf, Annotation annotation) throws InvocationTargetException, IllegalAccessException {
        buf.putS4((long)this.encoders.sourceClasses.getIndex(annotation.annotationType()));
        AnnotationType type = AnnotationType.getInstance(annotation.annotationType());
        buf.putU2((long)type.members().size());
        for (Map.Entry<String, Method> entry : type.members().entrySet()) {
            String memberName = entry.getKey();
            Method valueAccessor = entry.getValue();
            buf.putS4((long)this.encoders.sourceMethodNames.getIndex((Object)memberName));
            this.encodeValue(buf, valueAccessor.invoke((Object)annotation, new Object[0]), type.memberTypes().get(memberName));
        }
    }

    void encodeValue(UnsafeArrayTypeWriter buf, Object value, Class<?> type) throws InvocationTargetException, IllegalAccessException {
        buf.putU1((long)this.tag(type));
        if (type.isAnnotation()) {
            this.encodeAnnotation(buf, (Annotation)value);
        } else if (type.isEnum()) {
            buf.putS4((long)this.encoders.sourceClasses.getIndex(type));
            buf.putS4((long)this.encoders.sourceMethodNames.getIndex((Object)((Enum)value).name()));
        } else if (type.isArray()) {
            this.encodeArray(buf, value, type.getComponentType());
        } else if (type == Class.class) {
            buf.putS4((long)this.encoders.sourceClasses.getIndex((Object)((Class)value)));
        } else if (type == String.class) {
            buf.putS4((long)this.encoders.sourceMethodNames.getIndex((Object)((String)value)));
        } else if (type.isPrimitive() || Wrapper.isWrapperType(type)) {
            Wrapper wrapper = type.isPrimitive() ? Wrapper.forPrimitiveType(type) : Wrapper.forWrapperType(type);
            switch (wrapper) {
                case BOOLEAN: {
                    buf.putU1((Boolean)value != false ? 1L : 0L);
                    break;
                }
                case BYTE: {
                    buf.putS1((long)((Byte)value).byteValue());
                    break;
                }
                case SHORT: {
                    buf.putS2((long)((Short)value).shortValue());
                    break;
                }
                case CHAR: {
                    buf.putU2((long)((Character)value).charValue());
                    break;
                }
                case INT: {
                    buf.putS4((long)((Integer)value).intValue());
                    break;
                }
                case LONG: {
                    buf.putS8(((Long)value).longValue());
                    break;
                }
                case FLOAT: {
                    buf.putS4((long)Float.floatToRawIntBits(((Float)value).floatValue()));
                    break;
                }
                case DOUBLE: {
                    buf.putS8(Double.doubleToRawLongBits((Double)value));
                    break;
                }
                default: {
                    throw VMError.shouldNotReachHere();
                }
            }
        } else {
            throw VMError.shouldNotReachHere();
        }
    }

    void encodeArray(UnsafeArrayTypeWriter buf, Object value, Class<?> componentType) throws InvocationTargetException, IllegalAccessException {
        block10: {
            block17: {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    block11: {
                                        block9: {
                                            if (componentType.isPrimitive()) break block9;
                                            Object[] array = (Object[])value;
                                            buf.putU2((long)array.length);
                                            for (Object val : array) {
                                                this.encodeValue(buf, val, componentType);
                                            }
                                            break block10;
                                        }
                                        if (componentType != Boolean.TYPE) break block11;
                                        boolean[] array = (boolean[])value;
                                        buf.putU2((long)array.length);
                                        for (boolean val : array) {
                                            this.encodeValue(buf, val, componentType);
                                        }
                                        break block10;
                                    }
                                    if (componentType != Byte.TYPE) break block12;
                                    byte[] array = (byte[])value;
                                    buf.putU2((long)array.length);
                                    for (byte val : array) {
                                        this.encodeValue(buf, val, componentType);
                                    }
                                    break block10;
                                }
                                if (componentType != Short.TYPE) break block13;
                                short[] array = (short[])value;
                                buf.putU2((long)array.length);
                                for (short val : array) {
                                    this.encodeValue(buf, val, componentType);
                                }
                                break block10;
                            }
                            if (componentType != Character.TYPE) break block14;
                            char[] array = (char[])value;
                            buf.putU2((long)array.length);
                            for (char val : array) {
                                this.encodeValue(buf, Character.valueOf(val), componentType);
                            }
                            break block10;
                        }
                        if (componentType != Integer.TYPE) break block15;
                        int[] array = (int[])value;
                        buf.putU2((long)array.length);
                        for (int val : array) {
                            this.encodeValue(buf, val, componentType);
                        }
                        break block10;
                    }
                    if (componentType != Long.TYPE) break block16;
                    long[] array = (long[])value;
                    buf.putU2((long)array.length);
                    for (long val : array) {
                        this.encodeValue(buf, val, componentType);
                    }
                    break block10;
                }
                if (componentType != Float.TYPE) break block17;
                float[] array = (float[])value;
                buf.putU2((long)array.length);
                for (float val : array) {
                    this.encodeValue(buf, Float.valueOf(val), componentType);
                }
                break block10;
            }
            if (componentType != Double.TYPE) break block10;
            double[] array = (double[])value;
            buf.putU2((long)array.length);
            for (double val : array) {
                this.encodeValue(buf, val, componentType);
            }
        }
    }

    byte tag(Class<?> type) {
        if (type.isAnnotation()) {
            return 64;
        }
        if (type.isEnum()) {
            return 101;
        }
        if (type.isArray()) {
            return 91;
        }
        if (type == Class.class) {
            return 99;
        }
        if (type == String.class) {
            return 115;
        }
        if (type.isPrimitive()) {
            return (byte)Wrapper.forPrimitiveType(type).basicTypeChar();
        }
        if (Wrapper.isWrapperType(type)) {
            return (byte)Wrapper.forWrapperType(type).basicTypeChar();
        }
        throw VMError.shouldNotReachHere();
    }

    private Annotation[] filterAnnotations(Annotation[] annotations) {
        ArrayList<Annotation> filteredAnnotations = new ArrayList<Annotation>();
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> annotationClass = annotation.annotationType();
            if (!this.supportedValue(annotationClass, annotation, null)) continue;
            filteredAnnotations.add(annotation);
        }
        return filteredAnnotations.toArray(new Annotation[0]);
    }

    private void registerStrings(Annotation ... annotations) {
        for (Annotation annotation : annotations) {
            ArrayList<String> stringValues = new ArrayList<String>();
            if (!this.supportedValue(annotation.annotationType(), annotation, stringValues)) continue;
            for (String stringValue : stringValues) {
                this.encoders.sourceMethodNames.addObject((Object)stringValue);
            }
        }
    }

    private boolean supportedValue(Class<?> type, Object value, List<String> stringValues) {
        if (type.isAnnotation()) {
            Annotation annotation = (Annotation)value;
            if (!this.encoders.sourceClasses.contains(annotation.annotationType())) {
                return false;
            }
            AnnotationType annotationType = AnnotationType.getInstance(type);
            for (Map.Entry<String, Class<?>> entry : annotationType.memberTypes().entrySet()) {
                String valueName = entry.getKey();
                Class<?> valueType = entry.getValue();
                try {
                    Method getAnnotationValue = annotationType.members().get(valueName);
                    getAnnotationValue.setAccessible(true);
                    Object annotationValue = getAnnotationValue.invoke((Object)annotation, new Object[0]);
                    if (this.supportedValue(valueType, annotationValue, stringValues)) continue;
                    return false;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    return false;
                }
            }
        } else {
            if (type.isArray()) {
                boolean supported = true;
                Class<?> componentType = type.getComponentType();
                if (!componentType.isPrimitive()) {
                    for (Object val : (Object[])value) {
                        supported &= this.supportedValue(componentType, val, stringValues);
                    }
                }
                return supported;
            }
            if (type == Class.class) {
                return this.encoders.sourceClasses.contains((Object)((Class)value));
            }
            if (type == String.class) {
                if (stringValues != null) {
                    stringValues.add((String)value);
                }
            } else if (type.isEnum()) {
                if (stringValues != null) {
                    stringValues.add(((Enum)value).name());
                }
                return this.encoders.sourceClasses.contains(type);
            }
        }
        return true;
    }

    byte[] encodeTypeAnnotations(TypeAnnotation[] annotations) throws InvocationTargetException, IllegalAccessException {
        UnsafeArrayTypeWriter buf = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        buf.putU2((long)annotations.length);
        for (TypeAnnotation typeAnnotation : annotations) {
            this.encodeTypeAnnotation(buf, typeAnnotation);
        }
        return buf.toArray();
    }

    void encodeTypeAnnotation(UnsafeArrayTypeWriter buf, TypeAnnotation typeAnnotation) throws InvocationTargetException, IllegalAccessException {
        this.encodeTargetInfo(buf, typeAnnotation.getTargetInfo());
        this.encodeLocationInfo(buf, typeAnnotation.getLocationInfo());
        this.encodeAnnotation(buf, typeAnnotation.getAnnotation());
    }

    void encodeTargetInfo(UnsafeArrayTypeWriter buf, TypeAnnotation.TypeAnnotationTargetInfo targetInfo) {
        switch (targetInfo.getTarget()) {
            case CLASS_TYPE_PARAMETER: {
                buf.putU1(0L);
                buf.putU1((long)targetInfo.getCount());
                break;
            }
            case METHOD_TYPE_PARAMETER: {
                buf.putU1(1L);
                buf.putU1((long)targetInfo.getCount());
                break;
            }
            case CLASS_EXTENDS: {
                buf.putU1(16L);
                buf.putS2(-1L);
                break;
            }
            case CLASS_IMPLEMENTS: {
                buf.putU1(16L);
                buf.putS2((long)targetInfo.getCount());
                break;
            }
            case CLASS_TYPE_PARAMETER_BOUND: {
                buf.putU1(17L);
                buf.putU1((long)targetInfo.getCount());
                buf.putU1((long)targetInfo.getSecondaryIndex());
                break;
            }
            case METHOD_TYPE_PARAMETER_BOUND: {
                buf.putU1(18L);
                buf.putU1((long)targetInfo.getCount());
                buf.putU1((long)targetInfo.getSecondaryIndex());
                break;
            }
            case FIELD: {
                buf.putU1(19L);
                break;
            }
            case METHOD_RETURN: {
                buf.putU1(20L);
                break;
            }
            case METHOD_RECEIVER: {
                buf.putU1(21L);
                break;
            }
            case METHOD_FORMAL_PARAMETER: {
                buf.putU1(22L);
                buf.putU1((long)targetInfo.getCount());
                break;
            }
            case THROWS: {
                buf.putU1(23L);
                buf.putU2((long)targetInfo.getCount());
            }
        }
    }

    void encodeLocationInfo(UnsafeArrayTypeWriter buf, TypeAnnotation.LocationInfo locationInfo) throws IllegalAccessException {
        TypeAnnotation.LocationInfo.Location[] locations;
        int depth = (Integer)locationInfoDepth.get(locationInfo);
        buf.putU1((long)depth);
        for (TypeAnnotation.LocationInfo.Location location : locations = (TypeAnnotation.LocationInfo.Location[])locationInfoLocations.get(locationInfo)) {
            buf.putS1((long)location.tag);
            buf.putU1((long)location.index);
        }
    }
}

