/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.deopt;

import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalLong;
import com.oracle.svm.core.util.Counter;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.options.Option;
import org.graalvm.nativeimage.ImageSingletons;

public class DeoptimizationCounters {
    private Counter.Group deoptCounters = new Counter.Group(Options.ProfileDeoptimization, "Deoptimization counters");
    Counter deoptCount = new Counter(this.deoptCounters, "Number of deoptimizations", "Number of deoptimizations that happened during the execution");
    Counter virtualFrameCount = new Counter(this.deoptCounters, "Number of virtual frames", "Number of virtual frames copied");
    Counter stackValueCount = new Counter(this.deoptCounters, "Number of stack values", "Number of target values on the stack");
    Counter constantValueCount = new Counter(this.deoptCounters, "Number of constant values", "Number of target values that are constant");
    Counter virtualObjectsCount = new Counter(this.deoptCounters, "Number of virtual objects", "Number of virtual objects re-allocated");
    Counter timeSpentInDeopt = new Counter(this.deoptCounters, "Time spent in deoptimization", "Time (ns) spend in deoptimization");
    static final FastThreadLocalLong startTime = FastThreadLocalFactory.createLong();

    @Fold
    public static DeoptimizationCounters counters() {
        return (DeoptimizationCounters)ImageSingletons.lookup(DeoptimizationCounters.class);
    }

    public static class Options {
        @Option(help={"Print logging information during object file writing"})
        static final HostedOptionKey<Boolean> ProfileDeoptimization = new HostedOptionKey<Boolean>(false);
    }
}

