/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.thread.VMOperation;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;

public final class HeapAccounting {
    private final UninterruptibleUtils.AtomicUnsigned edenUsedBytes = new UninterruptibleUtils.AtomicUnsigned();
    private final UninterruptibleUtils.AtomicUnsigned youngUsedBytes = new UninterruptibleUtils.AtomicUnsigned();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    HeapAccounting() {
    }

    public void setEdenAndYoungGenBytes(UnsignedWord edenBytes, UnsignedWord youngBytes) {
        assert (VMOperation.isGCInProgress()) : "would cause races otherwise";
        this.youngUsedBytes.set(youngBytes);
        this.edenUsedBytes.set(edenBytes);
    }

    @Uninterruptible(reason="Must be done during TLAB registration to not race with a potential collection.", callerMustBe=true)
    public void increaseEdenUsedBytes(UnsignedWord value) {
        this.youngUsedBytes.addAndGet(value);
        this.edenUsedBytes.addAndGet(value);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord getYoungUsedBytes() {
        assert (!VMOperation.isGCInProgress()) : "value is incorrect during a GC";
        return (UnsignedWord)this.youngUsedBytes.get();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord getEdenUsedBytes() {
        assert (!VMOperation.isGCInProgress()) : "value is incorrect during a GC";
        return (UnsignedWord)this.edenUsedBytes.get();
    }

    public UnsignedWord getSurvivorSpaceAfterChunkBytes(int survivorIndex) {
        return HeapImpl.getHeapImpl().getYoungGeneration().getSurvivorFromSpaceAt(survivorIndex).getChunkBytes();
    }
}

