/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.Target_java_lang_ref_Reference;
import com.oracle.svm.core.heap.Target_java_lang_ref_ReferenceQueue;
import com.oracle.svm.core.heap.Target_java_lang_ref_SoftReference;
import com.oracle.svm.core.heap.Target_jdk_internal_ref_Cleaner;
import com.oracle.svm.core.util.TimeUtils;
import com.oracle.svm.core.util.VMError;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.word.BarrieredAccess;
import org.graalvm.compiler.word.ObjectAccess;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class ReferenceInternals {
    public static final String REFERENT_FIELD_NAME = "referent";
    private static final Object processPendingLock = new Object();
    private static boolean processPendingActive = false;

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static <T> Target_java_lang_ref_Reference<T> cast(Reference<T> instance) {
        return SubstrateUtil.cast(instance, Target_java_lang_ref_Reference.class);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static <T> Reference<T> uncast(Target_java_lang_ref_Reference<T> instance) {
        return SubstrateUtil.cast(instance, Reference.class);
    }

    public static <T> Pointer getReferentPointer(Reference<T> instance) {
        return Word.objectToUntrackedPointer((Object)ObjectAccess.readObject(instance, (WordBase)WordFactory.signed((long)Target_java_lang_ref_Reference.referentFieldOffset)));
    }

    public static <T> T getReferent(Reference<T> instance) {
        return SubstrateUtil.cast(instance, Target_java_lang_ref_Reference.class).referent;
    }

    public static void setReferent(Reference<?> instance, Object value) {
        BarrieredAccess.writeObject(instance, (WordBase)WordFactory.signed((long)Target_java_lang_ref_Reference.referentFieldOffset), (Object)value);
    }

    @Uninterruptible(reason="Must be atomic with regard to garbage collection.")
    public static boolean refersTo(Reference<?> instance, Object value) {
        return value == ObjectAccess.readObject(instance, (WordBase)WordFactory.signed((long)Target_java_lang_ref_Reference.referentFieldOffset));
    }

    public static void clear(Reference<?> instance) {
        ObjectAccess.writeObject(instance, (WordBase)WordFactory.signed((long)Target_java_lang_ref_Reference.referentFieldOffset), null);
    }

    public static <T> Pointer getReferentFieldAddress(Reference<T> instance) {
        return Word.objectToUntrackedPointer(instance).add((Word)WordFactory.unsigned((long)Target_java_lang_ref_Reference.referentFieldOffset));
    }

    public static long getReferentFieldOffset() {
        return Target_java_lang_ref_Reference.referentFieldOffset;
    }

    public static <T> Reference<?> getNextDiscovered(Reference<T> instance) {
        return ReferenceInternals.uncast(ReferenceInternals.cast(instance).discovered);
    }

    public static <T> Pointer getDiscoveredPointer(Reference<T> instance) {
        return Word.objectToUntrackedPointer((Object)ObjectAccess.readObject(instance, (WordBase)WordFactory.signed((long)Target_java_lang_ref_Reference.discoveredFieldOffset)));
    }

    public static long getNextDiscoveredFieldOffset() {
        return Target_java_lang_ref_Reference.discoveredFieldOffset;
    }

    public static <T> void setNextDiscovered(Reference<T> instance, Reference<?> newNext) {
        BarrieredAccess.writeObject(instance, (WordBase)WordFactory.signed((long)Target_java_lang_ref_Reference.discoveredFieldOffset), newNext);
    }

    public static boolean hasQueue(Reference<?> instance) {
        return ReferenceInternals.cast(instance).queue != Target_java_lang_ref_ReferenceQueue.NULL;
    }

    public static void waitForPendingReferences() throws InterruptedException {
        Heap.getHeap().waitForReferencePendingList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"}, justification="Notifies on progress, not a specific state change.")
    public static void processPendingReferences() {
        Target_java_lang_ref_Reference<?> pendingList;
        Object object = processPendingLock;
        synchronized (object) {
            if (processPendingActive) {
                return;
            }
            pendingList = ReferenceInternals.cast(Heap.getHeap().getAndClearReferencePendingList());
            if (pendingList == null) {
                return;
            }
            processPendingActive = true;
        }
        block11: while (true) {
            try {
                while (pendingList != null) {
                    Target_java_lang_ref_Reference<?> ref = pendingList;
                    pendingList = ref.discovered;
                    ref.discovered = null;
                    if (Target_jdk_internal_ref_Cleaner.class.isInstance(ref)) {
                        Target_jdk_internal_ref_Cleaner cleaner = (Target_jdk_internal_ref_Cleaner)Target_jdk_internal_ref_Cleaner.class.cast(ref);
                        cleaner.clean();
                        Object object2 = processPendingLock;
                        synchronized (object2) {
                            processPendingLock.notifyAll();
                            continue block11;
                        }
                    }
                    Target_java_lang_ref_ReferenceQueue queue = SubstrateUtil.cast(ref.queue, Target_java_lang_ref_ReferenceQueue.class);
                    if (queue == Target_java_lang_ref_ReferenceQueue.NULL) continue;
                    queue.enqueue(ref);
                }
            }
            catch (Throwable t) {
                VMError.shouldNotReachHere("ReferenceQueue and Cleaner must handle all potential exceptions", t);
            }
            object = processPendingLock;
            synchronized (object) {
                pendingList = ReferenceInternals.cast(Heap.getHeap().getAndClearReferencePendingList());
                if (pendingList == null) {
                    processPendingActive = false;
                }
                processPendingLock.notifyAll();
            }
            if (pendingList == null) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"WA_NOT_IN_LOOP"}, justification="Wait for progress, not necessarily completion.")
    public static boolean waitForReferenceProcessing() throws InterruptedException {
        Object object = processPendingLock;
        synchronized (object) {
            if (processPendingActive || Heap.getHeap().hasReferencePendingList()) {
                processPendingLock.wait();
                return true;
            }
            return false;
        }
    }

    public static long getSoftReferenceClock() {
        return Target_java_lang_ref_SoftReference.clock;
    }

    public static void updateSoftReferenceClock() {
        long now = TimeUtils.divideNanosToMillis(System.nanoTime());
        if (BranchProbabilityNode.probability((double)0.999999, (now >= Target_java_lang_ref_SoftReference.clock ? 1 : 0) != 0)) {
            Target_java_lang_ref_SoftReference.clock = now;
        }
    }

    public static long getSoftReferenceTimestamp(SoftReference<?> instance) {
        Target_java_lang_ref_SoftReference ref = SubstrateUtil.cast(instance, Target_java_lang_ref_SoftReference.class);
        return ref.timestamp;
    }

    public static ResolvedJavaType getReferenceType(MetaAccessProvider metaAccess) {
        return metaAccess.lookupJavaType(Reference.class);
    }

    public static ResolvedJavaField getReferentField(MetaAccessProvider metaAccess) {
        return ReferenceInternals.getField(ReferenceInternals.getReferenceType(metaAccess), REFERENT_FIELD_NAME);
    }

    private static ResolvedJavaField getField(ResolvedJavaType type, String fieldName) {
        for (ResolvedJavaField field : type.getInstanceFields(true)) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        throw new GraalError("missing field " + fieldName + " in type " + type);
    }

    private ReferenceInternals() {
    }
}

