/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.CalleeSavedRegisters;
import com.oracle.svm.core.heap.SubstrateReferenceMap;
import com.oracle.svm.core.util.VMError;
import jdk.vm.ci.code.ReferenceMap;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.framemap.ReferenceMapBuilder;

public class SubstrateReferenceMapBuilder
extends ReferenceMapBuilder {
    private final int totalFrameSize;
    private final SubstrateReferenceMap referenceMap;

    public SubstrateReferenceMapBuilder(int totalFrameSize) {
        this.totalFrameSize = totalFrameSize;
        this.referenceMap = new SubstrateReferenceMap();
    }

    public void addLiveValue(Value value) {
        int offset = 0;
        boolean offsetValid = false;
        if (ValueUtil.isStackSlot((Value)value)) {
            StackSlot stackSlot = ValueUtil.asStackSlot((Value)value);
            offset = stackSlot.getOffset(this.totalFrameSize);
            offsetValid = true;
            assert (this.referenceMap.debugMarkStackSlot(offset, stackSlot));
        } else if (ValueUtil.isRegister((Value)value)) {
            Register register = ValueUtil.asRegister((Value)value);
            assert (this.referenceMap.debugMarkRegister(ValueUtil.asRegister((Value)value).number, value));
            if (CalleeSavedRegisters.supportedByPlatform()) {
                offset = CalleeSavedRegisters.singleton().getOffsetInFrame(register);
                offsetValid = true;
            }
        } else {
            throw VMError.shouldNotReachHere(value.toString());
        }
        LIRKind kind = (LIRKind)value.getValueKind();
        if (offsetValid && !kind.isValue()) {
            if (kind.isUnknownReference()) {
                throw JVMCIError.shouldNotReachHere((String)"unknown reference alive across safepoint");
            }
            if (kind.isDerivedReference()) {
                throw JVMCIError.shouldNotReachHere((String)"derived references not supported yet on Substrate VM");
            }
            int bytes = SubstrateReferenceMapBuilder.bytesPerElement(kind);
            for (int i = 0; i < kind.getPlatformKind().getVectorLength(); ++i) {
                if (!kind.isReference(i)) continue;
                boolean compressed = kind.isCompressedReference(i);
                this.referenceMap.markReferenceAtOffset(offset + i * bytes, compressed);
            }
        }
    }

    private static int bytesPerElement(LIRKind kind) {
        PlatformKind platformKind = kind.getPlatformKind();
        return platformKind.getSizeInBytes() / platformKind.getVectorLength();
    }

    public ReferenceMap finish(LIRFrameState state) {
        return this.referenceMap;
    }
}

