/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.jni.JNIRuntimeAccess;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport;

public class JNIRegistrationUtil {
    private static Set<Consumer<Feature.DuringAnalysisAccess>> runOnceCallbacks = Collections.newSetFromMap(new IdentityHashMap());

    protected static boolean isPosix() {
        return Platform.includedIn(Platform.LINUX.class) || Platform.includedIn(Platform.DARWIN.class);
    }

    protected static boolean isLinux() {
        return Platform.includedIn(Platform.LINUX.class);
    }

    protected static boolean isDarwin() {
        return Platform.includedIn(Platform.DARWIN.class);
    }

    protected static boolean isWindows() {
        return Platform.includedIn(Platform.WINDOWS.class);
    }

    protected static void rerunClassInit(Feature.FeatureAccess access, String ... classNames) {
        RuntimeClassInitializationSupport classInitSupport = (RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class);
        for (String className : classNames) {
            classInitSupport.rerunInitialization(JNIRegistrationUtil.clazz(access, className), "for JDK native code support via JNI");
        }
    }

    protected static Class<?> clazz(Feature.FeatureAccess access, String className) {
        Class classByName = access.findClassByName(className);
        VMError.guarantee(classByName != null, "class " + className + " not found");
        return classByName;
    }

    protected static Optional<Class<?>> optionalClazz(Feature.FeatureAccess access, String className) {
        Class classByName = access.findClassByName(className);
        return Optional.ofNullable(classByName);
    }

    protected static Optional<Method> optionalMethod(Feature.FeatureAccess access, String className, String methodName, Class<?> ... parameterTypes) {
        return Optional.ofNullable(ReflectionUtil.lookupMethod((boolean)true, JNIRegistrationUtil.clazz(access, className), (String)methodName, (Class[])parameterTypes));
    }

    protected static Method method(Feature.FeatureAccess access, String className, String methodName, Class<?> ... parameterTypes) {
        return ReflectionUtil.lookupMethod(JNIRegistrationUtil.clazz(access, className), (String)methodName, (Class[])parameterTypes);
    }

    protected static Constructor<?> constructor(Feature.FeatureAccess access, String className, Class<?> ... parameterTypes) {
        return ReflectionUtil.lookupConstructor(JNIRegistrationUtil.clazz(access, className), (Class[])parameterTypes);
    }

    protected static Field[] fields(Feature.FeatureAccess access, String className, String ... fieldNames) {
        Class<?> clazz = JNIRegistrationUtil.clazz(access, className);
        Field[] result = new Field[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            result[i] = ReflectionUtil.lookupField(clazz, (String)fieldNames[i]);
        }
        return result;
    }

    protected static void registerForThrowNew(Feature.FeatureAccess access, String ... exceptionClassNames) {
        for (String exceptionClassName : exceptionClassNames) {
            JNIRuntimeAccess.register(JNIRegistrationUtil.clazz(access, exceptionClassName));
            JNIRuntimeAccess.register(JNIRegistrationUtil.constructor(access, exceptionClassName, String.class));
        }
    }

    protected static boolean isRunOnce(Consumer<Feature.DuringAnalysisAccess> callback) {
        return !runOnceCallbacks.add(callback);
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        runOnceCallbacks.clear();
    }
}

