/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.management;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.util.VMError;
import com.sun.management.ThreadMXBean;
import java.lang.management.ThreadInfo;
import javax.management.ObjectName;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import sun.management.Util;

final class SubstrateThreadMXBean
implements ThreadMXBean {
    private static final String MSG = "ThreadMXBean methods";
    private final UninterruptibleUtils.AtomicLong totalStartedThreadCount = new UninterruptibleUtils.AtomicLong(0L);
    private final UninterruptibleUtils.AtomicInteger peakThreadCount = new UninterruptibleUtils.AtomicInteger(0);
    private final UninterruptibleUtils.AtomicInteger threadCount = new UninterruptibleUtils.AtomicInteger(0);
    private final UninterruptibleUtils.AtomicInteger daemonThreadCount = new UninterruptibleUtils.AtomicInteger(0);

    @Platforms(value={Platform.HOSTED_ONLY.class})
    SubstrateThreadMXBean() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void noteThreadStart(Thread thread) {
        this.totalStartedThreadCount.incrementAndGet();
        int curThreadCount = this.threadCount.incrementAndGet();
        this.updatePeakThreadCount(curThreadCount);
        if (thread.isDaemon()) {
            this.daemonThreadCount.incrementAndGet();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void updatePeakThreadCount(int curThreadCount) {
        int oldPeak;
        while (curThreadCount > (oldPeak = this.peakThreadCount.get()) && !this.peakThreadCount.compareAndSet(oldPeak, curThreadCount)) {
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void noteThreadFinish(Thread thread) {
        this.threadCount.decrementAndGet();
        if (thread.isDaemon()) {
            this.daemonThreadCount.decrementAndGet();
        }
    }

    @Override
    public ObjectName getObjectName() {
        return Util.newObjectName("java.lang:type=Threading");
    }

    @Override
    public boolean isThreadAllocatedMemoryEnabled() {
        return false;
    }

    @Override
    public boolean isThreadAllocatedMemorySupported() {
        return false;
    }

    @Override
    public boolean isThreadCpuTimeSupported() {
        return false;
    }

    @Override
    public boolean isCurrentThreadCpuTimeSupported() {
        return false;
    }

    @Override
    public int getThreadCount() {
        return this.threadCount.get();
    }

    @Override
    public int getPeakThreadCount() {
        return this.peakThreadCount.get();
    }

    @Override
    public void resetPeakThreadCount() {
        this.peakThreadCount.set(this.threadCount.get());
    }

    @Override
    public long getTotalStartedThreadCount() {
        return this.totalStartedThreadCount.get();
    }

    @Override
    public int getDaemonThreadCount() {
        return this.daemonThreadCount.get();
    }

    @Override
    public long[] getAllThreadIds() {
        throw VMError.unsupportedFeature(MSG);
    }

    @Override
    public ThreadInfo getThreadInfo(long id) {
        throw VMError.unsupportedFeature(MSG);
    }

    @Override
    public ThreadInfo[] getThreadInfo(long[] ids) {
        throw VMError.unsupportedFeature(MSG);
    }

    @Override
    public ThreadInfo getThreadInfo(long id, int maxDepth) {
        throw VMError.unsupportedFeature(MSG);
    }

    @Override
    public ThreadInfo[] getThreadInfo(long[] ids, int maxDepth) {
        throw VMError.unsupportedFeature(MSG);
    }

    @Override
    public boolean isThreadContentionMonitoringSupported() {
        return false;
    }

    @Override
    public boolean isThreadContentionMonitoringEnabled() {
        return false;
    }

    @Override
    public void setThreadContentionMonitoringEnabled(boolean enable) {
    }

    @Override
    public long getCurrentThreadCpuTime() {
        throw VMError.unsupportedFeature(MSG);
    }

    @Override
    public long getCurrentThreadUserTime() {
        throw VMError.unsupportedFeature(MSG);
    }

    @Override
    public long getThreadCpuTime(long id) {
        throw VMError.unsupportedFeature(MSG);
    }

    @Override
    public long getThreadUserTime(long id) {
        throw VMError.unsupportedFeature(MSG);
    }

    @Override
    public boolean isThreadCpuTimeEnabled() {
        throw VMError.unsupportedFeature(MSG);
    }

    @Override
    public void setThreadCpuTimeEnabled(boolean enable) {
        throw VMError.unsupportedFeature(MSG);
    }

    @Override
    public long[] findMonitorDeadlockedThreads() {
        throw VMError.unsupportedFeature(MSG);
    }

    @Override
    public long[] findDeadlockedThreads() {
        throw VMError.unsupportedFeature(MSG);
    }

    @Override
    public boolean isObjectMonitorUsageSupported() {
        throw VMError.unsupportedFeature(MSG);
    }

    @Override
    public boolean isSynchronizerUsageSupported() {
        throw VMError.unsupportedFeature(MSG);
    }

    @Override
    public ThreadInfo[] getThreadInfo(long[] ids, boolean lockedMonitors, boolean lockedSynchronizers) {
        throw VMError.unsupportedFeature(MSG);
    }

    @Override
    public ThreadInfo[] dumpAllThreads(boolean lockedMonitors, boolean lockedSynchronizers) {
        throw VMError.unsupportedFeature(MSG);
    }

    @Override
    public long getThreadAllocatedBytes(long arg0) {
        throw VMError.unsupportedFeature(MSG);
    }

    @Override
    public long[] getThreadAllocatedBytes(long[] arg0) {
        throw VMError.unsupportedFeature(MSG);
    }

    @Override
    public long[] getThreadCpuTime(long[] arg0) {
        throw VMError.unsupportedFeature(MSG);
    }

    @Override
    public long[] getThreadUserTime(long[] arg0) {
        throw VMError.unsupportedFeature(MSG);
    }

    @Override
    public void setThreadAllocatedMemoryEnabled(boolean arg0) {
        throw VMError.unsupportedFeature(MSG);
    }
}

