/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.linux;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.posix.headers.Time;
import com.oracle.svm.core.posix.headers.linux.LinuxTime;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.word.WordFactory;

@TargetClass(value=System.class)
final class Target_java_lang_System_Linux {
    Target_java_lang_System_Linux() {
    }

    @Substitute
    @Uninterruptible(reason="Does basic math after a simple system call")
    private static long nanoTime() {
        Time.timespec timespec2 = (Time.timespec)StackValue.get(Time.timespec.class);
        if (LinuxTime.clock_gettime(LinuxTime.CLOCK_MONOTONIC(), timespec2) == 0) {
            return timespec2.tv_sec() * 1000000000L + timespec2.tv_nsec();
        }
        Time.timeval timeval2 = (Time.timeval)StackValue.get(Time.timeval.class);
        Time.timezone timezone2 = (Time.timezone)WordFactory.nullPointer();
        Time.NoTransitions.gettimeofday(timeval2, timezone2);
        return timeval2.tv_sec() * 1000000000L + timeval2.tv_usec() * 1000L;
    }

    @Substitute
    public static String mapLibraryName(String libname) {
        return "lib" + libname + ".so";
    }
}

