/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.reflect;

import com.oracle.svm.core.annotate.InvokeJavaFunctionPointer;
import com.oracle.svm.core.jdk.InternalVMMethod;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Executable;
import org.graalvm.nativeimage.c.function.CFunctionPointer;

@InternalVMMethod
public abstract class SubstrateConstructorAccessor {
    private final Executable member;
    private final CFunctionPointer newInstanceFunctionPointer;

    protected SubstrateConstructorAccessor(Executable member, CFunctionPointer newInstanceFunctionPointer) {
        this.member = member;
        this.newInstanceFunctionPointer = newInstanceFunctionPointer;
    }

    public Object newInstance(Object[] args) {
        ConstructorNewInstanceFunctionPointer functionPointer = (ConstructorNewInstanceFunctionPointer)this.newInstanceFunctionPointer;
        if (functionPointer.isNull()) {
            throw this.newInstanceError();
        }
        return functionPointer.invoke(args);
    }

    private RuntimeException newInstanceError() {
        throw VMError.shouldNotReachHere("No SubstrateConstructorAccessor.newInstanceFunctionPointer for " + this.member);
    }

    static interface ConstructorNewInstanceFunctionPointer
    extends CFunctionPointer {
        @InvokeJavaFunctionPointer
        public Object invoke(Object[] var1);
    }
}

