/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.ReachableThreadGroup;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.util.ClassUtil;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
@Platforms(value={Platform.HOSTED_ONLY.class})
class JavaThreadsFeature
implements Feature {
    final Map<Thread, Boolean> reachableThreads = Collections.synchronizedMap(new IdentityHashMap());
    final Map<ThreadGroup, ReachableThreadGroup> reachableThreadGroups = Collections.synchronizedMap(new IdentityHashMap());
    private boolean sealed;
    private static final String AUTONUMBER_PREFIX = "Thread-";

    JavaThreadsFeature() {
    }

    static JavaThreadsFeature singleton() {
        return (JavaThreadsFeature)ImageSingletons.lookup(JavaThreadsFeature.class);
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        access.registerObjectReplacer(this::collectReachableObjects);
    }

    private Object collectReachableObjects(Object original) {
        ThreadGroup group;
        if (original instanceof Thread) {
            Thread thread = (Thread)original;
            if (thread.getState() == Thread.State.NEW) {
                this.registerReachableObject(this.reachableThreads, thread, Boolean.TRUE);
            }
        } else if (original instanceof ThreadGroup && this.registerReachableObject(this.reachableThreadGroups, group = (ThreadGroup)original, new ReachableThreadGroup())) {
            ThreadGroup parent = group.getParent();
            if (parent != null) {
                this.collectReachableObjects(parent);
                this.reachableThreadGroups.get(parent).add(group);
            } else assert (group == JavaThreads.singleton().systemGroup);
        }
        return original;
    }

    private <K, V> boolean registerReachableObject(Map<K, V> map, K object, V value) {
        boolean result;
        boolean bl = result = map.putIfAbsent(object, value) == null;
        if (this.sealed && result) {
            throw UserError.abort("%s is reachable in the image heap but was not seen during the points-to analysis: %s", ClassUtil.getUnqualifiedName(object.getClass()), object);
        }
        return result;
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.sealed = true;
        long maxThreadId = 0L;
        int maxAutonumber = -1;
        for (Thread thread : this.reachableThreads.keySet()) {
            maxThreadId = Math.max(maxThreadId, JavaThreadsFeature.threadId(thread));
            maxAutonumber = Math.max(maxAutonumber, JavaThreadsFeature.autonumberOf(thread));
        }
        assert (maxThreadId >= 1L) : "main thread with id 1 must always be found";
        JavaThreads.singleton().threadSeqNumber.set(maxThreadId);
        JavaThreads.singleton().threadInitNumber.set(maxAutonumber);
    }

    static long threadId(Thread thread) {
        return thread == JavaThreads.singleton().mainThread ? 1L : thread.getId();
    }

    static int autonumberOf(Thread thread) {
        if (thread.getName().startsWith(AUTONUMBER_PREFIX)) {
            try {
                return Integer.parseInt(thread.getName().substring(AUTONUMBER_PREFIX.length()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }
}

