/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public class ReachabilityHandlerFeature
implements Feature {
    private final IdentityHashMap<Object, Set<Object>> activeHandlers = new IdentityHashMap();
    private final IdentityHashMap<Object, Map<Object, Set<Object>>> triggeredHandlers = new IdentityHashMap();

    public static ReachabilityHandlerFeature singleton() {
        return (ReachabilityHandlerFeature)ImageSingletons.lookup(ReachabilityHandlerFeature.class);
    }

    public void registerMethodOverrideReachabilityHandler(FeatureImpl.BeforeAnalysisAccessImpl a, BiConsumer<Feature.DuringAnalysisAccess, Executable> callback, Executable baseMethod) {
        this.registerReachabilityHandler(a, callback, new Executable[]{baseMethod}, false);
    }

    public void registerSubtypeReachabilityHandler(Feature.BeforeAnalysisAccess a, BiConsumer<Feature.DuringAnalysisAccess, Class<?>> callback, Class<?> baseClass) {
        this.registerReachabilityHandler(a, callback, new Class[]{baseClass}, false);
    }

    public void registerClassInitializerReachabilityHandler(Feature.BeforeAnalysisAccess a, Consumer<Feature.DuringAnalysisAccess> callback, Class<?> clazz) {
        this.registerReachabilityHandler(a, callback, new Class[]{clazz}, true);
    }

    public void registerReachabilityHandler(Feature.BeforeAnalysisAccess a, Consumer<Feature.DuringAnalysisAccess> callback, Object[] triggers) {
        this.registerReachabilityHandler(a, callback, triggers, false);
    }

    private void registerReachabilityHandler(Feature.BeforeAnalysisAccess a, Object callback, Object[] triggers, boolean triggerOnClassInitializer) {
        if (this.triggeredHandlers.containsKey(callback)) {
            return;
        }
        FeatureImpl.BeforeAnalysisAccessImpl access = (FeatureImpl.BeforeAnalysisAccessImpl)a;
        AnalysisMetaAccess metaAccess = access.getMetaAccess();
        Set triggerSet = this.activeHandlers.computeIfAbsent(callback, c -> new HashSet());
        for (Object trigger : triggers) {
            if (trigger instanceof Class) {
                AnalysisType aType = metaAccess.lookupJavaType((Class)trigger);
                triggerSet.add(triggerOnClassInitializer ? aType.getClassInitializer() : aType);
                continue;
            }
            if (trigger instanceof Field) {
                triggerSet.add(metaAccess.lookupJavaField((Field)trigger));
                continue;
            }
            if (trigger instanceof Executable) {
                triggerSet.add(metaAccess.lookupJavaMethod((Executable)trigger));
                continue;
            }
            throw UserError.abort("registerReachabilityHandler called with an element that is not a Class, Field, Method, or Constructor: %s", trigger.getClass().getTypeName());
        }
        if (access instanceof Feature.DuringAnalysisAccess) {
            ((Feature.DuringAnalysisAccess)access).requireAnalysisIteration();
        }
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess a) {
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        HashSet<Object> handledCallbacks = new HashSet<Object>();
        HashSet<Object> callbacks = new HashSet<Object>(this.activeHandlers.keySet());
        do {
            ArrayList<Object> completedCallbacks = new ArrayList<Object>();
            for (Object callback : callbacks) {
                Set<Object> triggers = this.activeHandlers.get(callback);
                if (callback instanceof Consumer) {
                    if (ReachabilityHandlerFeature.isTriggered(access, triggers)) {
                        this.triggeredHandlers.put(callback, null);
                        ReachabilityHandlerFeature.toExactCallback(callback).accept(access);
                        completedCallbacks.add(callback);
                    }
                } else {
                    VMError.guarantee(callback instanceof BiConsumer);
                    this.processReachable(access, callback, triggers);
                }
                handledCallbacks.add(callback);
            }
            for (Object completed : completedCallbacks) {
                this.activeHandlers.remove(completed);
                handledCallbacks.remove(completed);
            }
            callbacks = new HashSet<Object>(this.activeHandlers.keySet());
            callbacks.removeAll(handledCallbacks);
        } while (!callbacks.isEmpty());
    }

    private static boolean isTriggered(FeatureImpl.DuringAnalysisAccessImpl access, Set<Object> triggers) {
        for (Object trigger : triggers) {
            if (trigger instanceof AnalysisType) {
                if (!access.isReachable((AnalysisType)trigger)) continue;
                return true;
            }
            if (trigger instanceof AnalysisField) {
                if (!access.isReachable((AnalysisField)trigger)) continue;
                return true;
            }
            if (trigger instanceof AnalysisMethod) {
                AnalysisMethod triggerMethod = (AnalysisMethod)trigger;
                if (access.isReachable(triggerMethod)) {
                    return true;
                }
                if (!triggerMethod.isClassInitializer() || !triggerMethod.getDeclaringClass().isInitialized()) continue;
                return true;
            }
            throw VMError.shouldNotReachHere("Unexpected trigger: " + trigger.getClass().getTypeName());
        }
        return false;
    }

    private static Consumer<Feature.DuringAnalysisAccess> toExactCallback(Object callback) {
        return (Consumer)callback;
    }

    private void processReachable(FeatureImpl.DuringAnalysisAccessImpl access, Object callback, Set<Object> triggers) {
        Map handledTriggers = this.triggeredHandlers.computeIfAbsent(callback, c -> new IdentityHashMap());
        for (Object trigger : triggers) {
            Set prevReachable;
            Set<AnalysisType> newReachable;
            if (trigger instanceof AnalysisType) {
                newReachable = access.reachableSubtypes((AnalysisType)trigger);
                prevReachable = handledTriggers.computeIfAbsent(trigger, c -> new HashSet());
                newReachable.removeAll(prevReachable);
                for (AnalysisType reachable : newReachable) {
                    ReachabilityHandlerFeature.toSubtypeCallback(callback).accept(access, reachable.getJavaClass());
                    prevReachable.add(reachable);
                }
                continue;
            }
            if (trigger instanceof AnalysisMethod) {
                newReachable = access.reachableMethodOverrides((AnalysisMethod)trigger);
                prevReachable = handledTriggers.computeIfAbsent(trigger, c -> new HashSet());
                newReachable.removeAll(prevReachable);
                for (AnalysisType reachable : newReachable) {
                    ReachabilityHandlerFeature.toOverrideCallback(callback).accept(access, reachable.getJavaMethod());
                    prevReachable.add(reachable);
                }
                continue;
            }
            throw VMError.shouldNotReachHere("Unexpected subtype/override trigger: " + trigger.getClass().getTypeName());
        }
    }

    private static BiConsumer<Feature.DuringAnalysisAccess, Class<?>> toSubtypeCallback(Object callback) {
        return (BiConsumer)callback;
    }

    private static BiConsumer<Feature.DuringAnalysisAccess, Executable> toOverrideCallback(Object callback) {
        return (BiConsumer)callback;
    }
}

