/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.agent.jdk8.lambda;

import com.oracle.svm.hosted.agent.jdk8.lambda.AbstractValidatingLambdaMetafactory;
import com.oracle.svm.hosted.agent.jdk8.lambda.InnerClassLambdaMetafactory;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaConversionException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;

public class LambdaMetafactory {
    public static final int FLAG_SERIALIZABLE = 1;
    public static final int FLAG_MARKERS = 2;
    public static final int FLAG_BRIDGES = 4;
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final MethodType[] EMPTY_MT_ARRAY = new MethodType[0];

    public static CallSite metafactory(MethodHandles.Lookup caller, String invokedName, MethodType invokedType, MethodType samMethodType, MethodHandle implMethod, MethodType instantiatedMethodType) throws LambdaConversionException {
        InnerClassLambdaMetafactory mf = new InnerClassLambdaMetafactory(caller, invokedType, invokedName, samMethodType, implMethod, instantiatedMethodType, false, EMPTY_CLASS_ARRAY, EMPTY_MT_ARRAY);
        mf.validateMetafactoryArgs();
        return ((AbstractValidatingLambdaMetafactory)mf).buildCallSite();
    }

    public static CallSite altMetafactory(MethodHandles.Lookup caller, String invokedName, MethodType invokedType, Object ... args) throws LambdaConversionException {
        boolean isSerializable;
        MethodType[] bridges;
        Class<?>[] markerInterfaces;
        MethodType samMethodType = (MethodType)args[0];
        MethodHandle implMethod = (MethodHandle)args[1];
        MethodType instantiatedMethodType = (MethodType)args[2];
        int flags = (Integer)args[3];
        int argIndex = 4;
        if ((flags & 2) != 0) {
            int markerCount = (Integer)args[argIndex++];
            markerInterfaces = new Class[markerCount];
            System.arraycopy(args, argIndex, markerInterfaces, 0, markerCount);
            argIndex += markerCount;
        } else {
            markerInterfaces = EMPTY_CLASS_ARRAY;
        }
        if ((flags & 4) != 0) {
            int bridgeCount = (Integer)args[argIndex++];
            bridges = new MethodType[bridgeCount];
            System.arraycopy(args, argIndex, bridges, 0, bridgeCount);
            argIndex += bridgeCount;
        } else {
            bridges = EMPTY_MT_ARRAY;
        }
        boolean bl = isSerializable = (flags & 1) != 0;
        if (isSerializable) {
            boolean foundSerializableSupertype = Serializable.class.isAssignableFrom((Class<?>)invokedType.returnType());
            for (Class<?> c : markerInterfaces) {
                foundSerializableSupertype |= Serializable.class.isAssignableFrom(c);
            }
            if (!foundSerializableSupertype) {
                markerInterfaces = Arrays.copyOf(markerInterfaces, markerInterfaces.length + 1);
                markerInterfaces[markerInterfaces.length - 1] = Serializable.class;
            }
        }
        InnerClassLambdaMetafactory mf = new InnerClassLambdaMetafactory(caller, invokedType, invokedName, samMethodType, implMethod, instantiatedMethodType, isSerializable, markerInterfaces, bridges);
        mf.validateMetafactoryArgs();
        return ((AbstractValidatingLambdaMetafactory)mf).buildCallSite();
    }
}

