/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.dashboard;

import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.dashboard.CodeBreakdownJsonObject;
import com.oracle.svm.hosted.dashboard.DashboardOptions;
import com.oracle.svm.hosted.dashboard.HeapBreakdownJsonObject;
import com.oracle.svm.hosted.dashboard.PointsToJsonObject;
import com.oracle.svm.hosted.dashboard.ToJson;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.channels.Channels;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.graphio.GraphOutput;
import org.graalvm.graphio.GraphStructure;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public class DashboardDumpFeature
implements Feature {
    private final ToJson dumper;

    private static boolean isHeapBreakdownDumped() {
        return DashboardOptions.DashboardAll.getValue() != false || DashboardOptions.DashboardHeap.getValue() != false;
    }

    private static boolean isPointsToDumped() {
        return DashboardOptions.DashboardAll.getValue() != false || DashboardOptions.DashboardPointsTo.getValue() != false;
    }

    private static boolean isCodeBreakdownDumped() {
        return DashboardOptions.DashboardAll.getValue() != false || DashboardOptions.DashboardCode.getValue() != false;
    }

    private static boolean isBgvFormat() {
        return DashboardOptions.DashboardBgv.getValue();
    }

    private static boolean isJsonFormat() {
        return DashboardOptions.DashboardJson.getValue() != false || DashboardDumpFeature.isPretty();
    }

    private static boolean isPretty() {
        return DashboardOptions.DashboardPretty.getValue();
    }

    private static Path getFile(String extension) {
        return new File(DashboardOptions.DashboardDump.getValue() + "." + extension).getAbsoluteFile().toPath();
    }

    public DashboardDumpFeature() {
        if (DashboardDumpFeature.isSane()) {
            if (DashboardDumpFeature.isJsonFormat()) {
                this.dumper = new ToJson(DashboardDumpFeature.isPretty());
                ReportUtils.report((String)"Dashboard JSON dump header", (Path)DashboardDumpFeature.getFile("dump"), (boolean)false, os -> {
                    try (PrintWriter pw = new PrintWriter((OutputStream)os);){
                        this.dumper.printHeader(pw);
                    }
                });
            } else {
                this.dumper = null;
            }
            if (DashboardDumpFeature.isBgvFormat()) {
                ReportUtils.report((String)"Dashboard BGV dump header", (Path)DashboardDumpFeature.getFile("bgv"), (boolean)false, os -> {
                    try {
                        GraphOutput.newBuilder(VoidGraphStructure.INSTANCE).build(Channels.newChannel(os)).close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(DashboardDumpFeature.class.getName()).log(Level.SEVERE, null, ex);
                    }
                });
            }
        } else {
            this.dumper = null;
        }
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return DashboardDumpFeature.isSane();
    }

    private static boolean isSane() {
        return DashboardOptions.DashboardDump.getValue() != null && (DashboardDumpFeature.isHeapBreakdownDumped() || DashboardDumpFeature.isPointsToDumped() || DashboardDumpFeature.isCodeBreakdownDumped());
    }

    public void onAnalysisExit(Feature.OnAnalysisExitAccess access) {
        if (DashboardDumpFeature.isPointsToDumped()) {
            if (DashboardDumpFeature.isJsonFormat()) {
                ReportUtils.report((String)"Dashboard PointsTo analysis JSON dump", (Path)DashboardDumpFeature.getFile("dump"), (boolean)true, os -> {
                    try (PrintWriter pw = new PrintWriter((OutputStream)os);){
                        this.dumper.put(pw, "points-to", new PointsToJsonObject(access));
                    }
                });
            }
            if (DashboardDumpFeature.isBgvFormat()) {
                ReportUtils.report((String)"Dashboard PointsTo analysis BGV dump", (Path)DashboardDumpFeature.getFile("bgv"), (boolean)true, os -> {
                    try (GraphOutput out = GraphOutput.newBuilder(VoidGraphStructure.INSTANCE).embedded(true).build(Channels.newChannel(os));){
                        out.beginGroup(null, "points-to", null, null, 0, Collections.emptyMap());
                        new PointsToJsonObject(access).dump(out);
                        out.endGroup();
                    }
                    catch (IOException ex) {
                        ((FeatureImpl.OnAnalysisExitAccessImpl)access).getDebugContext().log("Dump of PointsTo analysis failed with: %s", (Object)ex);
                    }
                });
            }
        }
    }

    public void afterCompilation(Feature.AfterCompilationAccess access) {
        if (DashboardDumpFeature.isCodeBreakdownDumped() || DashboardDumpFeature.isPointsToDumped()) {
            CodeBreakdownJsonObject dump = new CodeBreakdownJsonObject(access);
            if (DashboardDumpFeature.isJsonFormat()) {
                ReportUtils.report((String)"Dashboard Code-Breakdown JSON dump", (Path)DashboardDumpFeature.getFile("dump"), (boolean)true, os -> {
                    try (PrintWriter pw = new PrintWriter((OutputStream)os);){
                        this.dumper.put(pw, "code-breakdown", dump);
                    }
                });
            }
            if (DashboardDumpFeature.isBgvFormat()) {
                ReportUtils.report((String)"Dashboard Code-Breakdown BGV dump", (Path)DashboardDumpFeature.getFile("bgv"), (boolean)true, os -> {
                    try (GraphOutput out = GraphOutput.newBuilder(VoidGraphStructure.INSTANCE).embedded(true).build(Channels.newChannel(os));){
                        dump.build();
                        out.beginGroup(null, "code-breakdown", null, null, 0, dump.getData());
                        out.endGroup();
                    }
                    catch (IOException ex) {
                        ((FeatureImpl.AfterCompilationAccessImpl)access).getDebugContext().log("Dump of Code-Breakdown failed with: %s", (Object)ex);
                    }
                });
            }
        }
    }

    public void afterHeapLayout(Feature.AfterHeapLayoutAccess access) {
        if (DashboardDumpFeature.isHeapBreakdownDumped()) {
            HeapBreakdownJsonObject dump = new HeapBreakdownJsonObject(access);
            if (DashboardDumpFeature.isJsonFormat()) {
                ReportUtils.report((String)"Dashboard Heap-Breakdown JSON dump", (Path)DashboardDumpFeature.getFile("dump"), (boolean)true, os -> {
                    try (PrintWriter pw = new PrintWriter((OutputStream)os);){
                        this.dumper.put(pw, "heap-breakdown", dump);
                    }
                });
            }
            if (DashboardDumpFeature.isBgvFormat()) {
                ReportUtils.report((String)"Dashboard Heap-Breakdown BGV dump", (Path)DashboardDumpFeature.getFile("bgv"), (boolean)true, os -> {
                    try (GraphOutput out = GraphOutput.newBuilder(VoidGraphStructure.INSTANCE).embedded(true).build(Channels.newChannel(os));){
                        dump.build();
                        out.beginGroup(null, "heap-breakdown", null, null, 0, dump.getData());
                        out.endGroup();
                    }
                    catch (IOException ex) {
                        ((FeatureImpl.AfterHeapLayoutAccessImpl)access).getDebugContext().log("Dump of Heap-Breakdown failed with: %s", (Object)ex);
                    }
                });
            }
        }
    }

    public void cleanup() {
        if (DashboardDumpFeature.isJsonFormat()) {
            ReportUtils.report((String)"Dashboard JSON dump end", (Path)DashboardDumpFeature.getFile("dump"), (boolean)true, os -> {
                try (PrintWriter pw = new PrintWriter((OutputStream)os, true);){
                    this.dumper.close(pw);
                }
            });
        }
        System.out.println("Print of Dashboard dump output ended.");
    }

    public static final class VoidGraphStructure
    implements GraphStructure<Void, Void, Void, Void> {
        public static final GraphStructure<Void, Void, Void, Void> INSTANCE = new VoidGraphStructure();

        private VoidGraphStructure() {
        }

        public Void graph(Void currentGraph, Object obj) {
            return null;
        }

        public Iterable<? extends Void> nodes(Void graph) {
            return Collections.emptyList();
        }

        public int nodesCount(Void graph) {
            return 0;
        }

        public int nodeId(Void node) {
            return 0;
        }

        public boolean nodeHasPredecessor(Void node) {
            return false;
        }

        public void nodeProperties(Void graph, Void node, Map<String, ? super Object> properties) {
        }

        public Void node(Object obj) {
            return null;
        }

        public Void nodeClass(Object obj) {
            return null;
        }

        public Void classForNode(Void node) {
            return null;
        }

        public String nameTemplate(Void nodeClass) {
            return null;
        }

        public Object nodeClassType(Void nodeClass) {
            return null;
        }

        public Void portInputs(Void nodeClass) {
            return null;
        }

        public Void portOutputs(Void nodeClass) {
            return null;
        }

        public int portSize(Void port) {
            return 0;
        }

        public boolean edgeDirect(Void port, int index) {
            return false;
        }

        public String edgeName(Void port, int index) {
            return null;
        }

        public Object edgeType(Void port, int index) {
            return null;
        }

        public Collection<? extends Void> edgeNodes(Void graph, Void node, Void port, int index) {
            return null;
        }
    }
}

