/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaMethod;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.image.ImageHeapPartition;
import com.oracle.svm.hosted.annotation.CustomSubstitutionMethod;
import com.oracle.svm.hosted.annotation.CustomSubstitutionType;
import com.oracle.svm.hosted.image.NativeImage;
import com.oracle.svm.hosted.image.NativeImageCodeCache;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.image.sources.SourceManager;
import com.oracle.svm.hosted.lambda.LambdaSubstitutionType;
import com.oracle.svm.hosted.meta.HostedArrayClass;
import com.oracle.svm.hosted.meta.HostedClass;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInstanceClass;
import com.oracle.svm.hosted.meta.HostedInterface;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedPrimitiveType;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.substitute.InjectedFieldsType;
import com.oracle.svm.hosted.substitute.SubstitutionMethod;
import com.oracle.svm.hosted.substitute.SubstitutionType;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.LineNumberTable;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.code.SourceMapping;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.nativeimage.ImageSingletons;

class NativeImageDebugInfoProvider
implements DebugInfoProvider {
    private final DebugContext debugContext;
    private final NativeImageCodeCache codeCache;
    private final NativeImageHeap heap;
    boolean useHeapBase;
    int compressShift;
    int tagsMask;
    int referenceSize;
    int pointerSize;
    int referenceAlignment;
    int primitiveStartOffset;
    int referenceStartOffset;
    private final Path cachePath = SubstrateOptions.getDebugInfoSourceCacheRoot();

    NativeImageDebugInfoProvider(DebugContext debugContext, NativeImageCodeCache codeCache, NativeImageHeap heap) {
        this.debugContext = debugContext;
        this.codeCache = codeCache;
        this.heap = heap;
        ObjectHeader objectHeader = Heap.getHeap().getObjectHeader();
        NativeImageHeap.ObjectInfo primitiveFields = heap.getObjectInfo(StaticFieldsSupport.getStaticPrimitiveFields());
        NativeImageHeap.ObjectInfo objectFields = heap.getObjectInfo(StaticFieldsSupport.getStaticObjectFields());
        this.tagsMask = objectHeader.getReservedBitsMask();
        if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            CompressEncoding compressEncoding = (CompressEncoding)ImageSingletons.lookup(CompressEncoding.class);
            this.useHeapBase = compressEncoding.hasBase();
            this.compressShift = compressEncoding.hasShift() ? compressEncoding.getShift() : 0;
        } else {
            this.useHeapBase = false;
            this.compressShift = 0;
        }
        this.referenceSize = NativeImageDebugInfoProvider.getObjectLayout().getReferenceSize();
        this.pointerSize = ConfigurationValues.getTarget().wordSize;
        this.referenceAlignment = NativeImageDebugInfoProvider.getObjectLayout().getAlignment();
        this.primitiveStartOffset = (int)primitiveFields.getOffset();
        this.referenceStartOffset = (int)objectFields.getOffset();
    }

    public boolean useHeapBase() {
        return this.useHeapBase;
    }

    public int oopCompressShift() {
        return this.compressShift;
    }

    public int oopReferenceSize() {
        return this.referenceSize;
    }

    public int pointerSize() {
        return this.pointerSize;
    }

    public int oopAlignment() {
        return this.referenceAlignment;
    }

    public int oopTagsMask() {
        return this.tagsMask;
    }

    public Stream<DebugInfoProvider.DebugTypeInfo> typeInfoProvider() {
        Stream<DebugInfoProvider.DebugTypeInfo> headerTypeInfo = this.computeHeaderTypeInfo();
        Stream<DebugInfoProvider.DebugTypeInfo> heapTypeInfo = this.heap.getUniverse().getTypes().stream().map(this::createDebugTypeInfo);
        return Stream.concat(headerTypeInfo, heapTypeInfo);
    }

    public Stream<DebugInfoProvider.DebugCodeInfo> codeInfoProvider() {
        return this.codeCache.compilations.entrySet().stream().map(entry -> new NativeImageDebugCodeInfo((HostedMethod)entry.getKey(), (CompilationResult)entry.getValue()));
    }

    public Stream<DebugInfoProvider.DebugDataInfo> dataInfoProvider() {
        return this.heap.getObjects().stream().filter(this::acceptObjectInfo).map(this::createDebugDataInfo);
    }

    static ObjectLayout getObjectLayout() {
        return ConfigurationValues.getObjectLayout();
    }

    protected static ResolvedJavaType getDeclaringClass(HostedType hostedType, boolean wantOriginal) {
        if (wantOriginal) {
            return NativeImageDebugInfoProvider.getOriginal(hostedType);
        }
        return hostedType.getWrapped().getWrapped();
    }

    protected static ResolvedJavaType getDeclaringClass(HostedMethod hostedMethod, boolean wantOriginal) {
        if (wantOriginal) {
            return NativeImageDebugInfoProvider.getOriginal(hostedMethod.getDeclaringClass());
        }
        ResolvedJavaMethod javaMethod = hostedMethod.getWrapped().getWrapped();
        if (javaMethod instanceof SubstitutionMethod) {
            SubstitutionMethod substitutionMethod = (SubstitutionMethod)javaMethod;
            return substitutionMethod.getAnnotated().getDeclaringClass();
        }
        return javaMethod.getDeclaringClass();
    }

    protected static ResolvedJavaType getDeclaringClass(HostedField hostedField, boolean wantOriginal) {
        return NativeImageDebugInfoProvider.getOriginal(hostedField.getDeclaringClass());
    }

    private static ResolvedJavaType getOriginal(HostedType hostedType) {
        ResolvedJavaType javaType = hostedType.getWrapped().getWrappedWithoutResolve();
        if (javaType instanceof SubstitutionType) {
            return ((SubstitutionType)javaType).getOriginal();
        }
        if (javaType instanceof CustomSubstitutionType) {
            return ((CustomSubstitutionType)javaType).getOriginal();
        }
        if (javaType instanceof LambdaSubstitutionType) {
            return ((LambdaSubstitutionType)javaType).getOriginal();
        }
        if (javaType instanceof InjectedFieldsType) {
            return ((InjectedFieldsType)javaType).getOriginal();
        }
        return javaType;
    }

    private static String toJavaName(JavaType javaType) {
        if (javaType instanceof HostedType) {
            return NativeImageDebugInfoProvider.getDeclaringClass((HostedType)javaType, true).toJavaName();
        }
        return javaType.toJavaName();
    }

    private Stream<DebugInfoProvider.DebugTypeInfo> computeHeaderTypeInfo() {
        LinkedList<NativeImageHeaderTypeInfo> infos = new LinkedList<NativeImageHeaderTypeInfo>();
        int hubOffset = NativeImageDebugInfoProvider.getObjectLayout().getHubOffset();
        int hubFieldSize = this.referenceSize;
        String hubTypeName = "java.lang.Class";
        int idHashOffset = NativeImageDebugInfoProvider.getObjectLayout().getIdentityHashCodeOffset();
        int idHashSize = NativeImageDebugInfoProvider.getObjectLayout().sizeInBytes(JavaKind.Int);
        int objHeaderSize = NativeImageDebugInfoProvider.getObjectLayout().getMinimumInstanceObjectSize();
        NativeImageHeaderTypeInfo objHeader = new NativeImageHeaderTypeInfo("_objhdr", objHeaderSize);
        objHeader.addField("hub", hubTypeName, hubOffset, hubFieldSize);
        if (idHashOffset > 0) {
            objHeader.addField("idHash", "int", idHashOffset, idHashSize);
        }
        infos.add(objHeader);
        return infos.stream();
    }

    private NativeImageDebugTypeInfo createDebugTypeInfo(HostedType hostedType) {
        if (hostedType.isEnum()) {
            return new NativeImageDebugEnumTypeInfo((HostedInstanceClass)hostedType);
        }
        if (hostedType.isInstanceClass()) {
            return new NativeImageDebugInstanceTypeInfo(hostedType);
        }
        if (hostedType.isInterface()) {
            return new NativeImageDebugInterfaceTypeInfo((HostedInterface)hostedType);
        }
        if (hostedType.isArray()) {
            return new NativeImageDebugArrayTypeInfo((HostedArrayClass)hostedType);
        }
        if (hostedType.isPrimitive()) {
            return new NativeImageDebugPrimitiveTypeInfo((HostedPrimitiveType)hostedType);
        }
        throw new RuntimeException("Unknown type kind " + hostedType.getName());
    }

    private static boolean filterLineInfoSourceMapping(SourceMapping sourceMapping) {
        NodeSourcePosition sourcePosition = sourceMapping.getSourcePosition();
        if (sourceMapping.getStartOffset() == sourceMapping.getEndOffset()) {
            return false;
        }
        return SubstrateOptions.OmitInlinedMethodDebugLineInfo.getValue() == false || sourcePosition.getCaller() == null;
    }

    private boolean acceptObjectInfo(NativeImageHeap.ObjectInfo objectInfo) {
        return objectInfo.getPartition().getStartOffset() > 0L;
    }

    private DebugInfoProvider.DebugDataInfo createDebugDataInfo(NativeImageHeap.ObjectInfo objectInfo) {
        return new NativeImageDebugDataInfo(objectInfo);
    }

    private class NativeImageDebugDataInfo
    implements DebugInfoProvider.DebugDataInfo {
        HostedClass hostedClass;
        ImageHeapPartition partition;
        long offset;
        long address;
        long size;
        String typeName;
        String provenance;

        public void debugContext(Consumer<DebugContext> action) {
            try (DebugContext.Scope s = NativeImageDebugInfoProvider.this.debugContext.scope((Object)"DebugCodeInfo", (Object)this.provenance);){
                action.accept(NativeImageDebugInfoProvider.this.debugContext);
            }
            catch (Throwable e) {
                throw NativeImageDebugInfoProvider.this.debugContext.handle(e);
            }
        }

        NativeImageDebugDataInfo(NativeImageHeap.ObjectInfo objectInfo) {
            this.hostedClass = objectInfo.getClazz();
            this.partition = objectInfo.getPartition();
            this.offset = objectInfo.getOffset();
            this.address = objectInfo.getAddress();
            this.size = objectInfo.getSize();
            this.provenance = objectInfo.toString();
            this.typeName = this.hostedClass.toJavaName();
        }

        public String getProvenance() {
            return this.provenance;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public String getPartition() {
            return this.partition.getName() + "{" + this.partition.getSize() + "}@" + this.partition.getStartOffset();
        }

        public long getOffset() {
            return this.offset;
        }

        public long getAddress() {
            return this.address;
        }

        public long getSize() {
            return this.size;
        }
    }

    private class NativeImageDebugFrameSizeChange
    implements DebugInfoProvider.DebugFrameSizeChange {
        private int offset;
        private DebugInfoProvider.DebugFrameSizeChange.Type type;

        NativeImageDebugFrameSizeChange(int offset, DebugInfoProvider.DebugFrameSizeChange.Type type) {
            this.offset = offset;
            this.type = type;
        }

        public int getOffset() {
            return this.offset;
        }

        public DebugInfoProvider.DebugFrameSizeChange.Type getType() {
            return this.type;
        }
    }

    private class NativeImageDebugLineInfo
    implements DebugInfoProvider.DebugLineInfo {
        private final int bci;
        private final ResolvedJavaMethod method;
        private final int lo;
        private final int hi;
        private Path cachePath;
        private Path fullFilePath;
        private DebugInfoProvider.DebugLineInfo callersLineInfo;

        NativeImageDebugLineInfo(SourceMapping sourceMapping) {
            this(sourceMapping.getSourcePosition(), sourceMapping.getStartOffset(), sourceMapping.getEndOffset());
        }

        NativeImageDebugLineInfo(DebugInfoProvider.DebugLineInfo lineInfo, NodeSourcePosition position) {
            this(position, lineInfo.addressLo(), lineInfo.addressHi());
        }

        NativeImageDebugLineInfo(NodeSourcePosition position, int lo, int hi) {
            NodeSourcePosition callerPosition;
            this.bci = position.getBCI();
            this.method = position.getMethod();
            this.lo = lo;
            this.hi = hi;
            this.cachePath = SubstrateOptions.getDebugInfoSourceCacheRoot();
            for (callerPosition = position.getCaller(); callerPosition != null && callerPosition.isSubstitution() && callerPosition.getBCI() == -1; callerPosition = callerPosition.getCaller()) {
            }
            this.callersLineInfo = callerPosition != null ? new NativeImageDebugLineInfo(this, callerPosition) : null;
            this.computeFullFilePath();
        }

        public String fileName() {
            Path fileName;
            if (this.fullFilePath != null && (fileName = this.fullFilePath.getFileName()) != null) {
                return fileName.toString();
            }
            return null;
        }

        public Path filePath() {
            if (this.fullFilePath != null) {
                return this.fullFilePath.getParent();
            }
            return null;
        }

        public Path cachePath() {
            return this.cachePath;
        }

        public ResolvedJavaType ownerType() {
            if (this.method instanceof HostedMethod) {
                return NativeImageDebugInfoProvider.getDeclaringClass((HostedMethod)this.method, true);
            }
            return this.method.getDeclaringClass();
        }

        public String name() {
            ResolvedJavaMethod targetMethod = this.method;
            while (targetMethod instanceof WrappedJavaMethod) {
                targetMethod = ((WrappedJavaMethod)targetMethod).getWrapped();
            }
            if (targetMethod instanceof SubstitutionMethod) {
                targetMethod = ((SubstitutionMethod)targetMethod).getOriginal();
            } else if (targetMethod instanceof CustomSubstitutionMethod) {
                targetMethod = ((CustomSubstitutionMethod)targetMethod).getOriginal();
            }
            String name = targetMethod.getName();
            if (name.equals("<init>")) {
                if (this.method instanceof HostedMethod) {
                    name = NativeImageDebugInfoProvider.getDeclaringClass((HostedMethod)this.method, true).toJavaName();
                    if (name.indexOf(46) >= 0) {
                        name = name.substring(name.lastIndexOf(46) + 1);
                    }
                    if (name.indexOf(36) >= 0) {
                        name = name.substring(name.lastIndexOf(36) + 1);
                    }
                } else {
                    name = targetMethod.format("%h");
                    if (name.indexOf(36) >= 0) {
                        name = name.substring(name.lastIndexOf(36) + 1);
                    }
                }
            }
            return name;
        }

        public String valueType() {
            return this.method.format("%R");
        }

        public String symbolNameForMethod() {
            return NativeImage.localSymbolNameForMethod(this.method);
        }

        public boolean isDeoptTarget() {
            if (this.method instanceof HostedMethod) {
                return ((HostedMethod)this.method).isDeoptTarget();
            }
            return this.name().endsWith("**");
        }

        public int addressLo() {
            return this.lo;
        }

        public int addressHi() {
            return this.hi;
        }

        public int line() {
            LineNumberTable lineNumberTable = this.method.getLineNumberTable();
            if (lineNumberTable != null && this.bci >= 0) {
                return lineNumberTable.getLineNumber(this.bci);
            }
            return -1;
        }

        public List<String> paramTypes() {
            Signature signature = this.method.getSignature();
            int parameterCount = signature.getParameterCount(false);
            ArrayList<String> paramTypes = new ArrayList<String>(parameterCount);
            for (int i = 0; i < parameterCount; ++i) {
                JavaType parameterType = signature.getParameterType(i, null);
                paramTypes.add(NativeImageDebugInfoProvider.toJavaName(parameterType));
            }
            return paramTypes;
        }

        public List<String> paramNames() {
            Signature signature = this.method.getSignature();
            int parameterCount = signature.getParameterCount(false);
            ArrayList<String> paramNames = new ArrayList<String>(parameterCount);
            for (int i = 0; i < parameterCount; ++i) {
                paramNames.add("");
            }
            return paramNames;
        }

        public int modifiers() {
            return this.method.getModifiers();
        }

        public DebugInfoProvider.DebugLineInfo getCaller() {
            return this.callersLineInfo;
        }

        private void computeFullFilePath() {
            ResolvedJavaType declaringClass = this.method instanceof HostedMethod ? NativeImageDebugInfoProvider.getDeclaringClass((HostedMethod)this.method, false) : this.method.getDeclaringClass();
            Class clazz = null;
            if (declaringClass instanceof OriginalClassProvider) {
                clazz = ((OriginalClassProvider)declaringClass).getJavaClass();
            }
            SourceManager sourceManager = (SourceManager)ImageSingletons.lookup(SourceManager.class);
            try (DebugContext.Scope s = NativeImageDebugInfoProvider.this.debugContext.scope((Object)"DebugCodeInfo", (Object)declaringClass);){
                this.fullFilePath = sourceManager.findAndCacheSource(declaringClass, clazz, NativeImageDebugInfoProvider.this.debugContext);
            }
            catch (Throwable e) {
                throw NativeImageDebugInfoProvider.this.debugContext.handle(e);
            }
        }
    }

    private class NativeImageDebugCodeInfo
    extends NativeImageDebugFileInfo
    implements DebugInfoProvider.DebugCodeInfo {
        private final HostedMethod hostedMethod;
        private final CompilationResult compilation;

        NativeImageDebugCodeInfo(HostedMethod method, CompilationResult compilation) {
            super(method);
            this.hostedMethod = method;
            this.compilation = compilation;
        }

        public void debugContext(Consumer<DebugContext> action) {
            try (DebugContext.Scope s = NativeImageDebugInfoProvider.this.debugContext.scope((Object)"DebugCodeInfo", (Object)this.hostedMethod);){
                action.accept(NativeImageDebugInfoProvider.this.debugContext);
            }
            catch (Throwable e) {
                throw NativeImageDebugInfoProvider.this.debugContext.handle(e);
            }
        }

        public ResolvedJavaType ownerType() {
            return NativeImageDebugInfoProvider.getDeclaringClass(this.hostedMethod, true);
        }

        public String name() {
            ResolvedJavaMethod targetMethod = this.hostedMethod.getWrapped().getWrapped();
            if (targetMethod instanceof SubstitutionMethod) {
                targetMethod = ((SubstitutionMethod)targetMethod).getOriginal();
            } else if (targetMethod instanceof CustomSubstitutionMethod) {
                targetMethod = ((CustomSubstitutionMethod)targetMethod).getOriginal();
            }
            String name = targetMethod.getName();
            if (name.equals("<init>")) {
                name = NativeImageDebugInfoProvider.getDeclaringClass(this.hostedMethod, true).toJavaName();
                if (name.indexOf(46) >= 0) {
                    name = name.substring(name.lastIndexOf(46) + 1);
                }
                if (name.indexOf(36) >= 0) {
                    name = name.substring(name.lastIndexOf(36) + 1);
                }
            }
            return name;
        }

        public String symbolNameForMethod() {
            return NativeImage.localSymbolNameForMethod(this.hostedMethod);
        }

        public String valueType() {
            return this.hostedMethod.format("%R");
        }

        public int addressLo() {
            return this.hostedMethod.getCodeAddressOffset();
        }

        public int addressHi() {
            return this.hostedMethod.getCodeAddressOffset() + this.compilation.getTargetCodeSize();
        }

        public int line() {
            LineNumberTable lineNumberTable = this.hostedMethod.getLineNumberTable();
            if (lineNumberTable != null) {
                return lineNumberTable.getLineNumber(0);
            }
            return -1;
        }

        public Stream<DebugInfoProvider.DebugLineInfo> lineInfoProvider() {
            if (this.fileName().length() == 0) {
                return Stream.empty();
            }
            return this.compilation.getSourceMappings().stream().filter(x$0 -> NativeImageDebugInfoProvider.filterLineInfoSourceMapping(x$0)).map(sourceMapping -> new NativeImageDebugLineInfo((SourceMapping)sourceMapping));
        }

        public int getFrameSize() {
            return this.compilation.getTotalFrameSize();
        }

        public List<DebugInfoProvider.DebugFrameSizeChange> getFrameSizeChanges() {
            LinkedList<DebugInfoProvider.DebugFrameSizeChange> frameSizeChanges = new LinkedList<DebugInfoProvider.DebugFrameSizeChange>();
            for (CompilationResult.CodeMark mark : this.compilation.getMarks()) {
                NativeImageDebugFrameSizeChange sizeChange;
                if (mark.id.equals((Object)SubstrateBackend.SubstrateMarkId.PROLOGUE_DECD_RSP)) {
                    sizeChange = new NativeImageDebugFrameSizeChange(mark.pcOffset, DebugInfoProvider.DebugFrameSizeChange.Type.EXTEND);
                    frameSizeChanges.add(sizeChange);
                    continue;
                }
                if (mark.id.equals((Object)SubstrateBackend.SubstrateMarkId.EPILOGUE_INCD_RSP)) {
                    sizeChange = new NativeImageDebugFrameSizeChange(mark.pcOffset, DebugInfoProvider.DebugFrameSizeChange.Type.CONTRACT);
                    frameSizeChanges.add(sizeChange);
                    continue;
                }
                if (!mark.id.equals((Object)SubstrateBackend.SubstrateMarkId.EPILOGUE_END) || mark.pcOffset >= this.compilation.getTargetCodeSize()) continue;
                sizeChange = new NativeImageDebugFrameSizeChange(mark.pcOffset, DebugInfoProvider.DebugFrameSizeChange.Type.EXTEND);
                frameSizeChanges.add(sizeChange);
            }
            return frameSizeChanges;
        }

        public boolean isDeoptTarget() {
            return this.hostedMethod.isDeoptTarget();
        }

        public List<String> paramTypes() {
            Signature signature = this.hostedMethod.getSignature();
            int parameterCount = signature.getParameterCount(false);
            ArrayList<String> paramTypes = new ArrayList<String>(parameterCount);
            for (int i = 0; i < parameterCount; ++i) {
                JavaType parameterType = signature.getParameterType(i, null);
                paramTypes.add(NativeImageDebugInfoProvider.toJavaName(parameterType));
            }
            return paramTypes;
        }

        public List<String> paramNames() {
            Signature signature = this.hostedMethod.getSignature();
            int parameterCount = signature.getParameterCount(false);
            ArrayList<String> paramNames = new ArrayList<String>(parameterCount);
            for (int i = 0; i < parameterCount; ++i) {
                paramNames.add("");
            }
            return paramNames;
        }

        public int modifiers() {
            return this.hostedMethod.getModifiers();
        }
    }

    private class NativeImageDebugPrimitiveTypeInfo
    extends NativeImageDebugTypeInfo
    implements DebugInfoProvider.DebugPrimitiveTypeInfo {
        private final HostedPrimitiveType primitiveType;

        NativeImageDebugPrimitiveTypeInfo(HostedPrimitiveType primitiveType) {
            super(primitiveType);
            this.primitiveType = primitiveType;
        }

        public DebugInfoProvider.DebugTypeInfo.DebugTypeKind typeKind() {
            return DebugInfoProvider.DebugTypeInfo.DebugTypeKind.PRIMITIVE;
        }

        public int bitCount() {
            JavaKind javaKind = this.primitiveType.getStorageKind();
            return javaKind == JavaKind.Void ? 0 : javaKind.getBitCount();
        }

        public char typeChar() {
            return this.primitiveType.getStorageKind().getTypeChar();
        }

        public int flags() {
            char typeChar = this.primitiveType.getStorageKind().getTypeChar();
            switch (typeChar) {
                case 'B': 
                case 'I': 
                case 'J': 
                case 'S': {
                    return 7;
                }
                case 'C': {
                    return 3;
                }
                case 'D': 
                case 'F': {
                    return 1;
                }
            }
            assert (typeChar == 'V' || typeChar == 'Z');
            return 0;
        }
    }

    private class NativeImageDebugArrayTypeInfo
    extends NativeImageDebugTypeInfo
    implements DebugInfoProvider.DebugArrayTypeInfo {
        HostedArrayClass arrayClass;
        List<DebugInfoProvider.DebugFieldInfo> fieldInfos;

        NativeImageDebugArrayTypeInfo(HostedArrayClass arrayClass) {
            super(arrayClass);
            this.arrayClass = arrayClass;
            this.fieldInfos = new LinkedList<DebugInfoProvider.DebugFieldInfo>();
            JavaKind arrayKind = arrayClass.getBaseType().getJavaKind();
            int headerSize = NativeImageDebugInfoProvider.getObjectLayout().getArrayBaseOffset(arrayKind);
            int arrayLengthOffset = NativeImageDebugInfoProvider.getObjectLayout().getArrayLengthOffset();
            int arrayLengthSize = NativeImageDebugInfoProvider.getObjectLayout().sizeInBytes(JavaKind.Int);
            assert (arrayLengthOffset + arrayLengthSize <= headerSize);
            this.addField("len", "int", arrayLengthOffset, arrayLengthSize);
        }

        void addField(String name, String valueType, int offset, int size) {
            NativeImageDebugHeaderFieldInfo fieldinfo = new NativeImageDebugHeaderFieldInfo(name, valueType, offset, size);
            this.fieldInfos.add(fieldinfo);
        }

        public DebugInfoProvider.DebugTypeInfo.DebugTypeKind typeKind() {
            return DebugInfoProvider.DebugTypeInfo.DebugTypeKind.ARRAY;
        }

        public int baseSize() {
            return NativeImageDebugInfoProvider.getObjectLayout().getArrayBaseOffset(this.arrayClass.getComponentType().getStorageKind());
        }

        public int lengthOffset() {
            return NativeImageDebugInfoProvider.getObjectLayout().getArrayLengthOffset();
        }

        public String elementType() {
            HostedType elementType = this.arrayClass.getComponentType();
            return this.toJavaName(elementType);
        }

        public Stream<DebugInfoProvider.DebugFieldInfo> fieldInfoProvider() {
            return this.fieldInfos.stream();
        }
    }

    private class NativeImageDebugInterfaceTypeInfo
    extends NativeImageDebugInstanceTypeInfo
    implements DebugInfoProvider.DebugInterfaceTypeInfo {
        NativeImageDebugInterfaceTypeInfo(HostedInterface interfaceClass) {
            super(interfaceClass);
        }

        @Override
        public DebugInfoProvider.DebugTypeInfo.DebugTypeKind typeKind() {
            return DebugInfoProvider.DebugTypeInfo.DebugTypeKind.INTERFACE;
        }
    }

    private class NativeImageDebugInstanceTypeInfo
    extends NativeImageDebugTypeInfo
    implements DebugInfoProvider.DebugInstanceTypeInfo {
        NativeImageDebugInstanceTypeInfo(HostedType hostedType) {
            super(hostedType);
        }

        public DebugInfoProvider.DebugTypeInfo.DebugTypeKind typeKind() {
            return DebugInfoProvider.DebugTypeInfo.DebugTypeKind.INSTANCE;
        }

        public int headerSize() {
            return NativeImageDebugInfoProvider.getObjectLayout().getFirstFieldOffset();
        }

        public Stream<DebugInfoProvider.DebugFieldInfo> fieldInfoProvider() {
            Stream<DebugInfoProvider.DebugFieldInfo> instanceFieldsStream = Arrays.stream(this.hostedType.getInstanceFields(false)).map(this::createDebugFieldInfo);
            if (this.hostedType instanceof HostedInstanceClass && this.hostedType.getStaticFields().length > 0) {
                Stream<DebugInfoProvider.DebugFieldInfo> staticFieldsStream = Arrays.stream(this.hostedType.getStaticFields()).map(this::createDebugStaticFieldInfo);
                return Stream.concat(instanceFieldsStream, staticFieldsStream);
            }
            return instanceFieldsStream;
        }

        public Stream<DebugInfoProvider.DebugMethodInfo> methodInfoProvider() {
            return Arrays.stream(this.hostedType.getAllDeclaredMethods()).map(this::createDebugMethodInfo);
        }

        public String superName() {
            HostedClass superClass = this.hostedType.getSuperclass();
            if (superClass != null) {
                return NativeImageDebugInfoProvider.getDeclaringClass(superClass, true).toJavaName();
            }
            return null;
        }

        public Stream<String> interfaces() {
            return Arrays.stream(this.hostedType.getInterfaces()).map(this::toJavaName);
        }

        protected NativeImageDebugFieldInfo createDebugFieldInfo(HostedField field) {
            return new NativeImageDebugFieldInfo(field);
        }

        protected NativeImageDebugFieldInfo createDebugStaticFieldInfo(ResolvedJavaField field) {
            return new NativeImageDebugFieldInfo((HostedField)field);
        }

        protected NativeImageDebugMethodInfo createDebugMethodInfo(HostedMethod method) {
            return new NativeImageDebugMethodInfo(method);
        }

        protected class NativeImageDebugMethodInfo
        extends NativeImageDebugFileInfo
        implements DebugInfoProvider.DebugMethodInfo {
            private final HostedMethod hostedMethod;

            NativeImageDebugMethodInfo(HostedMethod hostedMethod) {
                super(hostedMethod);
                this.hostedMethod = hostedMethod;
            }

            public String name() {
                String name = this.hostedMethod.format("%n");
                if ("<init>".equals(name)) {
                    name = NativeImageDebugInfoProvider.getDeclaringClass(this.hostedMethod, true).toJavaName();
                    if (name.indexOf(46) >= 0) {
                        name = name.substring(name.lastIndexOf(46) + 1);
                    }
                    if (name.indexOf(36) >= 0) {
                        name = name.substring(name.lastIndexOf(36) + 1);
                    }
                }
                return name;
            }

            public String valueType() {
                return this.hostedMethod.getSignature().getReturnType(null).toJavaName();
            }

            public List<String> paramTypes() {
                Signature signature = this.hostedMethod.getSignature();
                int parameterCount = signature.getParameterCount(false);
                ArrayList<String> paramTypes = new ArrayList<String>(parameterCount);
                for (int i = 0; i < parameterCount; ++i) {
                    paramTypes.add(signature.getParameterType(i, null).toJavaName());
                }
                return paramTypes;
            }

            public List<String> paramNames() {
                Signature signature = this.hostedMethod.getSignature();
                int parameterCount = signature.getParameterCount(false);
                ArrayList<String> paramNames = new ArrayList<String>(parameterCount);
                for (int i = 0; i < parameterCount; ++i) {
                    paramNames.add("");
                }
                return paramNames;
            }

            public String symbolNameForMethod() {
                return NativeImage.localSymbolNameForMethod(this.hostedMethod);
            }

            public boolean isDeoptTarget() {
                return this.hostedMethod.isDeoptTarget();
            }

            public int modifiers() {
                return this.hostedMethod.getModifiers();
            }
        }

        protected class NativeImageDebugFieldInfo
        extends NativeImageDebugFileInfo
        implements DebugInfoProvider.DebugFieldInfo {
            private final HostedField field;

            NativeImageDebugFieldInfo(HostedField field) {
                super(field);
                this.field = field;
            }

            public String name() {
                return this.field.getName();
            }

            public String valueType() {
                HostedType valueType = this.field.getType();
                return NativeImageDebugInstanceTypeInfo.this.toJavaName(valueType);
            }

            public int offset() {
                int offset = this.field.getLocation();
                if (this.isStatic() && offset >= 0) {
                    offset = this.isPrimitive() ? (offset += NativeImageDebugInfoProvider.this.primitiveStartOffset) : (offset += NativeImageDebugInfoProvider.this.referenceStartOffset);
                }
                return offset;
            }

            public int size() {
                return NativeImageDebugInfoProvider.getObjectLayout().sizeInBytes(this.field.getType().getStorageKind());
            }

            public int modifiers() {
                return this.field.getModifiers();
            }

            private boolean isStatic() {
                return Modifier.isStatic(this.modifiers());
            }

            private boolean isPrimitive() {
                return this.field.getType().getStorageKind().isPrimitive();
            }
        }
    }

    private class NativeImageDebugEnumTypeInfo
    extends NativeImageDebugInstanceTypeInfo
    implements DebugInfoProvider.DebugEnumTypeInfo {
        NativeImageDebugEnumTypeInfo(HostedInstanceClass enumClass) {
            super(enumClass);
        }

        @Override
        public DebugInfoProvider.DebugTypeInfo.DebugTypeKind typeKind() {
            return DebugInfoProvider.DebugTypeInfo.DebugTypeKind.ENUM;
        }
    }

    private class NativeImageDebugHeaderFieldInfo
    implements DebugInfoProvider.DebugFieldInfo {
        private final String name;
        private final String valueType;
        private final int offset;
        private final int size;
        private final int modifiers;

        NativeImageDebugHeaderFieldInfo(String name, String valueType, int offset, int size) {
            this.name = name;
            this.valueType = valueType;
            this.offset = offset;
            this.size = size;
            this.modifiers = 1;
        }

        public String name() {
            return this.name;
        }

        public String valueType() {
            return this.valueType;
        }

        public int offset() {
            return this.offset;
        }

        public int size() {
            return this.size;
        }

        public int modifiers() {
            return this.modifiers;
        }

        public String fileName() {
            return "";
        }

        public Path filePath() {
            return null;
        }

        public Path cachePath() {
            return null;
        }
    }

    private class NativeImageHeaderTypeInfo
    implements DebugInfoProvider.DebugHeaderTypeInfo {
        String typeName;
        int size;
        List<DebugInfoProvider.DebugFieldInfo> fieldInfos;

        NativeImageHeaderTypeInfo(String typeName, int size) {
            this.typeName = typeName;
            this.size = size;
            this.fieldInfos = new LinkedList<DebugInfoProvider.DebugFieldInfo>();
        }

        void addField(String name, String valueType, int offset, int size) {
            NativeImageDebugHeaderFieldInfo fieldinfo = new NativeImageDebugHeaderFieldInfo(name, valueType, offset, size);
            this.fieldInfos.add(fieldinfo);
        }

        public void debugContext(Consumer<DebugContext> action) {
            try (DebugContext.Scope s = NativeImageDebugInfoProvider.this.debugContext.scope((Object)"DebugTypeInfo", (Object)this.typeName());){
                action.accept(NativeImageDebugInfoProvider.this.debugContext);
            }
            catch (Throwable e) {
                throw NativeImageDebugInfoProvider.this.debugContext.handle(e);
            }
        }

        public String typeName() {
            return this.typeName;
        }

        public DebugInfoProvider.DebugTypeInfo.DebugTypeKind typeKind() {
            return DebugInfoProvider.DebugTypeInfo.DebugTypeKind.HEADER;
        }

        public String fileName() {
            return "";
        }

        public Path filePath() {
            return null;
        }

        public Path cachePath() {
            return null;
        }

        public int size() {
            return this.size;
        }

        public Stream<DebugInfoProvider.DebugFieldInfo> fieldInfoProvider() {
            return this.fieldInfos.stream();
        }
    }

    private abstract class NativeImageDebugTypeInfo
    extends NativeImageDebugFileInfo
    implements DebugInfoProvider.DebugTypeInfo {
        protected final HostedType hostedType;

        protected NativeImageDebugTypeInfo(HostedType hostedType) {
            super(hostedType);
            this.hostedType = hostedType;
        }

        public void debugContext(Consumer<DebugContext> action) {
            try (DebugContext.Scope s = NativeImageDebugInfoProvider.this.debugContext.scope((Object)"DebugTypeInfo", (Object)this.typeName());){
                action.accept(NativeImageDebugInfoProvider.this.debugContext);
            }
            catch (Throwable e) {
                throw NativeImageDebugInfoProvider.this.debugContext.handle(e);
            }
        }

        public String toJavaName(HostedType hostedType) {
            return NativeImageDebugInfoProvider.getDeclaringClass(hostedType, true).toJavaName();
        }

        public String typeName() {
            return this.toJavaName(this.hostedType);
        }

        public int size() {
            if (this.hostedType instanceof HostedInstanceClass) {
                return ((HostedInstanceClass)this.hostedType).getInstanceSize();
            }
            if (this.hostedType instanceof HostedArrayClass) {
                return NativeImageDebugInfoProvider.getObjectLayout().getArrayBaseOffset(this.hostedType.getComponentType().getStorageKind());
            }
            if (this.hostedType instanceof HostedInterface) {
                return NativeImageDebugInfoProvider.getObjectLayout().getFirstFieldOffset();
            }
            assert (this.hostedType instanceof HostedPrimitiveType);
            JavaKind javaKind = this.hostedType.getStorageKind();
            return javaKind == JavaKind.Void ? 0 : javaKind.getByteCount();
        }
    }

    private abstract class NativeImageDebugFileInfo
    implements DebugInfoProvider.DebugFileInfo {
        private Path fullFilePath;

        NativeImageDebugFileInfo(HostedType hostedType) {
            ResolvedJavaType javaType = NativeImageDebugInfoProvider.getDeclaringClass(hostedType, false);
            Class<?> clazz = hostedType.getJavaClass();
            SourceManager sourceManager = (SourceManager)ImageSingletons.lookup(SourceManager.class);
            try (DebugContext.Scope s = NativeImageDebugInfoProvider.this.debugContext.scope((Object)"DebugFileInfo", (Object)hostedType);){
                this.fullFilePath = sourceManager.findAndCacheSource(javaType, clazz, NativeImageDebugInfoProvider.this.debugContext);
            }
            catch (Throwable e) {
                throw NativeImageDebugInfoProvider.this.debugContext.handle(e);
            }
        }

        NativeImageDebugFileInfo(HostedMethod hostedMethod) {
            ResolvedJavaType javaType = NativeImageDebugInfoProvider.getDeclaringClass(hostedMethod, false);
            HostedType hostedType = hostedMethod.getDeclaringClass();
            Class<?> clazz = hostedType.getJavaClass();
            SourceManager sourceManager = (SourceManager)ImageSingletons.lookup(SourceManager.class);
            try (DebugContext.Scope s = NativeImageDebugInfoProvider.this.debugContext.scope((Object)"DebugFileInfo", (Object)hostedType);){
                this.fullFilePath = sourceManager.findAndCacheSource(javaType, clazz, NativeImageDebugInfoProvider.this.debugContext);
            }
            catch (Throwable e) {
                throw NativeImageDebugInfoProvider.this.debugContext.handle(e);
            }
        }

        NativeImageDebugFileInfo(HostedField hostedField) {
            ResolvedJavaType javaType = NativeImageDebugInfoProvider.getDeclaringClass(hostedField, false);
            HostedType hostedType = hostedField.getDeclaringClass();
            Class<?> clazz = hostedType.getJavaClass();
            SourceManager sourceManager = (SourceManager)ImageSingletons.lookup(SourceManager.class);
            try (DebugContext.Scope s = NativeImageDebugInfoProvider.this.debugContext.scope((Object)"DebugFileInfo", (Object)hostedType);){
                this.fullFilePath = sourceManager.findAndCacheSource(javaType, clazz, NativeImageDebugInfoProvider.this.debugContext);
            }
            catch (Throwable e) {
                throw NativeImageDebugInfoProvider.this.debugContext.handle(e);
            }
        }

        public String fileName() {
            Path filename;
            if (this.fullFilePath != null && (filename = this.fullFilePath.getFileName()) != null) {
                return filename.toString();
            }
            return "";
        }

        public Path filePath() {
            if (this.fullFilePath != null) {
                return this.fullFilePath.getParent();
            }
            return null;
        }

        public Path cachePath() {
            return NativeImageDebugInfoProvider.this.cachePath;
        }
    }
}

