/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image.sources;

import com.oracle.svm.hosted.image.sources.SourceCache;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.debug.DebugContext;

public class SourceManager {
    SourceCache cache = new SourceCache();
    private static HashMap<ResolvedJavaType, Path> verifiedPaths = new HashMap();
    private static final Path INVALID_PATH = Paths.get("invalid", new String[0]);

    public Path findAndCacheSource(ResolvedJavaType resolvedType, Class<?> clazz, DebugContext debugContext) {
        String packageName;
        Path path = verifiedPaths.get(resolvedType);
        if (path != null) {
            return path != INVALID_PATH ? path : null;
        }
        String fileName = SourceManager.computeBaseName(resolvedType);
        if (fileName != null && (resolvedType.isInstanceClass() || resolvedType.isInterface()) && (path = this.locateSource(fileName, packageName = SourceManager.computePackageName(resolvedType), clazz)) == null) {
            if (debugContext.areScopesEnabled()) {
                debugContext.log(2, "Failed to find source file for class %s\n", (Object)resolvedType.toJavaName());
            }
            if (packageName.length() > 0) {
                path = Paths.get("", packageName.split("\\."));
                path = path.resolve(fileName);
            }
        }
        verifiedPaths.put(resolvedType, path != null ? path : INVALID_PATH);
        return path;
    }

    private static String computeBaseName(ResolvedJavaType resolvedType) {
        if (resolvedType.isPrimitive()) {
            return null;
        }
        String fileName = resolvedType.getSourceFileName();
        if (fileName == null) {
            fileName = resolvedType.toJavaName();
            int idx = fileName.lastIndexOf(46);
            if (idx > 0) {
                fileName = fileName.substring(idx + 1);
            }
            if ((idx = fileName.indexOf(36)) == 0) {
                fileName = null;
            } else {
                if (idx > 0) {
                    fileName = fileName.substring(0, idx);
                }
                fileName = fileName + ".java";
            }
        }
        return fileName;
    }

    private static String computePackageName(ResolvedJavaType javaType) {
        String name = javaType.toClassName();
        int idx = name.lastIndexOf(46);
        if (idx > 0) {
            return name.substring(0, idx);
        }
        return "";
    }

    private static Path computePrototypeName(String fileName, String packageName) {
        if (packageName.length() == 0) {
            return Paths.get("", fileName);
        }
        return Paths.get("", packageName.split("\\.")).resolve(fileName);
    }

    private Path locateSource(String fileName, String packagename, Class<?> clazz) {
        Path prototypeName = SourceManager.computePrototypeName(fileName, packagename);
        if (prototypeName != null) {
            return this.cache.resolve(prototypeName, clazz);
        }
        return null;
    }
}

