/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.hosted;

import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.hub.AnnotationTypeSupport;
import com.oracle.svm.core.hub.ClassForNameSupport;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.jdk.RecordSupport;
import com.oracle.svm.core.jdk.proxy.DynamicProxyRegistry;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ConditionalConfigurationRegistry;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.substitute.SubstitutionReflectivityFilter;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.RuntimeReflectionSupport;
import org.graalvm.util.GuardedAnnotationAccess;
import sun.reflect.annotation.TypeAnnotation;
import sun.reflect.annotation.TypeAnnotationParser;

public class ReflectionDataBuilder
extends ConditionalConfigurationRegistry
implements RuntimeReflectionSupport {
    public static final Field[] EMPTY_FIELDS = new Field[0];
    public static final Method[] EMPTY_METHODS = new Method[0];
    public static final Constructor<?>[] EMPTY_CONSTRUCTORS = new Constructor[0];
    public static final Class<?>[] EMPTY_CLASSES = new Class[0];
    private final Set<Class<?>> modifiedClasses = ConcurrentHashMap.newKeySet();
    private boolean sealed;
    private final DynamicHub.ReflectionData arrayReflectionData;
    private final Set<Class<?>> reflectionClasses = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<Executable> reflectionMethods = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<Field> reflectionFields = Collections.newSetFromMap(new ConcurrentHashMap());
    private Set<Executable> queriedMethods;
    private Set<AnalysisMethod> hiddenMethods;
    private final Set<Class<?>> processedClasses = new HashSet();
    private final ReflectionDataAccessors accessors;
    private final Map<AnalysisMethod, Set<AnalysisType>> seenHiddenMethods = new HashMap<AnalysisMethod, Set<AnalysisType>>();
    private static final Method parseAllTypeAnnotations = ReflectionUtil.lookupMethod(TypeAnnotationParser.class, (String)"parseAllTypeAnnotations", (Class[])new Class[]{AnnotatedElement.class});
    private static final Set<Type> seenTypes = new HashSet<Type>();

    public ReflectionDataBuilder(FeatureImpl.FeatureAccessImpl access) {
        this.arrayReflectionData = ReflectionDataBuilder.getArrayReflectionData();
        this.accessors = new ReflectionDataAccessors(access);
        if (SubstrateOptions.ConfigureReflectionMetadata.getValue().booleanValue()) {
            this.queriedMethods = ConcurrentHashMap.newKeySet();
            this.hiddenMethods = ConcurrentHashMap.newKeySet();
        }
    }

    private static DynamicHub.ReflectionData getArrayReflectionData() {
        Method[] publicArrayMethods;
        try {
            Method getPublicMethodsMethod = ReflectionUtil.lookupMethod(Class.class, (String)"privateGetPublicMethods", (Class[])new Class[0]);
            publicArrayMethods = (Method[])getPublicMethodsMethod.invoke(Object[].class, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw VMError.shouldNotReachHere(e);
        }
        return DynamicHub.ReflectionData.get(EMPTY_FIELDS, EMPTY_FIELDS, EMPTY_FIELDS, EMPTY_METHODS, publicArrayMethods, EMPTY_CONSTRUCTORS, EMPTY_CONSTRUCTORS, null, EMPTY_FIELDS, EMPTY_METHODS, EMPTY_CLASSES, EMPTY_CLASSES, null, null);
    }

    public void register(ConfigurationCondition condition, Class<?> ... classes) {
        this.checkNotSealed();
        this.registerConditionalConfiguration(condition, () -> this.registerClasses(classes));
    }

    private void registerClasses(Class<?>[] classes) {
        for (Class<?> clazz : classes) {
            if (!this.reflectionClasses.add(clazz)) continue;
            this.modifiedClasses.add(clazz);
        }
    }

    public void register(ConfigurationCondition condition, boolean queriedOnly, Executable ... methods) {
        this.checkNotSealed();
        if (queriedOnly && !SubstrateOptions.ConfigureReflectionMetadata.getValue().booleanValue()) {
            throw UserError.abort("Found manual reflection metadata configuration. Please use --configure-reflection-metadata to enable this behavior.", new Object[0]);
        }
        this.registerConditionalConfiguration(condition, () -> this.registerMethods(queriedOnly, methods));
    }

    private void registerMethods(boolean queriedOnly, Executable[] methods) {
        for (Executable method : methods) {
            boolean added;
            boolean bl = added = queriedOnly ? this.queriedMethods.add(method) : this.reflectionMethods.add(method);
            if (!added) continue;
            this.modifiedClasses.add(method.getDeclaringClass());
        }
    }

    public void register(ConfigurationCondition condition, boolean finalIsWritable, Field ... fields) {
        this.checkNotSealed();
        this.registerConditionalConfiguration(condition, () -> this.registerFields(fields));
    }

    private void registerFields(Field[] fields) {
        for (Field field : fields) {
            if (!this.reflectionFields.add(field)) continue;
            this.modifiedClasses.add(field.getDeclaringClass());
        }
    }

    private void checkNotSealed() {
        if (this.sealed) {
            throw UserError.abort("Too late to add classes, methods, and fields for reflective access. Registration must happen in a Feature before the analysis has finished.", new Object[0]);
        }
    }

    protected void duringAnalysis(Feature.DuringAnalysisAccess a) {
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        this.processReachableTypes(access);
        this.processRegisteredElements(access);
        this.processMethodMetadata(access);
    }

    private void processReachableTypes(FeatureImpl.DuringAnalysisAccessImpl access) {
        for (AnalysisType type : access.getUniverse().getTypes()) {
            Class originalClass = type.getJavaClass();
            if (originalClass == null || this.processedClasses.contains(originalClass) || type.isArray() && !access.isReachable(type) || !type.isArray() && this.enclosingMethodOrConstructor(originalClass) == null) continue;
            this.processClass(access, originalClass);
            this.processedClasses.add(originalClass);
            access.requireAnalysisIteration();
        }
    }

    protected void processMethodMetadata(FeatureImpl.DuringAnalysisAccessImpl access) {
        if (SubstrateOptions.ConfigureReflectionMetadata.getValue().booleanValue()) {
            AnalysisMethod analysisMethod;
            HashSet<Executable> newQueriedMethods = new HashSet<Executable>();
            for (Executable method : this.queriedMethods) {
                if (!ReflectionDataBuilder.registerMetadataForReflection(access, null, method, true)) continue;
                analysisMethod = access.getMetaAccess().lookupJavaMethod(method);
                this.registerHiddenSubTypeMethods(analysisMethod, analysisMethod.getDeclaringClass());
                newQueriedMethods.add(method);
            }
            this.queriedMethods = newQueriedMethods;
            for (Executable method : this.reflectionMethods) {
                if (SubstitutionReflectivityFilter.shouldExclude(method, access.getMetaAccess(), access.getUniverse())) continue;
                analysisMethod = access.getMetaAccess().lookupJavaMethod(method);
                this.registerHiddenSubTypeMethods(analysisMethod, analysisMethod.getDeclaringClass());
            }
        }
        if (SubstrateOptions.IncludeMethodData.getValue().booleanValue()) {
            for (AnalysisMethod method : access.getUniverse().getMethods()) {
                if (!method.isReachable() || !method.hasJavaMethod()) continue;
                Executable reflectMethod = method.getJavaMethod();
                ReflectionDataBuilder.registerMetadataForReflection(access, method, reflectMethod, false);
            }
        }
    }

    private void registerHiddenSubTypeMethods(AnalysisMethod method, AnalysisType type) {
        if (!(type.equals((Object)method.getDeclaringClass()) || !type.isReachable() || this.seenHiddenMethods.containsKey(method) && this.seenHiddenMethods.get(method).contains(type))) {
            this.seenHiddenMethods.computeIfAbsent(method, m -> new HashSet()).add(type);
            try {
                AnalysisMethod subClassMethod = type.findMethod(method.getName(), (Signature)method.getSignature());
                if (subClassMethod != null) {
                    this.hiddenMethods.add(subClassMethod);
                }
            }
            catch (UnsupportedFeatureException | LinkageError throwable) {
                // empty catch block
            }
        }
        for (AnalysisType subType : type.getSubTypes()) {
            if (subType.equals((Object)type)) continue;
            this.registerHiddenSubTypeMethods(method, subType);
        }
    }

    private static boolean registerMetadataForReflection(FeatureImpl.DuringAnalysisAccessImpl access, AnalysisMethod method, Executable reflectMethod, boolean complete) {
        if (SubstitutionReflectivityFilter.shouldExclude(reflectMethod, access.getMetaAccess(), access.getUniverse())) {
            return false;
        }
        AnalysisMethod analysisMethod = method == null ? access.getMetaAccess().lookupJavaMethod(reflectMethod) : method;
        ReflectionDataBuilder.makeAnalysisTypeReachable(access, analysisMethod.getDeclaringClass());
        if (complete) {
            for (TypeVariable<?> type : reflectMethod.getTypeParameters()) {
                ReflectionDataBuilder.makeTypeReachable(access, type, true);
            }
            for (Type paramType : analysisMethod.getGenericParameterTypes()) {
                ReflectionDataBuilder.makeTypeReachable(access, paramType, true);
            }
            if (!analysisMethod.isConstructor()) {
                ReflectionDataBuilder.makeTypeReachable(access, ((Method)reflectMethod).getGenericReturnType(), true);
            }
            for (Type exceptionType : reflectMethod.getGenericExceptionTypes()) {
                ReflectionDataBuilder.makeTypeReachable(access, exceptionType, true);
            }
            for (Annotation annotation : GuardedAnnotationAccess.getDeclaredAnnotations((AnnotatedElement)analysisMethod)) {
                ReflectionDataBuilder.makeTypeReachable(access, annotation.annotationType(), false);
            }
            Object[] objectArray = reflectMethod.getParameterAnnotations();
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object parameterAnnotations;
                for (Object parameterAnnotation : parameterAnnotations = objectArray[i]) {
                    ReflectionDataBuilder.makeTypeReachable(access, parameterAnnotation.annotationType(), false);
                }
            }
            try {
                for (TypeAnnotation typeAnnotation : (TypeAnnotation[])parseAllTypeAnnotations.invoke(null, reflectMethod)) {
                    ReflectionDataBuilder.makeTypeReachable(access, typeAnnotation.getAnnotation().annotationType(), false);
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw GraalError.shouldNotReachHere();
            }
        } else {
            for (JavaType paramType : analysisMethod.toParameterTypes()) {
                ReflectionDataBuilder.makeAnalysisTypeReachable(access, (AnalysisType)paramType);
            }
        }
        return true;
    }

    private static void makeTypeReachable(FeatureImpl.DuringAnalysisAccessImpl access, Type type, boolean needsClassForName) {
        block15: {
            block14: {
                if (type == null || seenTypes.contains(type)) {
                    return;
                }
                seenTypes.add(type);
                if (!(type instanceof Class) || SubstitutionReflectivityFilter.shouldExclude((Class)type, access.getMetaAccess(), access.getUniverse())) break block14;
                Class clazz = (Class)type;
                ReflectionDataBuilder.makeAnalysisTypeReachable(access, access.getMetaAccess().lookupJavaType(clazz));
                if (needsClassForName) {
                    if (ClassForNameSupport.forNameOrNull(clazz.getName(), null) == null) {
                        access.requireAnalysisIteration();
                    }
                    ClassForNameSupport.registerClass(clazz);
                }
                if (!clazz.isAnnotation()) break block15;
                ((AnnotationTypeSupport)ImageSingletons.lookup(AnnotationTypeSupport.class)).createInstance(clazz);
                ((DynamicProxyRegistry)ImageSingletons.lookup(DynamicProxyRegistry.class)).addProxyClass(clazz);
                break block15;
            }
            if (type instanceof TypeVariable) {
                for (Type bound : ((TypeVariable)type).getBounds()) {
                    ReflectionDataBuilder.makeTypeReachable(access, bound, needsClassForName);
                }
            } else if (type instanceof GenericArrayType) {
                ReflectionDataBuilder.makeTypeReachable(access, ((GenericArrayType)type).getGenericComponentType(), needsClassForName);
            } else if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                for (Type actualType : parameterizedType.getActualTypeArguments()) {
                    ReflectionDataBuilder.makeTypeReachable(access, actualType, needsClassForName);
                }
                ReflectionDataBuilder.makeTypeReachable(access, parameterizedType.getRawType(), needsClassForName);
                ReflectionDataBuilder.makeTypeReachable(access, parameterizedType.getOwnerType(), needsClassForName);
            } else if (type instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)type;
                for (Type lowerBound : wildcardType.getLowerBounds()) {
                    ReflectionDataBuilder.makeTypeReachable(access, lowerBound, needsClassForName);
                }
                for (Type upperBound : wildcardType.getUpperBounds()) {
                    ReflectionDataBuilder.makeTypeReachable(access, upperBound, needsClassForName);
                }
            }
        }
    }

    private static void makeAnalysisTypeReachable(FeatureImpl.DuringAnalysisAccessImpl access, AnalysisType type) {
        if (type.registerAsReachable()) {
            access.requireAnalysisIteration();
        }
    }

    private void processRegisteredElements(FeatureImpl.DuringAnalysisAccessImpl access) {
        if (this.modifiedClasses.isEmpty()) {
            return;
        }
        access.requireAnalysisIteration();
        for (Class<?> clazz : this.modifiedClasses) {
            this.processClass(access, clazz);
        }
        this.modifiedClasses.clear();
    }

    private void processClass(FeatureImpl.DuringAnalysisAccessImpl access, Class<?> clazz) {
        if (SubstitutionReflectivityFilter.shouldExclude(clazz, access.getMetaAccess(), access.getUniverse())) {
            return;
        }
        AnalysisType type = access.getMetaAccess().lookupJavaType(clazz);
        type.registerAsReachable();
        DynamicHub hub = access.getHostVM().dynamicHub((ResolvedJavaType)type);
        if (this.reflectionClasses.contains(clazz)) {
            ClassForNameSupport.registerClass(clazz);
        }
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        ReflectionDataBuilder.query(clazz::getDeclaredFields, errors);
        ReflectionDataBuilder.query(clazz::getFields, errors);
        ReflectionDataBuilder.query(clazz::getDeclaredMethods, errors);
        ReflectionDataBuilder.query(clazz::getMethods, errors);
        ReflectionDataBuilder.query(clazz::getDeclaredConstructors, errors);
        ReflectionDataBuilder.query(clazz::getConstructors, errors);
        Class[] declaredClasses = ReflectionDataBuilder.query(clazz::getDeclaredClasses, errors);
        Class[] classes = ReflectionDataBuilder.query(clazz::getClasses, errors);
        ReflectionDataBuilder.reportLinkingErrors(clazz, errors);
        Object originalReflectionData = this.accessors.getReflectionData(clazz);
        DynamicHub.ReflectionData reflectionData = type.isArray() ? this.arrayReflectionData : DynamicHub.ReflectionData.get(ReflectionDataBuilder.filterFields(this.accessors.getDeclaredFields(originalReflectionData), this.reflectionFields, access), ReflectionDataBuilder.filterFields(this.accessors.getPublicFields(originalReflectionData), this.reflectionFields, access), ReflectionDataBuilder.filterFields(this.accessors.getPublicFields(originalReflectionData), (Field f) -> this.reflectionFields.contains(f) && !ReflectionDataBuilder.isHiddenIn(f, clazz), access), ReflectionDataBuilder.filterMethods(this.accessors.getDeclaredMethods(originalReflectionData), this.reflectionMethods, access), ReflectionDataBuilder.filterMethods(this.accessors.getPublicMethods(originalReflectionData), this.reflectionMethods, access), ReflectionDataBuilder.filterConstructors(this.accessors.getDeclaredConstructors(originalReflectionData), this.reflectionMethods, access), ReflectionDataBuilder.filterConstructors(this.accessors.getPublicConstructors(originalReflectionData), this.reflectionMethods, access), ReflectionDataBuilder.nullaryConstructor(this.accessors.getDeclaredConstructors(originalReflectionData), this.reflectionMethods, access), ReflectionDataBuilder.filterFields(this.accessors.getDeclaredPublicFields(originalReflectionData), this.reflectionFields, access), ReflectionDataBuilder.filterMethods(this.accessors.getDeclaredPublicMethods(originalReflectionData), this.reflectionMethods, access), ReflectionDataBuilder.filterClasses(declaredClasses, this.reflectionClasses, access), ReflectionDataBuilder.filterClasses(classes, this.reflectionClasses, access), this.enclosingMethodOrConstructor(clazz), this.buildRecordComponents(clazz, access));
        hub.setReflectionData(reflectionData);
    }

    private static <T> T query(Callable<T> callable, List<Throwable> errors) {
        try {
            return callable.call();
        }
        catch (LinkageError | TypeNotPresentException e) {
            errors.add(e);
        }
        catch (Exception e) {
            throw VMError.shouldNotReachHere(e);
        }
        return null;
    }

    private Object[] buildRecordComponents(Class<?> clazz, FeatureImpl.DuringAnalysisAccessImpl access) {
        Method[] filteredMethods;
        RecordSupport support = RecordSupport.singleton();
        if (!support.isRecord(clazz)) {
            return null;
        }
        Method[] allMethods = support.getRecordComponentAccessorMethods(clazz);
        if (allMethods.length == (filteredMethods = ReflectionDataBuilder.filterMethods(allMethods, this.reflectionMethods, access)).length) {
            return support.getRecordComponents(clazz);
        }
        return null;
    }

    private static void reportLinkingErrors(Class<?> clazz, List<Throwable> errors) {
        if (errors.isEmpty()) {
            return;
        }
        String messages = errors.stream().map(e -> e.getClass().getTypeName() + ": " + e.getMessage()).distinct().collect(Collectors.joining(", "));
        System.out.println("Warning: Could not register complete reflection metadata for " + clazz.getTypeName() + ". Reason(s): " + messages);
    }

    protected void afterAnalysis() {
        this.sealed = true;
        if (!this.modifiedClasses.isEmpty()) {
            throw UserError.abort("Registration of classes, methods, and fields for reflective access during analysis must set DuringAnalysisAccess.requireAnalysisIteration().", new Object[0]);
        }
    }

    private static Constructor<?> nullaryConstructor(Object constructors, Set<?> reflectionMethods, FeatureImpl.DuringAnalysisAccessImpl access) {
        if (constructors != null) {
            for (Constructor constructor : (Constructor[])constructors) {
                if (constructor.getParameterCount() != 0 || !reflectionMethods.contains(constructor) || SubstitutionReflectivityFilter.shouldExclude(constructor, access.getMetaAccess(), access.getUniverse())) continue;
                return constructor;
            }
        }
        return null;
    }

    private Executable enclosingMethodOrConstructor(Class<?> clazz) {
        Executable enclosingMethodOrConstructor;
        Constructor<?> enclosingConstructor;
        Method enclosingMethod;
        try {
            enclosingMethod = clazz.getEnclosingMethod();
            enclosingConstructor = clazz.getEnclosingConstructor();
        }
        catch (LinkageError | TypeNotPresentException e) {
            return null;
        }
        catch (InternalError ex) {
            return null;
        }
        if (enclosingMethod == null && enclosingConstructor == null) {
            return null;
        }
        if (enclosingMethod != null && enclosingConstructor != null) {
            throw VMError.shouldNotReachHere("Class has both an enclosingMethod and an enclosingConstructor: " + clazz + ", " + enclosingMethod + ", " + enclosingConstructor);
        }
        Executable executable = enclosingMethodOrConstructor = enclosingMethod != null ? enclosingMethod : enclosingConstructor;
        if (this.reflectionMethods.contains(enclosingMethodOrConstructor)) {
            return enclosingMethodOrConstructor;
        }
        return null;
    }

    private static Field[] filterFields(Object fields, Set<Field> filterSet, FeatureImpl.DuringAnalysisAccessImpl access) {
        return ReflectionDataBuilder.filterFields(fields, filterSet::contains, access);
    }

    private static boolean isHiddenIn(Field field, Class<?> clazz) {
        try {
            return !clazz.getField(field.getName()).equals(field);
        }
        catch (NoSuchFieldException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    private static Field[] filterFields(Object fields, Predicate<Field> filter, FeatureImpl.DuringAnalysisAccessImpl access) {
        if (fields == null) {
            return EMPTY_FIELDS;
        }
        ArrayList<Field> result = new ArrayList<Field>();
        for (Field field : (Field[])fields) {
            if (!filter.test(field) || SubstitutionReflectivityFilter.shouldExclude(field, access.getMetaAccess(), access.getUniverse())) continue;
            result.add(field);
        }
        return result.toArray(EMPTY_FIELDS);
    }

    private static Constructor<?>[] filterConstructors(Object methods, Set<Executable> filter, FeatureImpl.DuringAnalysisAccessImpl access) {
        return (Constructor[])ReflectionDataBuilder.filterMethods((Object)methods, filter, (FeatureImpl.DuringAnalysisAccessImpl)access, (Executable[])EMPTY_CONSTRUCTORS);
    }

    private static Method[] filterMethods(Object methods, Set<Executable> filter, FeatureImpl.DuringAnalysisAccessImpl access) {
        return (Method[])ReflectionDataBuilder.filterMethods((Object)methods, filter, (FeatureImpl.DuringAnalysisAccessImpl)access, (Executable[])EMPTY_METHODS);
    }

    private static <T extends Executable> T[] filterMethods(Object methods, Set<Executable> filter, FeatureImpl.DuringAnalysisAccessImpl access, T[] emptyArray) {
        if (methods == null) {
            return emptyArray;
        }
        ArrayList<Executable> result = new ArrayList<Executable>();
        for (Executable method : (Executable[])methods) {
            if (!filter.contains(method) || SubstitutionReflectivityFilter.shouldExclude(method, access.getMetaAccess(), access.getUniverse())) continue;
            result.add(method);
        }
        return (Executable[])result.toArray(emptyArray);
    }

    private static Class<?>[] filterClasses(Object classes, Set<Class<?>> filter, FeatureImpl.DuringAnalysisAccessImpl access) {
        if (classes == null) {
            return EMPTY_CLASSES;
        }
        ArrayList<Class> result = new ArrayList<Class>();
        for (Class clazz : (Class[])classes) {
            if (!filter.contains(clazz) || SubstitutionReflectivityFilter.shouldExclude(clazz, access.getMetaAccess(), access.getUniverse())) continue;
            result.add(clazz);
        }
        return result.toArray(EMPTY_CLASSES);
    }

    public Set<Executable> getQueriedOnlyMethods() {
        return this.queriedMethods != null ? Collections.unmodifiableSet(this.queriedMethods) : Collections.emptySet();
    }

    public Set<ResolvedJavaMethod> getHiddenMethods() {
        return this.hiddenMethods != null ? Collections.unmodifiableSet(this.hiddenMethods) : Collections.emptySet();
    }

    static final class ReflectionDataAccessors {
        private final Method reflectionDataMethod = ReflectionUtil.lookupMethod(Class.class, (String)"reflectionData", (Class[])new Class[0]);
        private final Field declaredFieldsField;
        private final Field publicFieldsField;
        private final Field declaredMethodsField;
        private final Field publicMethodsField;
        private final Field declaredConstructorsField;
        private final Field publicConstructorsField;
        private final Field declaredPublicFieldsField;
        private final Field declaredPublicMethodsField;

        ReflectionDataAccessors(FeatureImpl.FeatureAccessImpl access) {
            Class<?> originalReflectionDataClass = access.getImageClassLoader().findClassOrFail("java.lang.Class$ReflectionData");
            this.declaredFieldsField = ReflectionUtil.lookupField(originalReflectionDataClass, (String)"declaredFields");
            this.publicFieldsField = ReflectionUtil.lookupField(originalReflectionDataClass, (String)"publicFields");
            this.declaredMethodsField = ReflectionUtil.lookupField(originalReflectionDataClass, (String)"declaredMethods");
            this.publicMethodsField = ReflectionUtil.lookupField(originalReflectionDataClass, (String)"publicMethods");
            this.declaredConstructorsField = ReflectionUtil.lookupField(originalReflectionDataClass, (String)"declaredConstructors");
            this.publicConstructorsField = ReflectionUtil.lookupField(originalReflectionDataClass, (String)"publicConstructors");
            this.declaredPublicFieldsField = ReflectionUtil.lookupField(originalReflectionDataClass, (String)"declaredPublicFields");
            this.declaredPublicMethodsField = ReflectionUtil.lookupField(originalReflectionDataClass, (String)"declaredPublicMethods");
        }

        public Object getReflectionData(Class<?> clazz) {
            try {
                return this.reflectionDataMethod.invoke(clazz, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw VMError.shouldNotReachHere(e);
            }
        }

        public Object getDeclaredFields(Object obj) {
            try {
                return this.declaredFieldsField.get(obj);
            }
            catch (IllegalAccessException e) {
                throw VMError.shouldNotReachHere(e);
            }
        }

        public Object getPublicFields(Object obj) {
            try {
                return this.publicFieldsField.get(obj);
            }
            catch (IllegalAccessException e) {
                throw VMError.shouldNotReachHere(e);
            }
        }

        public Object getDeclaredMethods(Object obj) {
            try {
                return this.declaredMethodsField.get(obj);
            }
            catch (IllegalAccessException e) {
                throw VMError.shouldNotReachHere(e);
            }
        }

        public Object getPublicMethods(Object obj) {
            try {
                return this.publicMethodsField.get(obj);
            }
            catch (IllegalAccessException e) {
                throw VMError.shouldNotReachHere(e);
            }
        }

        public Object getDeclaredConstructors(Object obj) {
            try {
                return this.declaredConstructorsField.get(obj);
            }
            catch (IllegalAccessException e) {
                throw VMError.shouldNotReachHere(e);
            }
        }

        public Object getPublicConstructors(Object obj) {
            try {
                return this.publicConstructorsField.get(obj);
            }
            catch (IllegalAccessException e) {
                throw VMError.shouldNotReachHere(e);
            }
        }

        public Object getDeclaredPublicFields(Object obj) {
            try {
                return this.declaredPublicFieldsField.get(obj);
            }
            catch (IllegalAccessException e) {
                throw VMError.shouldNotReachHere(e);
            }
        }

        public Object getDeclaredPublicMethods(Object obj) {
            try {
                return this.declaredPublicMethodsField.get(obj);
            }
            catch (IllegalAccessException e) {
                throw VMError.shouldNotReachHere(e);
            }
        }
    }
}

