/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.hosted;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.configure.ConditionalElement;
import com.oracle.svm.core.configure.ConfigurationFile;
import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.core.configure.ReflectionConfigurationParser;
import com.oracle.svm.core.graal.GraalFeature;
import com.oracle.svm.core.reflect.ReflectionAccessorHolder;
import com.oracle.svm.core.reflect.RuntimeReflectionConstructors;
import com.oracle.svm.core.reflect.SubstrateReflectionAccessorFactory;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FallbackFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.analysis.Inflation;
import com.oracle.svm.hosted.config.ConfigurationParserUtils;
import com.oracle.svm.hosted.meta.MethodPointer;
import com.oracle.svm.hosted.snippets.ReflectionPlugins;
import com.oracle.svm.hosted.substitute.AnnotationSubstitutionProcessor;
import com.oracle.svm.reflect.hosted.ReflectionDataBuilder;
import com.oracle.svm.reflect.hosted.ReflectionObjectReplacer;
import com.oracle.svm.reflect.hosted.ReflectiveInvokeMethod;
import com.oracle.svm.reflect.hosted.ReflectiveNewInstanceMethod;
import com.oracle.svm.reflect.target.RuntimeReflectionConstructorsImpl;
import com.oracle.svm.util.ModuleSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.ReflectionRegistry;
import org.graalvm.nativeimage.impl.RuntimeReflectionSupport;

@AutomaticFeature
public class ReflectionFeature
implements GraalFeature {
    private AnnotationSubstitutionProcessor annotationSubstitutions;
    private ReflectionDataBuilder reflectionData;
    private ImageClassLoader loader;
    private AnalysisUniverse aUniverse;
    private int loadedConfigurations;
    final Map<Executable, Object> accessors = new ConcurrentHashMap<Executable, Object>();
    private static final Method invokePrototype = ReflectionUtil.lookupMethod(ReflectionAccessorHolder.class, (String)"invokePrototype", (Class[])new Class[]{Boolean.TYPE, Object.class, Object[].class});
    private static final Method newInstancePrototype = ReflectionUtil.lookupMethod(ReflectionAccessorHolder.class, (String)"newInstancePrototype", (Class[])new Class[]{Object[].class});
    private static final Method methodHandleInvokeErrorMethod = ReflectionUtil.lookupMethod(ReflectionAccessorHolder.class, (String)"methodHandleInvokeError", (Class[])new Class[]{Boolean.TYPE, Object.class, Object[].class});
    private static final Method newInstanceErrorMethod = ReflectionUtil.lookupMethod(ReflectionAccessorHolder.class, (String)"newInstanceError", (Class[])new Class[]{Object[].class});
    FeatureImpl.BeforeAnalysisAccessImpl analysisAccess;

    Object getOrCreateAccessor(Executable member) {
        Object existing = this.accessors.get(member);
        if (existing != null) {
            return existing;
        }
        if (this.analysisAccess == null) {
            throw VMError.shouldNotReachHere("New Method or Constructor found as reachable after static analysis: " + member);
        }
        return this.accessors.computeIfAbsent(member, m -> this.createAccessor((Executable)m));
    }

    private Object createAccessor(Executable member) {
        AnalysisMethod newInstanceMethod;
        String name = SubstrateUtil.uniqueShortName(member);
        if (member instanceof Method) {
            AnalysisMethod invokeMethod;
            if (member.getDeclaringClass() == MethodHandle.class && (member.getName().equals("invoke") || member.getName().equals("invokeExact"))) {
                invokeMethod = this.analysisAccess.getMetaAccess().lookupJavaMethod((Executable)methodHandleInvokeErrorMethod);
            } else {
                ResolvedJavaMethod prototype = this.analysisAccess.getMetaAccess().lookupJavaMethod((Executable)invokePrototype).getWrapped();
                invokeMethod = this.createReflectiveInvokeMethod(name, prototype, (Method)member);
            }
            return ((SubstrateReflectionAccessorFactory)ImageSingletons.lookup(SubstrateReflectionAccessorFactory.class)).createMethodAccessor(member, this.register((ResolvedJavaMethod)invokeMethod));
        }
        Class<?> holder = member.getDeclaringClass();
        if (Modifier.isAbstract(holder.getModifiers()) || holder.isInterface() || holder.isPrimitive() || holder.isArray()) {
            newInstanceMethod = this.analysisAccess.getMetaAccess().lookupJavaMethod((Executable)newInstanceErrorMethod);
        } else {
            ResolvedJavaMethod prototype = this.analysisAccess.getMetaAccess().lookupJavaMethod((Executable)newInstancePrototype).getWrapped();
            newInstanceMethod = this.createReflectiveNewInstanceMethod(name, prototype, (Constructor)member);
        }
        return ((SubstrateReflectionAccessorFactory)ImageSingletons.lookup(SubstrateReflectionAccessorFactory.class)).createConstructorAccessor(member, this.register((ResolvedJavaMethod)newInstanceMethod));
    }

    private CFunctionPointer register(ResolvedJavaMethod method) {
        AnalysisMethod aMethod = method instanceof AnalysisMethod ? (AnalysisMethod)method : this.analysisAccess.getUniverse().lookup((JavaMethod)method);
        this.analysisAccess.registerAsCompiled(aMethod);
        return MethodPointer.factory((ResolvedJavaMethod)aMethod);
    }

    protected ResolvedJavaMethod createReflectiveInvokeMethod(String name, ResolvedJavaMethod prototype, Method method) {
        return new ReflectiveInvokeMethod(name, prototype, method);
    }

    protected ResolvedJavaMethod createReflectiveNewInstanceMethod(String name, ResolvedJavaMethod prototype, Constructor<?> constructor) {
        return new ReflectiveNewInstanceMethod(name, prototype, constructor);
    }

    protected void inspectAccessibleField(Field field) {
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ModuleSupport.exportAndOpenPackageToUnnamed((String)"java.base", (String)"jdk.internal.reflect", (boolean)false);
        this.reflectionData = new ReflectionDataBuilder((FeatureImpl.FeatureAccessImpl)access);
        ImageSingletons.add(RuntimeReflectionSupport.class, (Object)this.reflectionData);
        ImageSingletons.add(RuntimeReflectionConstructors.class, (Object)new RuntimeReflectionConstructorsImpl());
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        this.aUniverse = access.getUniverse();
        access.registerObjectReplacer(new ReflectionObjectReplacer(access.getMetaAccess()));
        ReflectionConfigurationParser<ConditionalElement<Class<?>>> parser = ConfigurationParserUtils.create((ReflectionRegistry)this.reflectionData, access.getImageClassLoader());
        this.loadedConfigurations = ConfigurationParserUtils.parseAndRegisterConfigurations(parser, access.getImageClassLoader(), "reflection", ConfigurationFiles.Options.ReflectionConfigurationFiles, ConfigurationFiles.Options.ReflectionConfigurationResources, ConfigurationFile.REFLECTION.getFileName());
        this.loader = access.getImageClassLoader();
        this.annotationSubstitutions = ((Inflation)access.getBigBang()).getAnnotationSubstitutionProcessor();
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        this.analysisAccess = (FeatureImpl.BeforeAnalysisAccessImpl)access;
        this.reflectionData.flushConditionalConfiguration(access);
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess access) {
        this.reflectionData.flushConditionalConfiguration(access);
        this.reflectionData.duringAnalysis(access);
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.analysisAccess = null;
        this.reflectionData.afterAnalysis();
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        if (!ImageSingletons.contains(FallbackFeature.class)) {
            return;
        }
        FallbackFeature.FallbackImageRequest reflectionFallback = ((FallbackFeature)ImageSingletons.lookup(FallbackFeature.class)).reflectionFallback;
        if (reflectionFallback != null && this.loadedConfigurations == 0) {
            throw reflectionFallback;
        }
    }

    @Override
    public void registerInvocationPlugins(Providers providers, SnippetReflectionProvider snippetReflection, GraphBuilderConfiguration.Plugins plugins, ParsingReason reason) {
        ReflectionPlugins.registerInvocationPlugins(this.loader, snippetReflection, this.annotationSubstitutions, plugins.getClassInitializationPlugin(), plugins.getInvocationPlugins(), this.aUniverse, reason);
    }
}

