/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.proxy.hosted;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.configure.ConfigurationFile;
import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.core.configure.ProxyConfigurationParser;
import com.oracle.svm.core.jdk.proxy.DynamicProxyRegistry;
import com.oracle.svm.hosted.ConfigurationTypeResolver;
import com.oracle.svm.hosted.FallbackFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.config.ConfigurationParserUtils;
import com.oracle.svm.reflect.hosted.ReflectionFeature;
import com.oracle.svm.reflect.proxy.DynamicProxySupport;
import com.oracle.svm.reflect.proxy.hosted.ProxyRegistry;
import java.util.Collections;
import java.util.List;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public final class DynamicProxyFeature
implements Feature {
    private int loadedConfigurations;
    private DynamicProxySupport dynamicProxySupport;

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Collections.singletonList(ReflectionFeature.class);
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        ImageClassLoader imageClassLoader = access.getImageClassLoader();
        this.dynamicProxySupport = new DynamicProxySupport(imageClassLoader.getClassLoader());
        ImageSingletons.add(DynamicProxyRegistry.class, (Object)this.dynamicProxySupport);
        ConfigurationTypeResolver typeResolver = new ConfigurationTypeResolver("resource configuration", imageClassLoader, NativeImageOptions.AllowIncompleteClasspath.getValue());
        ProxyRegistry proxyRegistry = new ProxyRegistry(typeResolver, this.dynamicProxySupport, imageClassLoader);
        ImageSingletons.add(ProxyRegistry.class, (Object)proxyRegistry);
        ProxyConfigurationParser parser = new ProxyConfigurationParser(proxyRegistry, ConfigurationFiles.Options.StrictConfiguration.getValue());
        this.loadedConfigurations = ConfigurationParserUtils.parseAndRegisterConfigurations(parser, imageClassLoader, "dynamic proxy", ConfigurationFiles.Options.DynamicProxyConfigurationFiles, ConfigurationFiles.Options.DynamicProxyConfigurationResources, ConfigurationFile.DYNAMIC_PROXY.getFileName());
    }

    private static ProxyRegistry proxyRegistry() {
        return (ProxyRegistry)ImageSingletons.lookup(ProxyRegistry.class);
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        DynamicProxyFeature.proxyRegistry().flushConditionalConfiguration(access);
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess access) {
        DynamicProxyFeature.proxyRegistry().flushConditionalConfiguration(access);
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        if (!ImageSingletons.contains(FallbackFeature.class)) {
            return;
        }
        FallbackFeature.FallbackImageRequest proxyFallback = ((FallbackFeature)ImageSingletons.lookup(FallbackFeature.class)).proxyFallback;
        if (proxyFallback != null && this.loadedConfigurations == 0) {
            throw proxyFallback;
        }
    }
}

