/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.target;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.jdk.Target_jdk_internal_reflect_ConstantPool;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import sun.reflect.annotation.TypeAnnotation;
import sun.reflect.annotation.TypeAnnotationParser;

@TargetClass(value=TypeAnnotationParser.class)
public final class Target_sun_reflect_annotation_TypeAnnotationParser {
    @Alias
    private static TypeAnnotation[] EMPTY_TYPE_ANNOTATION_ARRAY;

    @Alias
    public static native AnnotatedType buildAnnotatedType(byte[] var0, Target_jdk_internal_reflect_ConstantPool var1, AnnotatedElement var2, Class<?> var3, Type var4, TypeAnnotation.TypeAnnotationTarget var5);

    @Alias
    public static native AnnotatedType[] buildAnnotatedTypes(byte[] var0, Target_jdk_internal_reflect_ConstantPool var1, AnnotatedElement var2, Class<?> var3, Type[] var4, TypeAnnotation.TypeAnnotationTarget var5);

    @Substitute
    private static TypeAnnotation[] parseTypeAnnotations(byte[] rawAnnotations, Target_jdk_internal_reflect_ConstantPool cp, AnnotatedElement baseDecl, Class<?> container) {
        if (rawAnnotations == null) {
            return EMPTY_TYPE_ANNOTATION_ARRAY;
        }
        ByteBuffer buf = ByteBuffer.wrap(rawAnnotations);
        buf.order(ConfigurationValues.getTarget().arch.getByteOrder());
        int annotationCount = buf.getShort() & 0xFFFF;
        ArrayList<TypeAnnotation> typeAnnotations = new ArrayList<TypeAnnotation>(annotationCount);
        for (int i = 0; i < annotationCount; ++i) {
            TypeAnnotation ta = Target_sun_reflect_annotation_TypeAnnotationParser.parseTypeAnnotation(buf, cp, baseDecl, container);
            if (ta == null) continue;
            typeAnnotations.add(ta);
        }
        return typeAnnotations.toArray(EMPTY_TYPE_ANNOTATION_ARRAY);
    }

    @Alias
    private static native TypeAnnotation parseTypeAnnotation(ByteBuffer var0, Target_jdk_internal_reflect_ConstantPool var1, AnnotatedElement var2, Class<?> var3);
}

