/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.truffle.TruffleBaseFeature;
import com.oracle.svm.util.ReflectionUtil;
import com.oracle.truffle.api.staticobject.StaticProperty;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import sun.misc.Unsafe;

@TargetClass(className="com.oracle.truffle.api.staticobject.StaticProperty", onlyWith={TruffleBaseFeature.IsEnabled.class})
final class Target_com_oracle_truffle_api_staticobject_StaticProperty {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=OffsetTransformer.class)
    int offset;

    Target_com_oracle_truffle_api_staticobject_StaticProperty() {
    }

    public static final class OffsetTransformer
    implements RecomputeFieldValue.CustomFieldValueTransformer {
        private static final Method staticPropertyGetInternalKind = ReflectionUtil.lookupMethod(StaticProperty.class, (String)"getInternalKindName", (Class[])new Class[0]);

        @Override
        public Object transform(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver, Object originalValue) {
            int indexScale;
            int baseOffset;
            JavaKind javaKind;
            String internalKindName;
            int offset = (Integer)originalValue;
            if (offset == 0) {
                return offset;
            }
            StaticProperty receiverStaticProperty = (StaticProperty)receiver;
            try {
                internalKindName = (String)staticPropertyGetInternalKind.invoke((Object)receiverStaticProperty, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw VMError.shouldNotReachHere(e);
            }
            if (internalKindName.equals("Object")) {
                javaKind = JavaKind.Object;
                baseOffset = Unsafe.ARRAY_OBJECT_BASE_OFFSET;
                indexScale = Unsafe.ARRAY_OBJECT_INDEX_SCALE;
            } else {
                javaKind = JavaKind.Byte;
                baseOffset = Unsafe.ARRAY_BYTE_BASE_OFFSET;
                indexScale = Unsafe.ARRAY_BYTE_INDEX_SCALE;
            }
            assert (offset >= baseOffset && (offset - baseOffset) % indexScale == 0);
            int index = (offset - baseOffset) / indexScale;
            int svmArrayBaseOffset = ConfigurationValues.getObjectLayout().getArrayBaseOffset(javaKind);
            int svmArrayIndexScaleOffset = ConfigurationValues.getObjectLayout().getArrayIndexScale(javaKind);
            return svmArrayBaseOffset + svmArrayIndexScaleOffset * index;
        }
    }
}

