/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

final class PolyglotLoggers {
    private PolyglotLoggers() {
    }

    static Set<String> getInternalIds() {
        return Collections.singleton("engine");
    }

    static LoggerCache defaultSPI() {
        return LoggerCacheImpl.DEFAULT;
    }

    static LoggerCache createEngineSPI(PolyglotEngineImpl engine) {
        return LoggerCacheImpl.newEngineLoggerCache(new PolyglotLogHandler(engine), engine, true, new Level[0]);
    }

    static PolyglotContextImpl getCurrentOuterContext() {
        PolyglotContextImpl currentContext = PolyglotContextImpl.currentNotEntered();
        if (currentContext != null) {
            while (currentContext.parent != null) {
                currentContext = currentContext.parent;
            }
        }
        return currentContext;
    }

    static boolean isSameLogSink(Handler h1, Handler h2) {
        if (h1 == h2) {
            return true;
        }
        if (h1 instanceof PolyglotStreamHandler && h2 instanceof PolyglotStreamHandler) {
            return ((PolyglotStreamHandler)h1).sink == ((PolyglotStreamHandler)h2).sink;
        }
        return false;
    }

    static Supplier<TruffleLogger> createCompilerLoggerProvider(PolyglotEngineImpl engine) {
        return new CompilerLoggerProvider(engine);
    }

    static Handler asHandler(Object logHandlerOrStream) {
        if (logHandlerOrStream == null) {
            return null;
        }
        if (logHandlerOrStream instanceof Handler) {
            return (Handler)logHandlerOrStream;
        }
        if (logHandlerOrStream instanceof OutputStream) {
            return PolyglotLoggers.createStreamHandler((OutputStream)logHandlerOrStream, true, true);
        }
        throw new IllegalArgumentException("Unexpected logHandlerOrStream parameter: " + logHandlerOrStream);
    }

    static Handler createDefaultHandler(OutputStream out) {
        return new PolyglotStreamHandler(out, false, true, true);
    }

    static Handler createStreamHandler(OutputStream out, boolean closeStream, boolean flushOnPublish) {
        return new PolyglotStreamHandler(out, closeStream, flushOnPublish, false);
    }

    static boolean isDefaultHandler(Handler handler) {
        if (!(handler instanceof PolyglotStreamHandler)) {
            return false;
        }
        PolyglotStreamHandler phandler = (PolyglotStreamHandler)handler;
        return phandler.isDefault;
    }

    private static final class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }

        @Override
        public void write(byte[] array, int off, int len) throws IOException {
        }
    }

    private static final class SafeHandler
    extends Handler {
        private final Handler delegate;

        SafeHandler(Handler delegate) {
            Objects.requireNonNull(delegate);
            this.delegate = delegate;
        }

        @Override
        public void publish(LogRecord lr) {
            try {
                this.delegate.publish(lr);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public void flush() {
            this.delegate.flush();
        }

        @Override
        public void close() throws SecurityException {
            this.delegate.close();
        }
    }

    private static final class CompilerLoggerProvider
    implements Supplier<TruffleLogger> {
        private final PolyglotEngineImpl engine;
        private volatile Object loggers;

        CompilerLoggerProvider(PolyglotEngineImpl engine) {
            this.engine = engine;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TruffleLogger get() {
            Object loggersCache = this.loggers;
            if (loggersCache == null) {
                CompilerLoggerProvider compilerLoggerProvider = this;
                synchronized (compilerLoggerProvider) {
                    loggersCache = this.loggers;
                    if (loggersCache == null) {
                        Map<String, Level> levels;
                        LoggerCacheImpl spi;
                        if (this.engine != null) {
                            Handler useHandler = CompilerLoggerProvider.resolveHandler(this.engine.logHandler);
                            spi = LoggerCacheImpl.newEngineLoggerCache(useHandler, this.engine, false, Level.INFO);
                            levels = this.engine.logLevels;
                        } else {
                            OutputStream logOut = EngineAccessor.RUNTIME.getConfiguredLogStream();
                            Handler useHandler = logOut != null ? PolyglotLoggers.createStreamHandler(logOut, false, true) : PolyglotLoggers.createDefaultHandler(PolyglotEngineImpl.ALLOW_IO ? System.err : new NullOutputStream());
                            spi = LoggerCacheImpl.newFallBackLoggerCache(useHandler);
                            levels = Collections.emptyMap();
                        }
                        this.loggers = loggersCache = EngineAccessor.LANGUAGE.createEngineLoggers(spi, levels);
                    }
                }
            }
            return EngineAccessor.LANGUAGE.getLogger("engine", null, loggersCache);
        }

        private static Handler resolveHandler(Handler handler) {
            if (PolyglotLoggers.isDefaultHandler(handler)) {
                OutputStream logOut = EngineAccessor.RUNTIME.getConfiguredLogStream();
                if (logOut != null) {
                    return PolyglotLoggers.createStreamHandler(logOut, false, true);
                }
                return handler;
            }
            return new SafeHandler(handler);
        }
    }

    private static final class PolyglotStreamHandler
    extends StreamHandler {
        private final OutputStream sink;
        private final boolean closeStream;
        private final boolean flushOnPublish;
        private final boolean isDefault;

        PolyglotStreamHandler(OutputStream out, boolean closeStream, boolean flushOnPublish, boolean defaultHandler) {
            super(out, FormatterImpl.INSTANCE);
            this.setLevel(Level.ALL);
            this.sink = out;
            this.closeStream = closeStream;
            this.flushOnPublish = flushOnPublish;
            this.isDefault = defaultHandler;
        }

        @Override
        public synchronized void publish(LogRecord record) {
            super.publish(record);
            if (this.flushOnPublish) {
                this.flush();
            }
        }

        @Override
        public void close() {
            if (this.closeStream) {
                super.close();
            } else {
                this.flush();
            }
        }

        private static final class FormatterImpl
        extends Formatter {
            private static final String FORMAT_FULL = "[%1$s] %2$s: %3$s%4$s%n";
            private static final String FORMAT_NO_LEVEL = "[%1$s] %2$s%3$s%n";
            static final Formatter INSTANCE = new FormatterImpl();

            private FormatterImpl() {
            }

            @Override
            public String format(LogRecord record) {
                String loggerName = FormatterImpl.formatLoggerName(record.getLoggerName());
                String message = this.formatMessage(record);
                String stackTrace = "";
                Throwable exception = record.getThrown();
                if (exception != null) {
                    StringWriter str = new StringWriter();
                    try (PrintWriter out = new PrintWriter(str);){
                        out.println();
                        exception.printStackTrace(out);
                    }
                    stackTrace = str.toString();
                }
                boolean implicit = record.getClass() == ImmutableLogRecord.class && ((ImmutableLogRecord)record).isImplicit();
                return implicit ? String.format(FORMAT_NO_LEVEL, loggerName, message, stackTrace) : String.format(FORMAT_FULL, loggerName, record.getLevel().getName(), message, stackTrace);
            }

            private static String formatLoggerName(String loggerName) {
                String name;
                String id;
                int index = loggerName.indexOf(46);
                if (index < 0) {
                    id = loggerName;
                    name = "";
                } else {
                    id = loggerName.substring(0, index);
                    name = loggerName.substring(index + 1);
                }
                if (name.isEmpty()) {
                    return id;
                }
                StringBuilder sb = new StringBuilder(id);
                sb.append("::");
                sb.append(FormatterImpl.possibleSimpleName(name));
                return sb.toString();
            }

            private static String possibleSimpleName(String loggerName) {
                int index = -1;
                int i = 0;
                while (i >= 0) {
                    if (i + 1 < loggerName.length() && Character.isUpperCase(loggerName.charAt(i + 1))) {
                        index = i + 1;
                        break;
                    }
                    i = loggerName.indexOf(46, i + 1);
                }
                return index < 0 ? loggerName : loggerName.substring(index);
            }
        }
    }

    private static final class ImmutableLogRecord
    extends LogRecord {
        private static final long serialVersionUID = 1L;
        private final boolean implicit;

        ImmutableLogRecord(Level level, String loggerName, String message, String className, String methodName, Object[] parameters, Throwable thrown, boolean implicit) {
            super(level, message);
            super.setLoggerName(loggerName);
            if (className != null) {
                super.setSourceClassName(className);
            }
            if (methodName != null) {
                super.setSourceMethodName(methodName);
            }
            Object[] copy = parameters;
            if (parameters != null && parameters.length > 0) {
                copy = new Object[parameters.length];
                for (int i = 0; i < parameters.length; ++i) {
                    copy[i] = ImmutableLogRecord.safeValue(parameters[i]);
                }
            }
            super.setParameters(copy);
            super.setThrown(thrown);
            this.implicit = implicit;
        }

        @Override
        public void setLevel(Level level) {
            throw new UnsupportedOperationException("Setting Level is not supported.");
        }

        @Override
        public void setLoggerName(String name) {
            throw new UnsupportedOperationException("Setting Logger Name is not supported.");
        }

        @Override
        public void setMessage(String message) {
            throw new UnsupportedOperationException("Setting Messag is not supported.");
        }

        @Override
        public void setMillis(long millis) {
            throw new UnsupportedOperationException("Setting Millis is not supported.");
        }

        @Override
        public void setParameters(Object[] parameters) {
            throw new UnsupportedOperationException("Setting Parameters is not supported.");
        }

        @Override
        public void setResourceBundle(ResourceBundle bundle) {
            throw new UnsupportedOperationException("Setting Resource Bundle is not supported.");
        }

        @Override
        public void setResourceBundleName(String name) {
            throw new UnsupportedOperationException("Setting Resource Bundle Name is not supported.");
        }

        @Override
        public void setSequenceNumber(long seq) {
            throw new UnsupportedOperationException("Setting Sequence Number is not supported.");
        }

        @Override
        public void setSourceClassName(String sourceClassName) {
            throw new UnsupportedOperationException("Setting Parameters is not supported.");
        }

        @Override
        public void setSourceMethodName(String sourceMethodName) {
            throw new UnsupportedOperationException("Setting Source Method Name is not supported.");
        }

        @Override
        public void setThreadID(int threadID) {
            throw new UnsupportedOperationException("Setting Thread ID is not supported.");
        }

        @Override
        public void setThrown(Throwable thrown) {
            throw new UnsupportedOperationException("Setting Throwable is not supported.");
        }

        boolean isImplicit() {
            return this.implicit;
        }

        private static Object safeValue(Object param) {
            if (param == null || EngineAccessor.EngineImpl.isPrimitive(param)) {
                return param;
            }
            try {
                return InteropLibrary.getFactory().getUncached().asString(InteropLibrary.getFactory().getUncached().toDisplayString(param));
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere(e);
            }
        }
    }

    private static final class PolyglotLogHandler
    extends Handler {
        private static final Handler INSTANCE = new PolyglotLogHandler();
        private final Handler fallBackHandler;

        PolyglotLogHandler() {
            this.fallBackHandler = null;
        }

        PolyglotLogHandler(PolyglotEngineImpl engine) {
            this.fallBackHandler = engine.logHandler;
        }

        @Override
        public void publish(LogRecord record) {
            Handler handler = PolyglotLogHandler.findDelegate();
            if (handler == null) {
                handler = this.fallBackHandler;
            }
            if (handler != null) {
                handler.publish(record);
            }
        }

        @Override
        public void flush() {
            Handler handler = PolyglotLogHandler.findDelegate();
            if (handler != null) {
                handler.flush();
            }
        }

        @Override
        public void close() throws SecurityException {
            Handler handler = PolyglotLogHandler.findDelegate();
            if (handler != null) {
                handler.close();
            }
        }

        private static Handler findDelegate() {
            PolyglotContextImpl currentContext = PolyglotLoggers.getCurrentOuterContext();
            return currentContext != null ? currentContext.config.logHandler : null;
        }

        static /* synthetic */ Handler access$200() {
            return INSTANCE;
        }
    }

    private static final class LoggerCacheImpl
    implements LoggerCache {
        static final LoggerCache DEFAULT = new LoggerCacheImpl(PolyglotLogHandler.access$200(), null, true, null, new Level[0]);
        private final Handler handler;
        private final boolean useCurrentContext;
        private final Reference<PolyglotEngineImpl> engineRef;
        private final Map<String, Level> defaultValue;
        private final Set<Level> implicitLevels;

        private LoggerCacheImpl(Handler handler, PolyglotEngineImpl engine, boolean useCurrentContext, Map<String, Level> defaultValue, Level ... implicitLevels) {
            Objects.requireNonNull(handler);
            this.handler = handler;
            this.useCurrentContext = useCurrentContext;
            this.engineRef = engine == null ? null : new WeakReference<PolyglotEngineImpl>(engine);
            this.defaultValue = defaultValue;
            if (implicitLevels.length == 0) {
                this.implicitLevels = Collections.emptySet();
            } else {
                this.implicitLevels = new HashSet<Level>();
                Collections.addAll(this.implicitLevels, implicitLevels);
            }
        }

        static LoggerCacheImpl newEngineLoggerCache(Handler handler, PolyglotEngineImpl engine, boolean useCurrentContext, Level ... implicitLevels) {
            return new LoggerCacheImpl(handler, Objects.requireNonNull(engine), useCurrentContext, null, implicitLevels);
        }

        static LoggerCacheImpl newFallBackLoggerCache(Handler handler) {
            return new LoggerCacheImpl(handler, null, false, Collections.emptyMap(), Level.INFO);
        }

        @Override
        public PolyglotEngineImpl getEngine() {
            return this.engineRef == null ? null : this.engineRef.get();
        }

        @Override
        public Handler getLogHandler() {
            return this.handler;
        }

        @Override
        public Map<String, Level> getLogLevels() {
            PolyglotContextImpl context;
            if (this.useCurrentContext && (context = PolyglotLoggers.getCurrentOuterContext()) != null) {
                return context.config.logLevels;
            }
            PolyglotEngineImpl engine = this.getEngine();
            if (engine != null) {
                return engine.logLevels;
            }
            return this.defaultValue;
        }

        @Override
        public LogRecord createLogRecord(Level level, String loggerName, String message, String className, String methodName, Object[] parameters, Throwable thrown) {
            return new ImmutableLogRecord(level, loggerName, message, className, methodName, parameters, thrown, this.implicitLevels.contains(level));
        }
    }

    static interface LoggerCache {
        public Handler getLogHandler();

        public Map<String, Level> getLogLevels();

        public PolyglotEngineImpl getEngine();

        public LogRecord createLogRecord(Level var1, String var2, String var3, String var4, String var5, Object[] var6, Throwable var7);
    }
}

