/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.HSPolyglotObject;
import com.oracle.truffle.polyglot.enterprise.HSProcess;
import com.oracle.truffle.polyglot.enterprise.HSProcessGen;
import com.oracle.truffle.polyglot.enterprise.HSProcessHandler;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import java.io.IOException;
import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNICalls;
import org.graalvm.jniutils.JNIEntryPoint;
import org.graalvm.jniutils.JNIMethodScope;
import org.graalvm.jniutils.JNIUtil;
import org.graalvm.nativebridge.BinaryInput;
import org.graalvm.nativebridge.BinaryMarshaller;
import org.graalvm.nativebridge.BinaryOutput;
import org.graalvm.nativebridge.ForeignException;
import org.graalvm.nativebridge.JNIClassCache;
import org.graalvm.nativebridge.JNIConfig;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.polyglot.io.ProcessHandler;
import org.graalvm.word.PointerBase;

final class HSProcessHandlerGen {
    HSProcessHandlerGen() {
    }

    static HSProcessHandler createNativeToHS(JNI.JNIEnv jNIEnv, JNI.JObject jObject) {
        return new StartPoint(jNIEnv, jObject);
    }

    private static final class StartPoint
    extends HSProcessHandler {
        private static final BinaryMarshaller<ProcessHandler.ProcessCommand> processCommandMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;
        final JNIData jniMethods_;

        StartPoint(JNI.JNIEnv jNIEnv, JNI.JObject jObject) {
            super(jNIEnv, jObject);
            JNIData jNIData = JNIData.cache_;
            if (jNIData == null) {
                jNIData = JNIData.cache_ = new JNIData(jNIEnv);
            }
            this.jniMethods_ = jNIData;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Process start(ProcessHandler.ProcessCommand processCommand) throws IOException {
            HSProcess hSProcess;
            block15: {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get((int)256);
                int n3 = processCommandMarshaller.inferSize((Object)processCommand);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc((int)n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = BinaryOutput.create((CCharPointer)cCharPointer, (int)n2, (boolean)false);){
                        processCommandMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, (Object)processCommand);
                        int n4 = cCharPointerBinaryOutput.getPosition();
                        jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)n4);
                        JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n4, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    }
                    cCharPointerBinaryOutput = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
                    cCharPointerBinaryOutput.addressOf(0).setJObject(this.getHandle());
                    cCharPointerBinaryOutput.addressOf(1).setJObject((JNI.JObject)jByteArray);
                    JNI.JObject jObject = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.startMethod, (JNI.JValue)cCharPointerBinaryOutput);
                    HSProcess hSProcess2 = hSProcess = jObject.isNonNull() ? HSProcessGen.createNativeToHS(new HSPolyglotObject(jNIEnv, jObject), jNIEnv) : null;
                    if (cCharPointer == cCharPointer2) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free((PointerBase)cCharPointer);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free((PointerBase)cCharPointer);
            }
            return hSProcess;
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            processCommandMarshaller = jNIConfig.lookupMarshaller(ProcessHandler.ProcessCommand.class, new Class[0]);
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }

        static final class JNIData {
            static JNIData cache_;
            final JNI.JClass endPointClass;
            final JNICalls.JNIMethod startMethod;

            JNIData(JNI.JNIEnv jNIEnv) {
                this.endPointClass = JNIClassCache.lookupClass((JNI.JNIEnv)jNIEnv, EndPoint.class);
                this.startMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"start", (String)"(Lorg/graalvm/polyglot/io/ProcessHandler;[B)Ljava/lang/Process;");
            }
        }
    }

    private static class EndPoint {
        private static final BinaryMarshaller<ProcessHandler.ProcessCommand> processCommandMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        private EndPoint() {
        }

        @JNIEntryPoint
        static Process start(ProcessHandler processHandler, byte[] byArray) {
            try {
                BinaryInput binaryInput = BinaryInput.create((byte[])byArray);
                ProcessHandler.ProcessCommand processCommand = (ProcessHandler.ProcessCommand)processCommandMarshaller.read(binaryInput);
                Process process = processHandler.start(processCommand);
                return process;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            processCommandMarshaller = jNIConfig.lookupMarshaller(ProcessHandler.ProcessCommand.class, new Class[0]);
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }
}

