/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.NativeLanguageDispatch;
import com.oracle.truffle.polyglot.enterprise.NativeOptionDescriptorsGen;
import com.oracle.truffle.polyglot.enterprise.PolyglotIsolateGuestFeatureEnabled;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNIMethodScope;
import org.graalvm.jniutils.JNIUtil;
import org.graalvm.nativebridge.BinaryInput;
import org.graalvm.nativebridge.BinaryMarshaller;
import org.graalvm.nativebridge.BinaryOutput;
import org.graalvm.nativebridge.ForeignException;
import org.graalvm.nativebridge.JNIConfig;
import org.graalvm.nativebridge.NativeIsolateThread;
import org.graalvm.nativebridge.NativeObject;
import org.graalvm.nativebridge.NativeObjectHandles;
import org.graalvm.nativebridge.TypeLiteral;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.word.WordFactory;

final class NativeLanguageDispatchGen {
    NativeLanguageDispatchGen() {
    }

    static NativeLanguageDispatch createHSToNative(AbstractPolyglotImpl abstractPolyglotImpl) {
        return new StartPoint(abstractPolyglotImpl);
    }

    static NativeLanguageDispatch createNativeToNative(AbstractPolyglotImpl abstractPolyglotImpl) {
        return new StartPoint(abstractPolyglotImpl);
    }

    static NativeLanguageDispatch create(AbstractPolyglotImpl abstractPolyglotImpl) {
        if (ImageInfo.inImageCode()) {
            return NativeLanguageDispatchGen.createNativeToNative(abstractPolyglotImpl);
        }
        return NativeLanguageDispatchGen.createHSToNative(abstractPolyglotImpl);
    }

    private static final class StartPoint
    extends NativeLanguageDispatch {
        private static final BinaryMarshaller<Set<String>> setOfStringMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;
        private final Map<Object, Set<String>> getMimeTypesCache = Collections.synchronizedMap(new WeakHashMap());
        private final Map<Object, OptionDescriptors> getOptionsCache = Collections.synchronizedMap(new WeakHashMap());

        StartPoint(AbstractPolyglotImpl abstractPolyglotImpl) {
            super(abstractPolyglotImpl);
        }

        public String getDefaultMimeType(Object object) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                String string = StartPoint.getDefaultMimeType0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle());
                return string;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        public String getId(Object object) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                String string = StartPoint.getId0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle());
                return string;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        public String getImplementationName(Object object) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                String string = StartPoint.getImplementationName0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle());
                return string;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public Set<String> getMimeTypes(Object object) {
            Set set = this.getMimeTypesCache.get(object);
            if (set == null) {
                NativeObject nativeObject = (NativeObject)object;
                NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
                try {
                    byte[] byArray = StartPoint.getMimeTypes0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle());
                    BinaryInput binaryInput = BinaryInput.create((byte[])byArray);
                    set = (Set)setOfStringMarshaller.read(binaryInput);
                    this.getMimeTypesCache.put(object, set);
                }
                catch (ForeignException foreignException) {
                    throw foreignException.throwOriginalException(throwableMarshaller);
                }
                finally {
                    nativeIsolateThread.leave();
                }
            }
            return set;
        }

        public String getName(Object object) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                String string = StartPoint.getName0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle());
                return string;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public OptionDescriptors getOptions(Object object) {
            OptionDescriptors optionDescriptors = this.getOptionsCache.get(object);
            if (optionDescriptors == null) {
                NativeObject nativeObject = (NativeObject)object;
                NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
                try {
                    long l2 = StartPoint.getOptions0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle());
                    optionDescriptors = l2 != 0L ? NativeOptionDescriptorsGen.create(nativeObject.getIsolate(), l2) : null;
                    this.getOptionsCache.put(object, optionDescriptors);
                }
                catch (ForeignException foreignException) {
                    throw foreignException.throwOriginalException(throwableMarshaller);
                }
                finally {
                    nativeIsolateThread.leave();
                }
            }
            return optionDescriptors;
        }

        public String getVersion(Object object) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                String string = StartPoint.getVersion0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle());
                return string;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        public String getWebsite(Object object) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                String string = StartPoint.getWebsite0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle());
                return string;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        public boolean isInteractive(Object object) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                boolean bl = StartPoint.isInteractive0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle());
                return bl;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        private static native String getDefaultMimeType0(long var0, long var2);

        private static native String getId0(long var0, long var2);

        private static native String getImplementationName0(long var0, long var2);

        private static native byte[] getMimeTypes0(long var0, long var2);

        private static native String getName0(long var0, long var2);

        private static native long getOptions0(long var0, long var2);

        private static native String getVersion0(long var0, long var2);

        private static native String getWebsite0(long var0, long var2);

        private static native boolean isInteractive0(long var0, long var2);

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            setOfStringMarshaller = jNIConfig.lookupMarshaller((TypeLiteral)new TypeLiteral<Set<String>>(){}, new Class[0]);
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }

    private static final class EndPoint {
        private static final BinaryMarshaller<Set<String>> setOfStringMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        private EndPoint() {
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeLanguageDispatchGen_00024StartPoint_getDefaultMimeType0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static JNI.JString getDefaultMimeType(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeLanguageDispatchGen::getDefaultMimeType", jNIEnv);
            try (JNIMethodScope jNIMethodScope2 = jNIMethodScope;){
                Object object = NativeObjectHandles.resolve((long)l3, Object.class);
                AbstractPolyglotImpl.AbstractLanguageDispatch abstractLanguageDispatch = NativeLanguageDispatch.resolveNativeDelegate(object);
                Object object2 = NativeLanguageDispatch.resolveReceiver(object);
                String string = abstractLanguageDispatch.getDefaultMimeType(object2);
                jNIMethodScope.setObjectResult((JNI.JObject)JNIUtil.createHSString((JNI.JNIEnv)jNIEnv, (String)string));
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
                jNIMethodScope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
            }
            return (JNI.JString)jNIMethodScope.getObjectResult();
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeLanguageDispatchGen_00024StartPoint_getId0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static JNI.JString getId(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeLanguageDispatchGen::getId", jNIEnv);
            try (JNIMethodScope jNIMethodScope2 = jNIMethodScope;){
                Object object = NativeObjectHandles.resolve((long)l3, Object.class);
                AbstractPolyglotImpl.AbstractLanguageDispatch abstractLanguageDispatch = NativeLanguageDispatch.resolveNativeDelegate(object);
                Object object2 = NativeLanguageDispatch.resolveReceiver(object);
                String string = abstractLanguageDispatch.getId(object2);
                jNIMethodScope.setObjectResult((JNI.JObject)JNIUtil.createHSString((JNI.JNIEnv)jNIEnv, (String)string));
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
                jNIMethodScope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
            }
            return (JNI.JString)jNIMethodScope.getObjectResult();
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeLanguageDispatchGen_00024StartPoint_getImplementationName0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static JNI.JString getImplementationName(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeLanguageDispatchGen::getImplementationName", jNIEnv);
            try (JNIMethodScope jNIMethodScope2 = jNIMethodScope;){
                Object object = NativeObjectHandles.resolve((long)l3, Object.class);
                AbstractPolyglotImpl.AbstractLanguageDispatch abstractLanguageDispatch = NativeLanguageDispatch.resolveNativeDelegate(object);
                Object object2 = NativeLanguageDispatch.resolveReceiver(object);
                String string = abstractLanguageDispatch.getImplementationName(object2);
                jNIMethodScope.setObjectResult((JNI.JObject)JNIUtil.createHSString((JNI.JNIEnv)jNIEnv, (String)string));
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
                jNIMethodScope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
            }
            return (JNI.JString)jNIMethodScope.getObjectResult();
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeLanguageDispatchGen_00024StartPoint_getMimeTypes0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static JNI.JByteArray getMimeTypes(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeLanguageDispatchGen::getMimeTypes", jNIEnv);
            try (JNIMethodScope jNIMethodScope2 = jNIMethodScope;){
                Object object = NativeObjectHandles.resolve((long)l3, Object.class);
                AbstractPolyglotImpl.AbstractLanguageDispatch abstractLanguageDispatch = NativeLanguageDispatch.resolveNativeDelegate(object);
                Object object2 = NativeLanguageDispatch.resolveReceiver(object);
                CCharPointer cCharPointer = (CCharPointer)StackValue.get((int)256);
                Set set = abstractLanguageDispatch.getMimeTypes(object2);
                int n2 = setOfStringMarshaller.inferSize((Object)set);
                try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = n2 > 256 ? BinaryOutput.CCharPointerBinaryOutput.create((int)n2) : BinaryOutput.create((CCharPointer)cCharPointer, (int)256, (boolean)false);){
                    setOfStringMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, (Object)set);
                    int n3 = cCharPointerBinaryOutput.getPosition();
                    JNI.JByteArray jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)n3);
                    JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n3, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    jNIMethodScope.setObjectResult((JNI.JObject)jByteArray);
                }
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
                jNIMethodScope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
            }
            return (JNI.JByteArray)jNIMethodScope.getObjectResult();
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeLanguageDispatchGen_00024StartPoint_getName0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static JNI.JString getName(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeLanguageDispatchGen::getName", jNIEnv);
            try (JNIMethodScope jNIMethodScope2 = jNIMethodScope;){
                Object object = NativeObjectHandles.resolve((long)l3, Object.class);
                AbstractPolyglotImpl.AbstractLanguageDispatch abstractLanguageDispatch = NativeLanguageDispatch.resolveNativeDelegate(object);
                Object object2 = NativeLanguageDispatch.resolveReceiver(object);
                String string = abstractLanguageDispatch.getName(object2);
                jNIMethodScope.setObjectResult((JNI.JObject)JNIUtil.createHSString((JNI.JNIEnv)jNIEnv, (String)string));
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
                jNIMethodScope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
            }
            return (JNI.JString)jNIMethodScope.getObjectResult();
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeLanguageDispatchGen_00024StartPoint_getOptions0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static long getOptions(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            long l4;
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeLanguageDispatchGen::getOptions", jNIEnv);
            try {
                Object object = NativeObjectHandles.resolve((long)l3, Object.class);
                AbstractPolyglotImpl.AbstractLanguageDispatch abstractLanguageDispatch = NativeLanguageDispatch.resolveNativeDelegate(object);
                Object object2 = NativeLanguageDispatch.resolveReceiver(object);
                OptionDescriptors optionDescriptors = abstractLanguageDispatch.getOptions(object2);
                l4 = NativeObjectHandles.create((Object)optionDescriptors);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        jNIMethodScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    ForeignException.forThrowable((Throwable)throwable3, throwableMarshaller).throwUsingJNI(jNIEnv);
                    return 0L;
                }
            }
            jNIMethodScope.close();
            return l4;
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeLanguageDispatchGen_00024StartPoint_getVersion0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static JNI.JString getVersion(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeLanguageDispatchGen::getVersion", jNIEnv);
            try (JNIMethodScope jNIMethodScope2 = jNIMethodScope;){
                Object object = NativeObjectHandles.resolve((long)l3, Object.class);
                AbstractPolyglotImpl.AbstractLanguageDispatch abstractLanguageDispatch = NativeLanguageDispatch.resolveNativeDelegate(object);
                Object object2 = NativeLanguageDispatch.resolveReceiver(object);
                String string = abstractLanguageDispatch.getVersion(object2);
                jNIMethodScope.setObjectResult((JNI.JObject)JNIUtil.createHSString((JNI.JNIEnv)jNIEnv, (String)string));
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
                jNIMethodScope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
            }
            return (JNI.JString)jNIMethodScope.getObjectResult();
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeLanguageDispatchGen_00024StartPoint_getWebsite0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static JNI.JString getWebsite(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeLanguageDispatchGen::getWebsite", jNIEnv);
            try (JNIMethodScope jNIMethodScope2 = jNIMethodScope;){
                Object object = NativeObjectHandles.resolve((long)l3, Object.class);
                AbstractPolyglotImpl.AbstractLanguageDispatch abstractLanguageDispatch = NativeLanguageDispatch.resolveNativeDelegate(object);
                Object object2 = NativeLanguageDispatch.resolveReceiver(object);
                String string = abstractLanguageDispatch.getWebsite(object2);
                jNIMethodScope.setObjectResult((JNI.JObject)JNIUtil.createHSString((JNI.JNIEnv)jNIEnv, (String)string));
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
                jNIMethodScope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
            }
            return (JNI.JString)jNIMethodScope.getObjectResult();
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeLanguageDispatchGen_00024StartPoint_isInteractive0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static boolean isInteractive(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            boolean bl;
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeLanguageDispatchGen::isInteractive", jNIEnv);
            try {
                boolean bl2;
                Object object = NativeObjectHandles.resolve((long)l3, Object.class);
                AbstractPolyglotImpl.AbstractLanguageDispatch abstractLanguageDispatch = NativeLanguageDispatch.resolveNativeDelegate(object);
                Object object2 = NativeLanguageDispatch.resolveReceiver(object);
                bl = bl2 = abstractLanguageDispatch.isInteractive(object2);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        jNIMethodScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    ForeignException.forThrowable((Throwable)throwable3, throwableMarshaller).throwUsingJNI(jNIEnv);
                    return false;
                }
            }
            jNIMethodScope.close();
            return bl;
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            setOfStringMarshaller = jNIConfig.lookupMarshaller((TypeLiteral)new TypeLiteral<Set<String>>(){}, new Class[0]);
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }
}

