/*
 * Decompiled with CFR 0.152.
 */
package grails.util;

import grails.util.Metadata;

public enum BuildScope {
    TEST,
    WAR,
    RUN,
    ALL,
    FUNCTIONAL_TEST;

    public static final String KEY = "grails.buildScope";

    public String toString() {
        return super.toString().toLowerCase();
    }

    public static BuildScope getCurrent() {
        String key = System.getProperty(KEY);
        if (key == null) {
            key = (String)Metadata.getCurrent().get(KEY);
        }
        if (key != null) {
            try {
                return BuildScope.valueOf(key.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return ALL;
            }
        }
        return ALL;
    }

    public static boolean isValid(String ... scopeNames) {
        BuildScope currentScope = BuildScope.getCurrent();
        if (currentScope.equals((Object)ALL)) {
            return true;
        }
        for (String scopeName : scopeNames) {
            BuildScope specifiedScope = BuildScope.valueOf(scopeName.toUpperCase());
            if (currentScope != specifiedScope) continue;
            return true;
        }
        return false;
    }

    public void enable() {
        System.setProperty(KEY, this.toString());
    }
}

